/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.events;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitRenderer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.events.InteractivityEvent;
import com.ibm.vis.interaction.internal.InteractivityImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/interactionLayer")
public class DefenderViewPortEvent
extends InteractivityEvent {
    private double x;
    private final double y;
    private final InteractivityImpl interactivity;

    public DefenderViewPortEvent(String string, double d, double d2, InteractivityImpl interactivityImpl) {
        super(string);
        this.x = d;
        this.y = d2;
        this.interactivity = interactivityImpl;
    }

    public double[] getDefenderViewPortEndPoints() {
        ScrollUnitRenderer scrollUnitRenderer = this.interactivity.getScrollUnitRenderer();
        Shape shape = scrollUnitRenderer.getFirstGrabber();
        Shape shape2 = scrollUnitRenderer.getSecondGrabber();
        Shape shape3 = scrollUnitRenderer.getMainGrabber();
        Shape shape4 = scrollUnitRenderer.getMedian();
        Shape shape5 = shape.makeGeometryClone();
        Shape shape6 = shape2.makeGeometryClone();
        Shape shape7 = shape3.makeGeometryClone();
        Shape shape8 = shape4.makeGeometryClone();
        double[] dArray = this.interactivity.updateScrollUnit(this.getX(), shape5, shape6, shape7, shape8, false);
        return this.interactivity.getXCordinatesForSliderEndPoints(dArray);
    }

    public boolean updateEventForZoomLimit(String string, double d, double d2, double[] dArray) {
        Unit unit = this.interactivity.getZoomUnit();
        Unit unit2 = Unit.get(string, Unit.RATIO);
        double d3 = this.interactivity.getZoomLimit();
        double d4 = UnitConverter.convert(d3, unit, unit2);
        double d5 = dArray[1] - dArray[0];
        double d6 = Math.abs(d2 - this.x);
        double d7 = Math.abs(d - d5);
        double d8 = d4 - d5;
        if (d > d4) {
            double d9 = d8 / d7 * d6;
            this.x = this.x > d2 ? (this.x -= d9) : (this.x += d9);
            return true;
        }
        return false;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final Interactivity getInteractivity() {
        return this.interactivity;
    }
}

