/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.Popup;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.PopupNotchLocation;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.TouchPointSide;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.ui.VisController;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractPopup
implements Popup {
    protected final VisController parentVisControl;
    private Rect itemPosition;
    protected static final double NOTCH_SHARE = 0.1;

    public AbstractPopup(VisController visController) {
        this.parentVisControl = visController;
    }

    @Override
    public final void showPopup(JSONObject jSONObject, SceneItem sceneItem, Point point) {
        if (jSONObject == null) {
            throw new SpecException("Spec string passed to create String is empty", ErrorCode.SPEC_IS_EMPTY, null);
        }
        this.itemPosition = this.makeItemPosition(sceneItem, point);
        this.show(jSONObject);
    }

    @Override
    public final void hidePopup() {
        this.hide();
    }

    protected abstract VisController getPopupVisControl();

    protected abstract void show(JSONObject var1);

    protected abstract void hide();

    protected Rect getPopupBounds() {
        double d;
        double d2;
        double d3;
        double d4;
        Dim dim = this.getPopupVisSize();
        double d5 = dim.getWidth();
        double d6 = dim.getHeight();
        Dim dim2 = this.getParentVisSize();
        double d7 = dim2.getHeight();
        double d8 = dim2.getWidth();
        double d9 = this.itemPosition.getX();
        double d10 = d8 - this.itemPosition.getX2();
        double d11 = this.itemPosition.getY();
        double d12 = d7 - this.itemPosition.getY2();
        double d13 = Math.max(Math.max(d9, d10), Math.max(d11, d12));
        if (d9 == d13) {
            d4 = Math.min(d5, Math.min(d8 / 2.0, d9));
            d3 = this.itemPosition.getX() - d4;
            d2 = Math.min(d6, d7 / 2.0);
            d = Math.max(this.itemPosition.getY() + this.itemPosition.getHeight() / 2.0 - d2 / 2.0, 0.0);
            if (d + d2 >= d7) {
                d = d7 - d2;
            }
        } else if (d10 == d13) {
            d4 = Math.min(d5, Math.min(d8 / 2.0, d10));
            d3 = this.itemPosition.getX() + this.itemPosition.getWidth();
            d2 = Math.min(d6, d7 / 2.0);
            d = Math.max(this.itemPosition.getY() + this.itemPosition.getHeight() / 2.0 - d2 / 2.0, 0.0);
            if (d + d2 >= d7) {
                d = d7 - d2;
            }
        } else if (d11 == d13) {
            d4 = Math.min(d5, d8 / 2.0);
            d3 = Math.max(this.itemPosition.getX() + this.itemPosition.getWidth() / 2.0 - d4 / 2.0, 0.0);
            if (d3 + d4 > d8) {
                d3 = d8 - d4;
            }
            d2 = Math.min(d6, Math.min(d7 / 2.0, d11));
            d = this.itemPosition.getY() - d2;
        } else {
            d4 = Math.min(d5, d8 / 2.0);
            d3 = Math.max(this.itemPosition.getX() + this.itemPosition.getWidth() / 2.0 - d4 / 2.0, 0.0);
            if (d3 + d4 > d8) {
                d3 = d8 - d4;
            }
            d2 = Math.min(d6, Math.min(d7 / 2.0, d12));
            d = this.itemPosition.getY() + this.itemPosition.getHeight();
        }
        return new Rect(d3, d, d4, d2);
    }

    protected PopupNotchLocation getPopupNotchLocation(Rect rect) {
        TouchPointSide touchPointSide = null;
        if (this.itemPosition.getY() >= rect.getY() + rect.getHeight()) {
            touchPointSide = TouchPointSide.BOTTOM;
            double d = this.itemPosition.getX() + this.itemPosition.getWidth() / 2.0 - rect.getX();
            double d2 = d / rect.getWidth();
            return new PopupNotchLocation(d2, touchPointSide);
        }
        if (rect.getY() >= this.itemPosition.getY() + this.itemPosition.getHeight()) {
            touchPointSide = TouchPointSide.TOP;
            double d = this.itemPosition.getX() + this.itemPosition.getWidth() / 2.0 - rect.getX();
            double d3 = d / rect.getWidth();
            return new PopupNotchLocation(d3, touchPointSide);
        }
        if (this.itemPosition.getX() >= rect.getX() + rect.getWidth()) {
            touchPointSide = TouchPointSide.RIGHT;
            double d = this.itemPosition.getY() + this.itemPosition.getHeight() / 2.0 - rect.getY();
            double d4 = d / rect.getHeight();
            return new PopupNotchLocation(d4, touchPointSide);
        }
        touchPointSide = TouchPointSide.LEFT;
        double d = this.itemPosition.getY() + this.itemPosition.getHeight() / 2.0 - rect.getY();
        double d5 = d / rect.getHeight();
        return new PopupNotchLocation(d5, touchPointSide);
    }

    protected static Rect getNotchPanelBounds(Rect rect, PopupNotchLocation popupNotchLocation) {
        switch (popupNotchLocation.side) {
            default: {
                return new Rect(0.0, 0.0, (int)(rect.getWidth() * 0.1), (int)rect.getHeight());
            }
            case RIGHT: {
                return new Rect((int)(rect.getWidth() * 0.9), 0.0, (int)(rect.getWidth() * 0.1), (int)rect.getHeight());
            }
            case TOP: {
                return new Rect(0.0, 0.0, (int)rect.getWidth(), (int)(rect.getHeight() * 0.1));
            }
            case BOTTOM: 
        }
        return new Rect(0.0, (int)(rect.getHeight() * 0.9), (int)rect.getWidth(), (double)((int)rect.getHeight()) * 0.1);
    }

    protected static Rect getNotchBounds(Rect rect, PopupNotchLocation popupNotchLocation) {
        if (TouchPointSide.RIGHT.equals((Object)popupNotchLocation.side) || TouchPointSide.LEFT.equals((Object)popupNotchLocation.side)) {
            double d = rect.getWidth();
            double d2 = rect.getHeight() * popupNotchLocation.zeroOneLocation - d / 2.0;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if (d2 + d > rect.getHeight()) {
                d2 = rect.getHeight() - d;
            }
            return new Rect(0.0, d2, d, d);
        }
        double d = rect.getHeight();
        double d3 = rect.getWidth() * popupNotchLocation.zeroOneLocation - d / 2.0;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 + d > rect.getWidth()) {
            d3 = rect.getWidth() - d;
        }
        return new Rect(d3, 0.0, d, d);
    }

    protected static Rect getPopupVisControlBounds(Rect rect, PopupNotchLocation popupNotchLocation) {
        switch (popupNotchLocation.side) {
            default: {
                return new Rect(rect.getWidth() * 0.1, 0.0, rect.getWidth() * 0.9, rect.getHeight());
            }
            case RIGHT: {
                return new Rect(0.0, 0.0, rect.getWidth() * 0.9, rect.getHeight());
            }
            case TOP: {
                return new Rect(0.0, rect.getHeight() * 0.1, rect.getWidth(), rect.getHeight() * 0.9);
            }
            case BOTTOM: 
        }
        return new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight() * 0.9);
    }

    public static List<Point> getNotchGeometry(Rect rect, PopupNotchLocation popupNotchLocation) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        switch (popupNotchLocation.side) {
            default: {
                d6 = rect.getX();
                d5 = rect.getY() + rect.getHeight() / 2.0;
                d4 = rect.getX() + rect.getWidth();
                d3 = rect.getY();
                d2 = rect.getX() + rect.getWidth();
                d = rect.getY() + rect.getHeight();
                break;
            }
            case RIGHT: {
                d6 = rect.getX() + rect.getWidth();
                d5 = rect.getY() + rect.getHeight() / 2.0;
                d4 = rect.getX();
                d3 = rect.getY() + rect.getHeight();
                d2 = rect.getX();
                d = rect.getY();
                break;
            }
            case TOP: {
                d6 = rect.getX() + rect.getWidth() / 2.0;
                d5 = rect.getY();
                d4 = rect.getX() + rect.getWidth();
                d3 = rect.getY() + rect.getHeight();
                d2 = rect.getX();
                d = rect.getY() + rect.getHeight();
                break;
            }
            case BOTTOM: {
                d6 = rect.getX() + rect.getWidth() / 2.0;
                d5 = rect.getY() + rect.getHeight();
                d4 = rect.getX();
                d3 = rect.getY();
                d2 = rect.getX() + rect.getWidth();
                d = rect.getY();
            }
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(new Point(d6, d5));
        arrayList.add(new Point(d4, d3));
        arrayList.add(new Point(d2, d));
        return arrayList;
    }

    final Rect makeItemPosition(SceneItem sceneItem, Point point) {
        Rect rect;
        Dim dim = this.getParentVisSize();
        if (sceneItem != null && (rect = ((SceneItemImpl)sceneItem).getBounds()).getWidth() < dim.getWidth() / 3.0 && rect.getHeight() < dim.getHeight() / 3.0) {
            return rect;
        }
        if (point != null) {
            return new Rect(point.getX() - 1.0, point.getY() - 1.0, 2.0, 2.0);
        }
        return new Rect(dim.getWidth() / 2.0 - 1.0, dim.getHeight() / 2.0 - 1.0, 2.0, 2.0);
    }

    protected Dim getParentVisSize() {
        return AbstractPopup.getVisSceneSize(this.parentVisControl);
    }

    protected Dim getPopupVisSize() {
        return AbstractPopup.getVisSceneSize(this.getPopupVisControl());
    }

    private static final Dim getVisSceneSize(VisController visController) {
        SceneTree sceneTree;
        InteractivityImpl interactivityImpl = (InteractivityImpl)visController.getInteractivity();
        if (interactivityImpl != null && (sceneTree = interactivityImpl.getSceneState().getSceneTree()) != null) {
            return sceneTree.getScaledSize();
        }
        return new Dim(0.0, 0.0);
    }
}

