/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.interaction.GraphInteractivity;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GraphInteractivityImpl
extends GraphInteractivity {
    private static final int NO_STATE = 0;
    private static final int EXPAND_STATE = 1;
    private static final int COLLAPSE_STATE = 2;
    private static final String LAYOUT_METHOD_TREE = "tree";
    private static final String LAYOUT_METHOD_DAG = "dag";
    private static final String LAYOUT_METHOD_LINK = "link";
    private final InteractivityImpl interactivity;
    private final Vis vis;
    private int grammarIndex = 0;
    private LayoutSpec nodeSpecs;
    private DataSpec nodeData;
    private LayoutSpec linkSpecs;
    private DataSpec linkData;
    private int idFieldIndex = -1;
    private int fromFieldIndex = -1;
    private int toFieldIndex = -1;
    private int inIconFieldIndex = -1;
    private int outIconFieldIndex = -1;
    private int centerNowRow = -1;
    private List<Number> allParents;
    private List<Number[]> allParentsEdges;
    private List<Number> allChildren;
    private List<Number[]> allChildrenEdges;
    private List<Number> prunedNodes;
    private List<Number[]> prunedEdges;
    private Map<Number, Number> currentExpandLevels;
    private int currentExpandLevel;
    private Number searchedNode;
    private List<Number> centerNodeParents;
    private List<Number> centerNodeChildren;
    private String layoutMethod = null;

    public GraphInteractivityImpl(InteractivityImpl interactivityImpl, Vis vis) {
        this.vis = vis;
        this.interactivity = interactivityImpl;
        this.initializeExpandLevelState();
    }

    @Override
    public void hideChildrenOf(int n, int[] nArray, String string, String string2) {
        int n2 = this.centerNowRow;
        this.initialize(n, string, string2);
        if (n2 != this.centerNowRow) {
            this.updateCenterNode(n2);
        }
        this.updatePrunedListsForNodes(nArray, -1, false, false);
        this.updatePrunedItems();
    }

    @Override
    public void hideParentsOf(int n, int[] nArray, String string, String string2) {
        int n2 = this.centerNowRow;
        this.initialize(n, string, string2);
        if (n2 != this.centerNowRow) {
            this.updateCenterNode(n2);
        }
        this.updatePrunedListsForNodes(nArray, -1, true, false);
        this.updatePrunedItems();
    }

    @Override
    public void showChildrenOf(int n, int[] nArray, String string, String string2) {
        for (int n2 : nArray) {
            if (n2 > this.nodeData.rows.length - 1) {
                throw new IllegalArgumentException("Passed node row is not available in data");
            }
            this.searchedNode = this.nodeData.rows[n2][this.idFieldIndex];
            Number number = this.currentExpandLevels.get(this.searchedNode);
            int n3 = number == null ? 1 : number.intValue();
            this.showChildrenForExpandLevel(n, new int[]{n2}, n3, string, string2);
        }
        this.searchedNode = null;
    }

    @Override
    public void showChildrenForExpandLevel(int n, int[] nArray, int n2, String string, String string2) {
        int n3 = this.centerNowRow;
        this.initialize(n, string, string2);
        if (n3 != this.centerNowRow) {
            this.updateCenterNode(n3);
        }
        this.updatePrunedListsForNodes(nArray, n2, false, true);
        this.updatePrunedItems();
    }

    @Override
    public void showParentsOf(int n, int[] nArray, String string, String string2) {
        for (int n2 : nArray) {
            if (n2 > this.nodeData.rows.length - 1) {
                throw new IllegalArgumentException("Passed node row is not available in data");
            }
            this.searchedNode = this.nodeData.rows[n2][this.idFieldIndex];
            Number number = this.currentExpandLevels.get(this.searchedNode);
            int n3 = number == null ? 1 : number.intValue();
            this.showParentsForExpandLevel(n, new int[]{n2}, n3, string, string2);
        }
        this.searchedNode = null;
    }

    @Override
    public void showParentsForExpandLevel(int n, int[] nArray, int n2, String string, String string2) {
        int n3 = this.centerNowRow;
        this.initialize(n, string, string2);
        if (n3 != this.centerNowRow) {
            this.updateCenterNode(n3);
        }
        this.updatePrunedListsForNodes(nArray, n2, true, true);
        this.updatePrunedItems();
    }

    @Override
    public void showAll(int n, String string, String string2) {
        this.showOnly(n, -1, string, string2);
    }

    @Override
    public void showOnly(int n, int n2, String string, String string2) {
        this.initialize(n, string, string2);
        this.clearPruneLists();
        this.updatePrunedListsForCenterNode(n, n2, true);
        this.updatePrunedItems();
    }

    @Override
    public void expandLineage(int n, boolean bl, int n2, int n3, String string, String string2) {
        Double d;
        int n4;
        Object object;
        ArrayList<Double> arrayList;
        boolean bl2 = false;
        Number[] numberArray = null;
        this.readSpecObjects();
        if (bl) {
            arrayList = new ArrayList<Double>(1);
            arrayList.add(this.nodeData.rows[n][this.idFieldIndex]);
            this.findRelatedNodesAndEdges(arrayList, true, n2, false, false);
            this.findRelatedNodesAndEdges(arrayList, false, n3, false, false);
        } else {
            arrayList = new ArrayList(2);
            Long l = this.getNodeRowNumber(this.linkData.rows[n][this.fromFieldIndex]);
            object = (long)this.getNodeRowNumber(this.linkData.rows[n][this.toFieldIndex]);
            numberArray = new Number[]{this.linkData.rows[n][this.fromFieldIndex], this.linkData.rows[n][this.toFieldIndex]};
            if (n2 > 0 || n2 == -1) {
                arrayList.add(((Number)l).doubleValue());
                this.findRelatedNodesAndEdges(arrayList, true, n2 == -1 ? -1 : n2 - 1, false, false);
                arrayList.remove(0);
            }
            if (n3 > 0 || n3 == -1) {
                arrayList.clear();
                arrayList.add(((Number)object).doubleValue());
                this.findRelatedNodesAndEdges(arrayList, false, n3 == -1 ? -1 : n3 - 1, false, false);
            }
            arrayList.clear();
            if (n2 != 0) {
                arrayList.add(((Number)l).doubleValue());
            }
            if (n3 != 0) {
                arrayList.add(((Number)object).doubleValue());
            }
        }
        if (string != null) {
            int n5 = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, string);
            if (n5 == -1) {
                throw new IllegalArgumentException("Data field '" + string + "' does not exist.");
            }
            object = this.nodeData.rows;
            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                d = (double)object[n4][this.idFieldIndex];
                boolean bl3 = this.allParents.contains(d) || this.allChildren.contains(d) || arrayList.contains(d);
                int n6 = (int)object[n4][n5];
                if (n6 == 0) continue;
                if (bl3) {
                    if (n6 != 2) continue;
                    bl2 = true;
                    object[n4][n5] = 1.0;
                    continue;
                }
                if (n6 != 1) continue;
                bl2 = true;
                object[n4][n5] = 2.0;
            }
        }
        if (string2 != null) {
            int n7 = GraphInteractivityImpl.getFieldIndex(this.linkData.fields, string2);
            if (n7 == -1) {
                throw new IllegalArgumentException("Link field '" + string2 + "' does not exist.");
            }
            object = this.linkData.rows;
            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                d = (double)object[n4][this.fromFieldIndex];
                Double d2 = (double)object[n4][this.toFieldIndex];
                Number[] numberArray2 = new Number[]{d, d2};
                boolean bl4 = numberArray != null && GraphInteractivityImpl.isEdgeEqual(numberArray, numberArray2) || GraphInteractivityImpl.isEdgeInList(this.allParentsEdges, numberArray2) || GraphInteractivityImpl.isEdgeInList(this.allChildrenEdges, numberArray2);
                int n8 = (int)object[n4][n7];
                if (n8 == 0) continue;
                if (bl4) {
                    if (n8 != 2) continue;
                    bl2 = true;
                    object[n4][n7] = 1.0;
                    continue;
                }
                if (n8 != 1) continue;
                bl2 = true;
                object[n4][n7] = 2.0;
            }
        }
        if (bl2) {
            this.interactivity.updateScene();
        }
    }

    @Override
    public void collapseLineageAll(String string, String string2) {
        int n;
        double[][] dArray;
        int n2;
        boolean bl = false;
        this.readSpecObjects();
        if (string != null) {
            n2 = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, string);
            if (n2 == -1) {
                throw new IllegalArgumentException("Node field '" + string + "' does not exist.");
            }
            dArray = this.nodeData.rows;
            for (n = 0; n < dArray.length; ++n) {
                if ((int)dArray[n][n2] != 1) continue;
                bl = true;
                dArray[n][n2] = 2.0;
            }
        }
        if (string2 != null) {
            n2 = GraphInteractivityImpl.getFieldIndex(this.linkData.fields, string2);
            if (n2 == -1) {
                throw new IllegalArgumentException("Link field '" + string2 + "' does not exist.");
            }
            dArray = this.linkData.rows;
            for (n = 0; n < dArray.length; ++n) {
                if ((int)dArray[n][n2] != 1) continue;
                bl = true;
                dArray[n][n2] = 2.0;
            }
        }
        if (bl) {
            this.interactivity.updateScene();
        }
    }

    @Override
    public int[] getNodeLineageFieldValues(String string) {
        this.readSpecObjects();
        int n = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, string);
        if (n == -1) {
            throw new IllegalArgumentException("Node field '" + string + "' does not exist.");
        }
        double[][] dArray = this.nodeData.rows;
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i][n];
        }
        return nArray;
    }

    @Override
    public int[] getEdgeLineageFieldValues(String string) {
        this.readSpecObjects();
        int n = GraphInteractivityImpl.getFieldIndex(this.linkData.fields, string);
        if (n == -1) {
            throw new IllegalArgumentException("Link field '" + string + "' does not exist.");
        }
        double[][] dArray = this.linkData.rows;
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i][n];
        }
        return nArray;
    }

    public void setGrammarIndex(int n) {
        this.grammarIndex = n;
    }

    private void readSpecObjects() {
        ElementsSpec elementsSpec = this.getNodeElement();
        ElementsSpec elementsSpec2 = this.getLinkElement();
        if (elementsSpec == null || elementsSpec2 == null) {
            throw new EngineException("Input specs do not represent a DAG graph.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        this.nodeSpecs = elementsSpec.positioning;
        this.linkSpecs = elementsSpec2.positioning;
        for (DataSpec dataSpec : this.vis.getCurrentSpec().data) {
            if (dataSpec.id.equals(elementsSpec.data.$ref)) {
                this.nodeData = dataSpec;
                continue;
            }
            if (!dataSpec.id.equals(elementsSpec2.data.$ref)) continue;
            this.linkData = dataSpec;
        }
        if (this.nodeSpecs == null || this.linkSpecs == null || this.nodeData == null || this.linkData == null) {
            throw new EngineException("Input specs do not represent a DAG graph.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        this.idFieldIndex = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, this.nodeSpecs.id.$ref);
        this.fromFieldIndex = GraphInteractivityImpl.getFieldIndex(this.linkData.fields, this.linkSpecs.from.$ref);
        this.toFieldIndex = GraphInteractivityImpl.getFieldIndex(this.linkData.fields, this.linkSpecs.to.$ref);
        this.initializeGlobalLists();
        this.clearPruneLists();
    }

    private void initialize(int n, String string, String string2) {
        int n2;
        this.readSpecObjects();
        if (n > this.nodeData.rows.length - 1) {
            throw new IllegalArgumentException("Passed center node row is not available in data");
        }
        this.centerNowRow = n;
        this.inIconFieldIndex = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, string);
        if (this.inIconFieldIndex == -1) {
            throw new IllegalArgumentException("In icon field do not exists in data");
        }
        this.outIconFieldIndex = GraphInteractivityImpl.getFieldIndex(this.nodeData.fields, string2);
        if (this.outIconFieldIndex == -1) {
            throw new IllegalArgumentException("Out icon field do not exists in data");
        }
        if (this.nodeSpecs.prunedNodes != null) {
            for (n2 = 0; n2 < this.nodeSpecs.prunedNodes.length; ++n2) {
                this.prunedNodes.add(this.nodeSpecs.prunedNodes[n2]);
            }
        }
        if (this.nodeSpecs.prunedEdges != null) {
            for (n2 = 0; n2 < this.nodeSpecs.prunedEdges.length; ++n2) {
                this.prunedEdges.add(this.nodeSpecs.prunedEdges[n2]);
            }
        }
        this.nodeSpecs.prunedNodes = null;
        this.nodeSpecs.prunedEdges = null;
        this.linkSpecs.prunedEdges = null;
    }

    private void updateCenterNode(int n) {
        this.updatePrunedListsForCenterNode(this.centerNowRow, -1, n < 0);
        if (n > 0 && n <= this.nodeData.rows.length - 1) {
            Double d = this.nodeData.rows[n][this.idFieldIndex];
            if (this.centerNodeParents.contains(d)) {
                this.setIconState(d, true, 0);
            }
            if (this.centerNodeChildren.contains(d)) {
                this.setIconState(d, false, 0);
            }
        }
    }

    private void updatePrunedListsForNodes(int[] nArray, int n, boolean bl, boolean bl2) {
        int n2 = bl ? this.inIconFieldIndex : this.outIconFieldIndex;
        List<Object> list = new ArrayList();
        List<Object> list2 = new ArrayList();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > this.nodeData.rows.length - 1) {
                throw new IllegalArgumentException("Passed node row is not available in data");
            }
            Double object2 = this.nodeData.rows[nArray[i]][this.idFieldIndex];
            arrayList.add(object2);
            this.nodeData.rows[nArray[i]][n2] = bl2 ? (double)this.getIconState(object2, bl, 1) : (double)this.getIconState(object2, bl, 0);
        }
        if (bl2) {
            this.findRelatedNodesAndEdges(arrayList, bl, n, !bl2, bl2);
            list = bl ? this.allParents : this.allChildren;
            list2 = bl ? this.allParentsEdges : this.allChildrenEdges;
        } else {
            for (Double d : arrayList) {
                this.currentExpandLevel = 0;
                this.searchedNode = d;
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(d);
                this.findRelatedNodesAndEdges(arrayList2, bl, n, !bl2, bl2);
                if (bl) {
                    list.addAll(this.allParents);
                    list2.addAll(this.allParentsEdges);
                } else {
                    list.addAll(this.allChildren);
                    list2.addAll(this.allChildrenEdges);
                }
                this.initializeGlobalLists();
            }
            this.searchedNode = null;
        }
        for (Number number : list) {
            if (this.prunedNodes.contains(number)) {
                if (!bl2) continue;
                this.prunedNodes.remove(number);
                continue;
            }
            if (bl2) continue;
            this.prunedNodes.add(number);
        }
        for (int i = 0; i < list2.size(); ++i) {
            Number[] numberArray = (Number[])list2.get(i);
            if (GraphInteractivityImpl.isEdgeInList(this.prunedEdges, numberArray)) {
                if (!bl2) continue;
                GraphInteractivityImpl.removeEdgeFromList(this.prunedEdges, numberArray);
                continue;
            }
            if (bl2) continue;
            this.prunedEdges.add(numberArray);
        }
        if (bl2) {
            for (Number number : list) {
                this.currentExpandLevels.remove(number);
            }
        }
        this.initializeGlobalLists();
    }

    private void updatePrunedListsForCenterNode(int n, int n2, boolean bl) {
        Double d;
        int n3;
        if (n < 0) {
            return;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(this.nodeData.rows[n][this.idFieldIndex]);
        this.findRelatedNodesAndEdges(arrayList, true, n2, false, bl);
        this.findRelatedNodesAndEdges(arrayList, false, n2, false, bl);
        this.centerNodeParents = this.allParents;
        this.centerNodeChildren = this.allChildren;
        this.nodeData.rows[n][this.inIconFieldIndex] = this.allParents.size() > 0 ? (this.isAnyNodeVisible(this.allParents) ? 2.0 : 1.0) : (double)this.getIconState(this.nodeData.rows[n][this.idFieldIndex], true, 0);
        this.nodeData.rows[n][this.outIconFieldIndex] = this.allChildren.size() > 0 ? (this.isAnyNodeVisible(this.allChildren) ? 2.0 : 1.0) : (double)this.getIconState(this.nodeData.rows[n][this.idFieldIndex], false, 0);
        for (n3 = 0; n3 < this.nodeData.rows.length; ++n3) {
            d = this.nodeData.rows[n3][this.idFieldIndex];
            if (arrayList.contains(d) || this.allParents.contains(d) || this.allChildren.contains(d) || this.prunedNodes.contains(d)) continue;
            this.prunedNodes.add(d);
        }
        for (n3 = 0; n3 < this.linkData.rows.length; ++n3) {
            Double d2;
            d = this.linkData.rows[n3][this.fromFieldIndex];
            Number[] numberArray = new Number[]{d, d2 = Double.valueOf(this.linkData.rows[n3][this.toFieldIndex])};
            if (GraphInteractivityImpl.isEdgeInList(this.allParentsEdges, numberArray) || GraphInteractivityImpl.isEdgeInList(this.allChildrenEdges, numberArray) || GraphInteractivityImpl.isEdgeInList(this.prunedEdges, numberArray)) continue;
            this.prunedEdges.add(numberArray);
        }
        this.initializeGlobalLists();
    }

    private void updatePrunedItems() {
        int n;
        if (this.prunedNodes.size() > 0) {
            this.nodeSpecs.prunedNodes = new Number[this.prunedNodes.size()];
            for (n = 0; n < this.prunedNodes.size(); ++n) {
                this.nodeSpecs.prunedNodes[n] = this.prunedNodes.get(n);
            }
        }
        for (n = 0; n < this.linkData.rows.length; ++n) {
            Double d = this.linkData.rows[n][this.fromFieldIndex];
            Double d2 = this.linkData.rows[n][this.toFieldIndex];
            Number[] numberArray = new Number[]{d, d2};
            boolean bl = GraphInteractivityImpl.isEdgeInList(this.prunedEdges, numberArray);
            if (bl) continue;
            if (this.prunedNodes.contains(d)) {
                this.prunedEdges.add(numberArray);
                this.updateNodeIconState(this.getNodeRowNumber(d2), 1);
                continue;
            }
            if (!this.prunedNodes.contains(d2)) continue;
            this.prunedEdges.add(numberArray);
            this.updateNodeIconState(this.getNodeRowNumber(d), 1);
        }
        if (this.prunedEdges.size() > 0) {
            this.nodeSpecs.prunedEdges = new Number[this.prunedEdges.size()][];
            for (n = 0; n < this.prunedEdges.size(); ++n) {
                this.nodeSpecs.prunedEdges[n] = this.prunedEdges.get(n);
            }
            this.linkSpecs.prunedEdges = this.nodeSpecs.prunedEdges;
        }
        this.interactivity.updateScene();
    }

    private void findRelatedNodesAndEdges(List<Double> list, boolean bl, int n, boolean bl2, boolean bl3) {
        boolean bl4;
        if (n == 0) {
            return;
        }
        if (n > 0) {
            --n;
        }
        ArrayList<Number> arrayList = new ArrayList<Number>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Number[]> arrayList3 = new ArrayList<Number[]>();
        int n2 = bl ? this.toFieldIndex : this.fromFieldIndex;
        int n3 = bl ? this.fromFieldIndex : this.toFieldIndex;
        boolean bl5 = false;
        boolean bl6 = bl4 = bl3;
        boolean bl7 = this.searchedNode != null ? !this.currentExpandLevels.containsKey(this.searchedNode) : true;
        for (Number number : list) {
            for (int i = 0; i < this.linkData.rows.length; ++i) {
                if (number.doubleValue() != this.linkData.rows[i][n2]) continue;
                Double d = this.linkData.rows[i][n3];
                if (bl3) {
                    boolean bl8 = bl ? !this.allParents.contains(d) : (bl4 = !this.allChildren.contains(d));
                }
                if (!bl2 || this.processRelatedNode(d, !bl)) {
                    arrayList.add(d);
                    if (bl7 || this.isNodeExpanded(d, bl)) {
                        arrayList2.add((double)d);
                        if (bl4) {
                            this.setIconState(d, bl, n);
                        }
                    }
                }
                Number[] numberArray = new Number[]{this.linkData.rows[i][this.fromFieldIndex], this.linkData.rows[i][this.toFieldIndex]};
                arrayList3.add(numberArray);
            }
        }
        if (arrayList3.size() > 0) {
            if (bl) {
                this.allParentsEdges.addAll(arrayList3);
            } else {
                this.allChildrenEdges.addAll(arrayList3);
            }
        }
        boolean bl9 = bl5 = bl ? GraphInteractivityImpl.isNodesInList(this.allParents, arrayList) : GraphInteractivityImpl.isNodesInList(this.allChildren, arrayList);
        if (arrayList.size() > 0 && !bl5) {
            if (bl2) {
                ++this.currentExpandLevel;
            }
            if (bl) {
                this.allParents.addAll(arrayList);
            } else {
                this.allChildren.addAll(arrayList);
            }
            if (n != 0) {
                this.findRelatedNodesAndEdges(arrayList2, bl, n, bl2, bl3);
            }
            if (bl2 && this.searchedNode.intValue() >= 0) {
                this.currentExpandLevels.put(this.searchedNode, this.currentExpandLevel);
            }
        }
    }

    private boolean isNodeExpanded(Number number, boolean bl) {
        int n = bl ? this.inIconFieldIndex : this.outIconFieldIndex;
        int n2 = this.getNodeRowNumber(number);
        return n2 >= 0 && n2 <= this.nodeData.rows.length - 1 && this.nodeData.rows[n2][n] == 2.0;
    }

    private boolean isAnyNodeVisible(List<Number> list) {
        for (Number number : list) {
            if (this.prunedNodes.contains(number)) continue;
            return true;
        }
        return false;
    }

    private boolean processRelatedNode(Number number, boolean bl) {
        int n = bl ? this.toFieldIndex : this.fromFieldIndex;
        int n2 = bl ? this.fromFieldIndex : this.toFieldIndex;
        int n3 = bl ? this.outIconFieldIndex : this.inIconFieldIndex;
        List<Number> list = bl ? this.allChildren : this.allParents;
        for (int i = 0; i < this.linkData.rows.length; ++i) {
            int n4;
            if (number.doubleValue() != this.linkData.rows[i][n]) continue;
            Double d = this.linkData.rows[i][n2];
            Number[] numberArray = new Number[2];
            numberArray[0] = bl ? (Number)d : (Number)number;
            Number number2 = numberArray[1] = bl ? (Number)number : (Number)d;
            if (list.contains(d) || this.prunedNodes.contains(d) || GraphInteractivityImpl.isEdgeInList(this.prunedEdges, numberArray) || (n4 = this.getNodeRowNumber(d)) < 0 || n4 > this.nodeData.rows.length - 1 || (int)this.nodeData.rows[n4][n3] == 1) continue;
            return false;
        }
        return !(bl ? this.centerNodeParents != null && this.centerNodeParents.contains(number) : this.centerNodeChildren != null && this.centerNodeChildren.contains(number));
    }

    private ElementsSpec getNodeElement() {
        ElementsSpec[] elementsSpecArray;
        ElementsSpec elementsSpec = null;
        GrammarSpec[] grammarSpecArray = this.vis.getCurrentSpec().grammar;
        for (ElementsSpec elementsSpec2 : elementsSpecArray = grammarSpecArray[this.grammarIndex].elements) {
            LayoutSpec layoutSpec = elementsSpec2.positioning;
            if (layoutSpec == null) continue;
            this.layoutMethod = layoutSpec.method;
            if (!LAYOUT_METHOD_DAG.equals(this.layoutMethod) && !LAYOUT_METHOD_TREE.equals(this.layoutMethod)) continue;
            elementsSpec = elementsSpec2;
            break;
        }
        return elementsSpec;
    }

    private ElementsSpec getLinkElement() {
        ElementsSpec[] elementsSpecArray;
        ElementsSpec elementsSpec = null;
        GrammarSpec[] grammarSpecArray = this.vis.getCurrentSpec().grammar;
        for (ElementsSpec elementsSpec2 : elementsSpecArray = grammarSpecArray[this.grammarIndex].elements) {
            LayoutSpec layoutSpec = elementsSpec2.positioning;
            if (layoutSpec == null || !LAYOUT_METHOD_LINK.equals(layoutSpec.method)) continue;
            elementsSpec = elementsSpec2;
            break;
        }
        return elementsSpec;
    }

    private static int getFieldIndex(FieldSpec[] fieldSpecArray, String string) {
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            if (string == null || !string.equals(fieldSpecArray[i].id)) continue;
            return i;
        }
        return -1;
    }

    private void updateNodeIconState(int n, int n2) {
        if (n >= 0 && n <= this.nodeData.rows.length - 1) {
            if ((int)this.nodeData.rows[n][this.inIconFieldIndex] != 0) {
                this.nodeData.rows[n][this.inIconFieldIndex] = n2;
            }
            if ((int)this.nodeData.rows[n][this.outIconFieldIndex] != 0) {
                this.nodeData.rows[n][this.outIconFieldIndex] = n2;
            }
        }
    }

    private void setIconState(Number number, boolean bl, int n) {
        int n2 = this.getNodeRowNumber(number);
        if (n2 >= 0 && n2 <= this.nodeData.rows.length - 1 && n2 != this.centerNowRow) {
            this.nodeData.rows[n2][this.inIconFieldIndex] = bl ? (double)this.getIconState(number, bl, n) : 0.0;
            this.nodeData.rows[n2][this.outIconFieldIndex] = bl ? 0.0 : (double)this.getIconState(number, bl, n);
        }
    }

    private int getIconState(Number number, boolean bl, int n) {
        int n2 = bl ? this.toFieldIndex : this.fromFieldIndex;
        int n3 = bl ? this.fromFieldIndex : this.toFieldIndex;
        int n4 = 0;
        if (this.searchedNode == null || n != 0) {
            for (int i = 0; i < this.linkData.rows.length; ++i) {
                if (number.doubleValue() != this.linkData.rows[i][n2]) continue;
                n4 = n != 0 ? 2 : 1;
                break;
            }
        } else {
            List<Number[]> list;
            List<Number> list2;
            if (bl) {
                list2 = GraphInteractivityImpl.removeNodesFromList(this.prunedNodes, this.allParents);
                list = GraphInteractivityImpl.removeEdgesFromList(this.prunedEdges, this.allParentsEdges);
            } else {
                list2 = GraphInteractivityImpl.removeNodesFromList(this.prunedNodes, this.allChildren);
                list = GraphInteractivityImpl.removeEdgesFromList(this.prunedEdges, this.allChildrenEdges);
            }
            for (int i = 0; i < this.linkData.rows.length; ++i) {
                if (number.doubleValue() != this.linkData.rows[i][n2]) continue;
                n4 = 1;
                Double d = this.linkData.rows[i][n3];
                Number[] numberArray = new Number[2];
                numberArray[0] = bl ? (Number)d : (Number)number;
                Number number2 = numberArray[1] = bl ? (Number)number : (Number)d;
                if (list2.contains(d) || GraphInteractivityImpl.isEdgeInList(list, numberArray)) continue;
                n4 = 2;
                break;
            }
        }
        return n4;
    }

    private int getNodeRowNumber(Number number) {
        for (int i = 0; i < this.nodeData.rows.length; ++i) {
            if (number.doubleValue() != this.nodeData.rows[i][this.idFieldIndex]) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEdgeInList(List<Number[]> list, Number[] numberArray) {
        for (int i = 0; i < list.size(); ++i) {
            if (!GraphInteractivityImpl.isEdgeEqual(numberArray, list.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEdgeEqual(Number[] numberArray, Number[] numberArray2) {
        return numberArray[0].doubleValue() == numberArray2[0].doubleValue() && numberArray[1].doubleValue() == numberArray2[1].doubleValue();
    }

    private static void removeEdgeFromList(List<Number[]> list, Number[] numberArray) {
        for (int i = 0; i < list.size(); ++i) {
            Number[] numberArray2 = list.get(i);
            if (numberArray2[0].doubleValue() != numberArray[0].doubleValue() || numberArray2[1].doubleValue() != numberArray[1].doubleValue()) continue;
            list.remove(numberArray2);
            return;
        }
    }

    private static boolean isNodesInList(List<Number> list, List<Number> list2) {
        for (Number number : list2) {
            if (list.contains(number)) continue;
            return false;
        }
        return true;
    }

    private static List<Number> removeNodesFromList(List<Number> list, List<Number> list2) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Number number : list) {
            if (list2.contains(number)) continue;
            arrayList.add(number);
        }
        return arrayList;
    }

    private static List<Number[]> removeEdgesFromList(List<Number[]> list, List<Number[]> list2) {
        ArrayList<Number[]> arrayList = new ArrayList<Number[]>();
        for (Number[] numberArray : list) {
            if (GraphInteractivityImpl.isEdgeInList(list2, numberArray)) continue;
            arrayList.add(numberArray);
        }
        return arrayList;
    }

    private void initializeGlobalLists() {
        this.allParents = new ArrayList<Number>();
        this.allChildren = new ArrayList<Number>();
        this.allParentsEdges = new ArrayList<Number[]>();
        this.allChildrenEdges = new ArrayList<Number[]>();
        this.currentExpandLevel = 0;
    }

    private void clearPruneLists() {
        this.prunedNodes = new ArrayList<Number>();
        this.prunedEdges = new ArrayList<Number[]>();
    }

    private void initializeExpandLevelState() {
        this.currentExpandLevels = new HashMap<Number, Number>();
    }
}

