/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.util.SceneTreeUtil;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.HighlightRepresentation;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class HighlightMaker {
    private final HighlightRepresentation hiRep;
    private final StyleSpec hiStyle;
    private final SceneTree sceneTree;
    private final double expandWidth;
    private static final double BOUNDING_RECT_OPACITY = 0.4;
    private static final double DEFAULT_STROKE_WIDTH = 2.0;

    public HighlightMaker(HighlightRepresentation highlightRepresentation, SceneTree sceneTree) {
        this.hiRep = highlightRepresentation;
        this.hiStyle = (StyleSpec)SpecUtil.createSpecObject(this.hiRep.getStyle(), "StyleSpec");
        this.sceneTree = sceneTree;
        Double d = HighlightMaker.getStroke(this.hiStyle);
        this.expandWidth = d != null ? (d + 1.0) / 2.0 : 0.0;
    }

    private static final Double getStroke(StyleSpec styleSpec) {
        Double d = null;
        if (styleSpec.stroke != null) {
            d = UnitConverter.convertLength(styleSpec.stroke.width, 2.0, 2.0);
        }
        return d;
    }

    public static Stroke makeHighlightStroke(Stroke stroke, StyleSpec styleSpec, boolean bl) {
        Object object;
        String string;
        String string2;
        Object object2;
        Object object3;
        double d;
        if (styleSpec == null || styleSpec.stroke == null && styleSpec.outline == null) {
            return stroke;
        }
        if (stroke != null) {
            d = stroke.getWidth();
            object3 = stroke.getColor();
            object2 = stroke.getJoin();
            string2 = stroke.getCap();
            string = stroke.getDashing();
        } else {
            d = 2.0;
            object3 = ColorUtil.getDefaultStrokeColor();
            object2 = null;
            string2 = null;
            string = null;
        }
        if (styleSpec.stroke != null) {
            object = HighlightMaker.getStroke(styleSpec);
            if (object != null) {
                d = (Double)object;
            }
            if (styleSpec.stroke.join != null) {
                object2 = styleSpec.stroke.join;
            }
            if (styleSpec.stroke.cap != null) {
                string2 = styleSpec.stroke.cap;
            }
            if (styleSpec.stroke.style != null) {
                string = styleSpec.stroke.style;
            }
        }
        if (styleSpec.outline != null && (object = ColorUtil.toCanonicalColor(styleSpec.outline)) != null) {
            if (!bl && object3 != null) {
                object = ColorUtil.makeCombinedColor((ColorNew)object, (ColorNew)object3);
            }
            object3 = object;
        }
        return new Stroke(d, string, object2, string2, (ColorNew)object3);
    }

    public SceneNode makeHighlight(SceneNode sceneNode) {
        if (sceneNode == null) {
            return null;
        }
        Object object = (SceneNodeImpl)sceneNode;
        SceneNodeImpl sceneNodeImpl = null;
        SceneNodeType sceneNodeType = HighlightMaker.getType((SceneNode)object);
        if (sceneNodeType != null) {
            Object object2;
            boolean bl;
            String string = ((SceneNodeImpl)object).getId();
            boolean bl2 = bl = SceneNodeType.TITLE == sceneNodeType;
            if (bl || string.indexOf("D") == 0) {
                if (!bl) {
                    Object object3;
                    SceneNodeType sceneNodeType2;
                    object2 = ((SceneNodeImpl)object).getParent();
                    if (object2 != null && SceneNodeType.TITLE == (sceneNodeType2 = HighlightMaker.getType((SceneNode)(object3 = object2)))) {
                        List<SceneNode> list = object3.getChildren();
                        object = (SceneNodeImpl)list.get(0);
                        sceneNodeType = HighlightMaker.getType((SceneNode)object);
                    }
                } else {
                    object2 = ((SceneNodeImpl)object).getChildren();
                    object = (SceneNodeImpl)object2.get(0);
                    sceneNodeType = HighlightMaker.getType((SceneNode)object);
                }
            }
            if (string.indexOf("LE") > -1) {
                while (SceneNodeType.LEGEND_ENTRY != sceneNodeType) {
                    object2 = ((SceneNodeImpl)object).getParent();
                    if (object2 == null) continue;
                    object = object2;
                    sceneNodeType = HighlightMaker.getType((SceneNode)object);
                }
                sceneNodeImpl = this.makeHighlightForLegendEntry((SceneNodeImpl)object);
                HighlightMaker.addTransformAndClip((SceneNodeImpl)object, sceneNodeImpl);
            } else if (SceneNodeTypeUtil.isText(sceneNodeType)) {
                sceneNodeImpl = this.makeHighlightForText((SceneNode)object);
                HighlightMaker.addTransformAndClip((SceneNodeImpl)object, sceneNodeImpl);
            } else {
                sceneNodeImpl = this.makeNonTextHighlight((SceneNodeImpl)object);
            }
        } else {
            sceneNodeImpl = this.makeNonTextHighlight((SceneNodeImpl)object);
        }
        return sceneNodeImpl;
    }

    private SceneNodeImpl makeNonTextHighlight(SceneNodeImpl sceneNodeImpl) {
        SceneNodeImpl sceneNodeImpl2 = null;
        if (sceneNodeImpl.getShape() != null && sceneNodeImpl.getChildren().size() == 0) {
            sceneNodeImpl2 = this.makeHighlightForShape(sceneNodeImpl);
            HighlightMaker.addTransformAndClip(sceneNodeImpl, sceneNodeImpl2);
        } else {
            sceneNodeImpl2 = this.makeCompositeHighlight(sceneNodeImpl);
        }
        return sceneNodeImpl2;
    }

    private static void addTransformAndClip(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        HighlightMaker.addTransformsToHighlight(sceneNodeImpl2, sceneNodeImpl);
        HighlightMaker.addClipToHighlight(sceneNodeImpl2, sceneNodeImpl);
    }

    private static void addTransformsToHighlight(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        if (sceneNodeImpl == null || sceneNodeImpl2 == null || sceneNodeImpl2.getTransform() == null) {
            return;
        }
        TransformInfoImpl transformInfoImpl = new TransformInfoImpl();
        transformInfoImpl.setAffine(sceneNodeImpl2.getTransform().getAffine());
        sceneNodeImpl.setTransform(transformInfoImpl);
    }

    private static void addClipToHighlight(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        if (sceneNodeImpl == null || sceneNodeImpl2 == null) {
            return;
        }
        String string = sceneNodeImpl2.getId();
        int n = string.indexOf(69);
        if (n < 0 || string.indexOf(71) != 0) {
            return;
        }
        if (string.indexOf("LE") > -1) {
            return;
        }
        HighlightMaker.addClipFromItemOrAncestor(sceneNodeImpl, sceneNodeImpl2, null);
    }

    private static void addClipFromItemOrAncestor(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2, TransformInfo transformInfo) {
        if (sceneNodeImpl2 == null) {
            return;
        }
        Rect rect = sceneNodeImpl2.getClipBounds();
        if (rect == null) {
            HighlightMaker.addClipFromItemOrAncestor(sceneNodeImpl, sceneNodeImpl2.getParent(), sceneNodeImpl2.getTransform());
        } else {
            if (transformInfo != null && transformInfo.getAffine() != null) {
                rect = transformInfo.getAffine().transformBoundingBox(rect);
            }
            sceneNodeImpl.setClipBounds(rect);
        }
    }

    private static SceneNodeType getType(SceneNode sceneNode) {
        if (sceneNode.getType() != null) {
            return sceneNode.getType();
        }
        int n = ((Shape)sceneNode.getShape()).getType();
        if (n == 1009 || n == 1007 || n == 1008) {
            return SceneNodeType.TEXT;
        }
        return null;
    }

    private SceneNodeImpl makeHighlightForShape(SceneNodeImpl sceneNodeImpl) {
        SceneNodeImpl sceneNodeImpl2 = null;
        Shape shape = HighlightMaker.getDummyShape(sceneNodeImpl);
        this.prepareDummyShape(sceneNodeImpl, shape, true);
        sceneNodeImpl2 = SceneNodeFactory.cloneNode(sceneNodeImpl);
        sceneNodeImpl2.setId(null);
        ((Shape)sceneNodeImpl2.getShape()).setTransform(null);
        HighlightMaker.applyHighlightToSceneNode(shape, sceneNodeImpl2);
        return sceneNodeImpl2;
    }

    private static Shape getDummyShape(SceneNode sceneNode) {
        Rect rect = sceneNode.getShape().getNodeBounds();
        Shape shape = rect == null || !((Shape)sceneNode.getShape()).isFilled() ? ShapeFactory2.CreateRect(5.0, 5.0, 10.0, 10.0) : ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        return shape;
    }

    private static void applyHighlightToSceneNode(Shape shape, SceneNode sceneNode) {
        Geom geom = null;
        if (shape.getType() == 1002) {
            geom = shape.getGlobalGradientGeometry();
        }
        Fill fill = shape.getFill();
        Stroke stroke = shape.getStroke();
        RenderEffects renderEffects = shape.getEffect();
        ColorNew colorNew = shape.getOutline();
        Shape shape2 = (Shape)sceneNode.getShape();
        if (fill != null) {
            if (shape2.isFilled()) {
                shape2.setFill(fill);
            } else if (colorNew != null) {
                shape2.setFill(Fill.createFill(colorNew, fill.getGradient()));
            }
        }
        if (geom != null) {
            shape2.setGlobalGradient(geom);
        }
        if (stroke != null) {
            shape2.setStroke(stroke);
        }
        if (renderEffects != null) {
            shape2.setEffect(renderEffects);
        }
        if (colorNew != null) {
            shape2.setOutline(colorNew);
        }
    }

    private void prepareDummyShape(SceneNode sceneNode, Shape shape, boolean bl) {
        Object object;
        Shape shape2 = (Shape)sceneNode.getShape();
        Stroke stroke = null;
        if (shape2 != null) {
            ColorNew colorNew;
            object = shape2.getFill();
            SceneNodeType sceneNodeType = HighlightMaker.getType(sceneNode);
            if (SceneNodeType.TEXT == sceneNodeType || SceneNodeType.MULTI_TEXT == sceneNodeType) {
                object = null;
            }
            ColorNew colorNew2 = colorNew = (stroke = shape2.getStroke()) == null ? null : stroke.getColor();
            if (object != null) {
                shape.setFill((Fill)object);
            }
            if (colorNew != null) {
                shape.setOutline(colorNew);
            }
            if (stroke != null) {
                shape.setStroke(stroke);
            }
        }
        object = this.modifyForStrokeDashing(this.hiStyle, stroke, bl);
        StyleBuilder.modifyShapeStyle(shape, (StyleSpec)object);
    }

    private StyleSpec modifyForStrokeDashing(StyleSpec styleSpec, Stroke stroke, boolean bl) {
        if (!bl || stroke == null || stroke.getDashing() == null) {
            return styleSpec;
        }
        StyleSpec styleSpec2 = (StyleSpec)styleSpec.copy();
        StrokeSpec strokeSpec = new StrokeSpec();
        strokeSpec.style = stroke.getDashing();
        strokeSpec.width = stroke.getWidth();
        styleSpec2.stroke = strokeSpec;
        return styleSpec2;
    }

    private SceneNodeImpl makeHighlightForLegendEntry(SceneNodeImpl sceneNodeImpl) {
        Object object;
        String string = sceneNodeImpl.getId();
        Rect rect = this.getBoundsForLegendEntry(sceneNodeImpl);
        if (rect == null) {
            return null;
        }
        int n = string.indexOf("SW");
        int n2 = string.indexOf("T");
        String string2 = "";
        if (n > -1) {
            object = string.substring(n + 2);
            string2 = string.substring(0, n) + "T" + (String)object;
        } else if (n2 > -1) {
            object = string.substring(n2 + 1);
            string2 = string.substring(0, n2) + "SW" + (String)object;
        }
        if (string2.length() > 0 && (object = this.sceneTree.findNode(string2)) != null) {
            rect.extendToRect(this.getBoundsForLegendEntry((SceneNode)object));
        }
        object = ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        this.expandBoundsForOutlineStroke((Shape)object);
        this.prepareDummyShape(sceneNodeImpl, (Shape)object, false);
        SceneNodeImpl sceneNodeImpl2 = SceneNodeFactory.createShapeNode((Shape)object);
        HighlightMaker.applyHighlightToSceneNode((Shape)object, sceneNodeImpl2);
        Fill fill = ((Shape)sceneNodeImpl2.getShape()).getFill();
        if (fill != null) {
            double[] dArray = fill.getSolid().getRGBA();
            fill = Fill.makeSolid(new ColorNew(dArray[0], dArray[1], dArray[2], 0.4));
        }
        return sceneNodeImpl2;
    }

    private SceneNodeImpl makeCompositeHighlight(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (null == list || 0 == list.size()) {
            return null;
        }
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.HIGHLIGHT);
        int n = 0;
        for (SceneNode sceneNode2 : list) {
            groupSceneNode.addChildAt(n, this.makeHighlight(sceneNode2));
        }
        return groupSceneNode;
    }

    private SceneNodeImpl makeHighlightForText(SceneNode sceneNode) {
        Shape shape = HighlightMaker.getDummyShape(sceneNode);
        if (shape == null) {
            return null;
        }
        this.expandBoundsForOutlineStroke(shape);
        this.prepareDummyShape(sceneNode, shape, false);
        SceneNodeImpl sceneNodeImpl = SceneNodeFactory.createShapeNode(shape);
        sceneNodeImpl.getShape().setKey(sceneNode.getShape().getKey());
        HighlightMaker.applyHighlightToSceneNode(shape, sceneNodeImpl);
        Fill fill = ((Shape)sceneNodeImpl.getShape()).getFill();
        if (fill != null && fill.getSolid() != null) {
            double[] dArray = fill.getSolid().getRGBA();
            fill = Fill.makeSolid(new ColorNew(dArray[0], dArray[1], dArray[2], 0.4));
        }
        return sceneNodeImpl;
    }

    private void expandBoundsForOutlineStroke(Shape shape) {
        if (shape.getType() == 1002) {
            if (this.expandWidth > 0.0) {
                int n = 0;
                while (n < ((Path)shape).getXArray().length) {
                    double[] dArray = ((Path)shape).getXArray();
                    int n2 = n;
                    dArray[n2] = dArray[n2] - this.expandWidth;
                    double[] dArray2 = ((Path)shape).getYArray();
                    int n3 = n++;
                    dArray2[n3] = dArray2[n3] - this.expandWidth;
                }
            }
        } else if (this.expandWidth > 0.0) {
            shape.setX(shape.getX() - this.expandWidth);
            shape.setWidth(shape.getWidth() + this.expandWidth * 2.0);
            shape.setY(shape.getY() - this.expandWidth);
            shape.setHeight(shape.getHeight() + this.expandWidth * 2.0);
        }
    }

    public Rect getBoundsForLegendEntry(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null) {
            return this.getBoundsForLegendEntryChild(sceneNode);
        }
        int n = list.size();
        return this.getBoundsForLegendChildren(list, n);
    }

    private Rect getBoundsForLegendChildren(List<SceneNode> list, int n) {
        SceneNode sceneNode = list.get(0);
        Rect rect = this.getBoundsForLegendEntryChild(sceneNode);
        for (int i = 1; i < n; ++i) {
            SceneNode sceneNode2 = list.get(i);
            Rect rect2 = this.getBoundsForLegendEntryChild(sceneNode2);
            double d = Math.min(rect.getX(), rect2.getX());
            double d2 = Math.min(rect.getY(), rect2.getY());
            double d3 = Math.max(rect.getX() + rect.getWidth(), rect2.getX() + rect2.getWidth());
            double d4 = Math.max(rect.getY() + rect.getHeight(), rect2.getY() + rect2.getHeight());
            rect.setX(d);
            rect.setY(d2);
            rect.setWidth(d3 - d);
            rect.setHeight(d4 - d2);
        }
        return rect;
    }

    private Rect getBoundsForLegendEntryChild(SceneNode sceneNode) {
        Rect rect = SceneTreeUtil.getBounds(sceneNode);
        if (rect != null) {
            TransformInfo transformInfo = sceneNode.getTransform();
            if (transformInfo != null) {
                return Shape.transformBounds(rect, transformInfo.getAffine());
            }
            return rect;
        }
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null) {
            return null;
        }
        int n = list.size();
        return this.getBoundsForLegendChildren(list, n);
    }
}

