/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.interaction.effect.StyleEffect;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class HighlightStateImpl
extends HighlightState {
    private final HashMap<Integer, StyleEffect> highlightEffect;
    private final Interactivity interactivity;

    public HighlightStateImpl(HashMap<Integer, StyleEffect> hashMap, Interactivity interactivity) {
        this.highlightEffect = hashMap;
        this.interactivity = interactivity;
        for (StyleEffect styleEffect : this.highlightEffect.values()) {
            styleEffect.newTargetIds = new LinkedHashSet();
        }
    }

    @Override
    public void setSingle(SceneItem sceneItem, int n) {
        if (sceneItem == null) {
            return;
        }
        StyleEffect styleEffect = this.highlightEffect.get(n);
        if (styleEffect == null) {
            return;
        }
        SceneItemImpl sceneItemImpl = (SceneItemImpl)sceneItem;
        String string = sceneItemImpl.getID();
        styleEffect.addTargetId(string);
    }

    @Override
    public void setMultipleByID(String[] stringArray, int n) {
        StyleEffect styleEffect = this.highlightEffect.get(n);
        if (styleEffect == null) {
            return;
        }
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            styleEffect.addTargetId(string);
        }
    }

    @Override
    public void setMultiple(SceneItem[] sceneItemArray, int n) {
        if (sceneItemArray == null || this.highlightEffect.get(n) == null) {
            return;
        }
        for (SceneItem sceneItem : sceneItemArray) {
            this.setSingle(sceneItem, n);
        }
    }

    @Override
    public void apply() {
        for (StyleEffect styleEffect : this.highlightEffect.values()) {
            if (!styleEffect.hasChanged()) continue;
            styleEffect.clear();
            styleEffect.apply();
        }
        if (this.interactivity != null) {
            ((InteractivityImpl)this.interactivity).rendererShowHighlights(null);
        }
    }

    @Override
    public void applyForKey(int n) {
        StyleEffect styleEffect = this.highlightEffect.get(n);
        if (styleEffect == null) {
            return;
        }
        styleEffect.clear();
        styleEffect.apply();
        if (this.interactivity != null) {
            ((InteractivityImpl)this.interactivity).rendererShowHighlights(null);
        }
    }

    @Override
    public void clearAddedSceneItems() {
        for (StyleEffect styleEffect : this.highlightEffect.values()) {
            if (!styleEffect.hasChanged()) continue;
            styleEffect.clear();
        }
    }

    @Override
    public void clearAddedSceneItemsForKey(int n) {
        StyleEffect styleEffect = this.highlightEffect.get(n);
        if (styleEffect != null) {
            styleEffect.clear();
        }
    }

    public SceneItem[] getAddedSceneItems() {
        ArrayList<SceneItemImpl> arrayList = new ArrayList<SceneItemImpl>();
        for (StyleEffect styleEffect : this.highlightEffect.values()) {
            Collection<SceneNodeImpl> collection = styleEffect.getAddedSceneItems();
            if (collection == null) continue;
            for (SceneNode sceneNode : collection) {
                arrayList.add(SceneItemImpl.createItem((SceneNodeImpl)sceneNode));
            }
        }
        return arrayList.toArray(new SceneItem[arrayList.size()]);
    }

    public SceneItem[] getAddedSceneItemsForKey(int n) {
        Collection<SceneNodeImpl> collection;
        ArrayList<SceneItemImpl> arrayList = new ArrayList<SceneItemImpl>();
        StyleEffect styleEffect = this.highlightEffect.get(n);
        if (styleEffect != null && (collection = styleEffect.getAddedSceneItems()) != null) {
            for (SceneNode sceneNode : collection) {
                ((SceneNodeImpl)sceneNode).setClipBounds(null);
                arrayList.add(SceneItemImpl.createItem((SceneNodeImpl)sceneNode));
            }
        }
        return arrayList.toArray(new SceneItem[arrayList.size()]);
    }

    @Override
    public void setSingleWithZOrder(SceneItem sceneItem, int n, int n2) {
        this.interactivity.getZOrder().setZOrder(sceneItem, n2);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleWithZOrder(SceneItem[] sceneItemArray, int n, int n2) {
        this.interactivity.getZOrder().setZOrderMultiple(sceneItemArray, n2);
        this.setMultiple(sceneItemArray, n);
    }

    @Override
    public void setSingleToFront(SceneItem sceneItem, int n) {
        this.interactivity.getZOrder().moveToFront(sceneItem);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleToFront(SceneItem[] sceneItemArray, int n) {
        this.interactivity.getZOrder().moveToFrontMultiple(sceneItemArray);
        this.setMultiple(sceneItemArray, n);
    }

    @Override
    public void setSingleToBack(SceneItem sceneItem, int n) {
        this.interactivity.getZOrder().moveToBack(sceneItem);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleToBack(SceneItem[] sceneItemArray, int n) {
        this.interactivity.getZOrder().moveToBackMultiple(sceneItemArray);
        this.setMultiple(sceneItemArray, n);
    }

    @Override
    public void setSingleWithZOrderWithReset(SceneItem sceneItem, int n, int n2) {
        this.interactivity.getZOrder().resetGroup(sceneItem);
        this.interactivity.getZOrder().setZOrder(sceneItem, n2);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleWithZOrderWithReset(SceneItem[] sceneItemArray, int n, int n2) {
        this.interactivity.getZOrder().resetGroupMultiple(sceneItemArray);
        this.interactivity.getZOrder().setZOrderMultiple(sceneItemArray, n2);
        this.setMultiple(sceneItemArray, n);
    }

    @Override
    public void setSingleToFrontWithReset(SceneItem sceneItem, int n) {
        this.interactivity.getZOrder().resetGroup(sceneItem);
        this.interactivity.getZOrder().moveToFront(sceneItem);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleToFrontWithReset(SceneItem[] sceneItemArray, int n) {
        this.interactivity.getZOrder().resetGroupMultiple(sceneItemArray);
        this.interactivity.getZOrder().moveToFrontMultiple(sceneItemArray);
        this.setMultiple(sceneItemArray, n);
    }

    @Override
    public void setSingleToBackWithReset(SceneItem sceneItem, int n) {
        this.interactivity.getZOrder().resetGroup(sceneItem);
        this.interactivity.getZOrder().moveToBack(sceneItem);
        this.setSingle(sceneItem, n);
    }

    @Override
    public void setMultipleToBackWithReset(SceneItem[] sceneItemArray, int n) {
        this.interactivity.getZOrder().resetGroupMultiple(sceneItemArray);
        this.interactivity.getZOrder().moveToBackMultiple(sceneItemArray);
        this.setMultiple(sceneItemArray, n);
    }
}

