/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.geom.GeomInternalUtilities;
import com.ibm.vis.engine.internal.grammar.label.TooltipEvaluator;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionExclusionFilter;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionFilter;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionMetaFilter;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionRowsFilter;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionTooltipFilter;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionTypeFilter;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class HitDetection {
    private final Vis vis;
    private SceneTree tree;
    private static final HitDetectionFilter TOOLTIP_FILTER = new HitDetectionTooltipFilter();
    private static final HitDetectionFilter META_FILTER = new HitDetectionMetaFilter();
    private static final SceneItem[] NO_MATCHES = new SceneItem[0];

    public HitDetection(Vis vis, SceneTree sceneTree) {
        this.vis = vis;
        this.tree = sceneTree;
    }

    void setSceneTree(SceneTree sceneTree) {
        this.tree = sceneTree;
    }

    public SceneItem[] getAllItems() {
        return this.doHitDetection(null, null, false, false);
    }

    public SceneItem[] getItemsAtPoint(double d, double d2) {
        return this.doHitDetection(HitDetection.makePointPoly(d, d2), null, true, false);
    }

    public SceneItem[] getItemsAtPointForType(double d, double d2, String string) {
        return this.doHitDetection(HitDetection.makePointPoly(d, d2), new HitDetectionTypeFilter(string), true, false);
    }

    public SceneItem[] getItemsInPolygon(double[] dArray, double[] dArray2) {
        return this.doHitDetection(HitDetection.makePoly(dArray, dArray2), null, true, false);
    }

    public SceneItem[] getItemsInPolygonForType(double[] dArray, double[] dArray2, String string) {
        return this.doHitDetection(HitDetection.makePoly(dArray, dArray2), new HitDetectionTypeFilter(string), true, false);
    }

    public SceneItem[] getItemsForRows(int[] nArray) {
        return this.doHitDetection(null, HitDetectionRowsFilter.createAllRowsFilter(nArray), false, false);
    }

    public SceneItem[] getItemsMatchingAnyRows(int[] nArray) {
        return this.doHitDetection(null, HitDetectionRowsFilter.createAnyRowsFilter(nArray), false, false);
    }

    public SceneItem[] getItemsExcluding(SceneItem[] sceneItemArray) {
        return this.doHitDetection(null, new HitDetectionExclusionFilter(sceneItemArray), false, false);
    }

    public SceneItem getTooltipItem(double d, double d2) {
        SceneItem[] sceneItemArray = this.doHitDetection(HitDetection.makePointPoly(d, d2), TOOLTIP_FILTER, true, true);
        return sceneItemArray.length > 0 ? sceneItemArray[0] : null;
    }

    public SceneItem getMetaItem(double d, double d2) {
        SceneItem[] sceneItemArray = this.doHitDetection(HitDetection.makePointPoly(d, d2), META_FILTER, true, true);
        return sceneItemArray.length > 0 ? sceneItemArray[0] : null;
    }

    public SceneItem[] getFilteredItems(HitDetectionFilter hitDetectionFilter) {
        return this.doHitDetection(null, hitDetectionFilter, false, false);
    }

    SceneItem[] doHitDetection(Poly poly, HitDetectionFilter hitDetectionFilter, boolean bl, boolean bl2) {
        SceneItem[] sceneItemArray;
        if (this.tree == null || this.tree.getRoot() == null) {
            return NO_MATCHES;
        }
        ArrayList<SceneNodeImpl[]> arrayList = new ArrayList<SceneNodeImpl[]>();
        this.doTreeHitDetection(arrayList, this.tree.getRoot(), poly, hitDetectionFilter, bl, bl2);
        if (arrayList.size() == 0) {
            return NO_MATCHES;
        }
        if (bl2) {
            sceneItemArray = new SceneItem[]{HitDetection.convertHit((SceneNodeImpl[])arrayList.get(0))};
        } else {
            int n = arrayList.size();
            sceneItemArray = new SceneItem[n];
            int n2 = 0;
            for (SceneNodeImpl[] sceneNodeImplArray : arrayList) {
                sceneItemArray[n2++] = HitDetection.convertHit(sceneNodeImplArray);
            }
        }
        return sceneItemArray;
    }

    private void doTreeHitDetection(List<SceneNodeImpl[]> list, SceneNodeImpl sceneNodeImpl, Poly poly, HitDetectionFilter hitDetectionFilter, boolean bl, boolean bl2) {
        if (!bl || !sceneNodeImpl.isOutOfBounds()) {
            List<SceneNodeImpl> list2;
            Poly poly2 = poly;
            if (poly != null && sceneNodeImpl.getTransform() != null && (list2 = sceneNodeImpl.getTransform().getAffine()) != null && !((Affine)((Object)list2)).isIdentity()) {
                poly2 = GeomInternalUtilities.coordinateTransform(poly, list2);
            }
            if (poly2 != null && (list2 = sceneNodeImpl.getClipBounds()) != null && poly2.distanceToGeom((Geom)((Object)list2)) > 0.0) {
                return;
            }
            list2 = this.doShapeHitDetection(sceneNodeImpl, poly2, hitDetectionFilter, bl2);
            if (list2 != null) {
                list.add(list2.toArray(new SceneNodeImpl[list2.size()]));
                if (bl2) {
                    return;
                }
            }
            if (sceneNodeImpl.getShape() != null) {
                return;
            }
            List<SceneNode> list3 = sceneNodeImpl.getChildren();
            if (list3 == null || list3.size() == 0) {
                return;
            }
            for (int i = list3.size() - 1; i >= 0; --i) {
                this.doTreeHitDetection(list, (SceneNodeImpl)list3.get(i), poly2, hitDetectionFilter, bl, bl2);
                if (!bl2 || list.size() <= 0) continue;
                return;
            }
        }
    }

    private List<SceneNodeImpl> doShapeHitDetection(SceneNodeImpl sceneNodeImpl, Poly poly, HitDetectionFilter hitDetectionFilter, boolean bl) {
        if (sceneNodeImpl.getShape() == null || sceneNodeImpl.getId() != null && sceneNodeImpl.getId().startsWith("_")) {
            return null;
        }
        if (poly == null || HitDetection.intersectsPoly(poly, sceneNodeImpl)) {
            Rect rect = sceneNodeImpl.getClipBounds();
            if (poly == null || rect == null || poly.distanceToGeom(rect) <= 0.0) {
                List<SceneNode> list;
                if (hitDetectionFilter == TOOLTIP_FILTER && !SceneIdUtil.isPartId(sceneNodeImpl.getId())) {
                    TooltipEvaluator.getBidiTooltip(this.vis, (Shape)sceneNodeImpl.getShape());
                }
                if ((list = sceneNodeImpl.getChildren()) == null || list.size() == 0) {
                    if (hitDetectionFilter == null || hitDetectionFilter.matches(sceneNodeImpl)) {
                        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
                        arrayList.add(sceneNodeImpl);
                        return arrayList;
                    }
                } else {
                    ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
                    int n = list.size();
                    for (int i = n - 1; i >= 0; --i) {
                        Object object;
                        SceneNodeImpl sceneNodeImpl2 = (SceneNodeImpl)list.get(i);
                        Poly poly2 = poly;
                        if (poly != null && sceneNodeImpl2.getTransform() != null && (object = sceneNodeImpl2.getTransform().getAffine()) != null && !((Affine)object).isIdentity()) {
                            poly2 = GeomInternalUtilities.coordinateTransform(poly, (Affine)object);
                        }
                        if ((object = this.doShapeHitDetection(sceneNodeImpl2, poly2, hitDetectionFilter, bl)) == null) continue;
                        arrayList.addAll((Collection<SceneNodeImpl>)object);
                        if (bl) break;
                    }
                    if (arrayList.size() == 0) {
                        return null;
                    }
                    arrayList.add(sceneNodeImpl);
                    return arrayList;
                }
            }
        }
        return null;
    }

    private static boolean intersectsPoly(Poly poly, SceneNodeImpl sceneNodeImpl) {
        Geom geom = sceneNodeImpl.getShape() instanceof Text ? ((Text)sceneNodeImpl.getShape()).getTextBounds().getBounds() : (sceneNodeImpl.getShape() instanceof Schema ? ((Shape)sceneNodeImpl.getShape()).getBounds() : sceneNodeImpl.getRenderInfo().getRenderGeom());
        if (geom == null) {
            return true;
        }
        return poly.distanceToGeom(geom) <= 0.0;
    }

    private static SceneItemImpl convertHit(SceneNodeImpl[] sceneNodeImplArray) {
        assert (sceneNodeImplArray.length >= 1);
        if (sceneNodeImplArray.length == 1) {
            return SceneItemImpl.createItem(sceneNodeImplArray[0]);
        }
        int n = sceneNodeImplArray.length;
        SceneItem[] sceneItemArray = new SceneItemImpl[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            sceneItemArray[i] = SceneItemImpl.createItem(sceneNodeImplArray[i]);
        }
        SceneItemImpl sceneItemImpl = SceneItemImpl.createItem(sceneNodeImplArray[n - 1]);
        sceneItemImpl.setHitChildren(sceneItemArray);
        return sceneItemImpl;
    }

    static Poly makePoly(double[] dArray, double[] dArray2) {
        double[] dArray3;
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray2.length == 0 || dArray.length != dArray2.length) {
            return new Poly(new double[]{Double.NaN}, new double[]{Double.NaN}, true);
        }
        int n = dArray.length;
        double[] dArray4 = Arrays.copyOf(dArray, n);
        Poly poly = new Poly(dArray4, dArray3 = Arrays.copyOf(dArray2, n), true);
        Rect rect = poly.getBounds();
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            if (rect.getWidth() != 0.0) {
                double d = rect.getX();
                double d2 = rect.getX2();
                return new Poly(new double[]{d, d2, d2, d}, new double[]{dArray3[0] - 1.0, dArray3[0] - 1.0, dArray3[0] + 1.0, dArray3[0] + 1.0}, true);
            }
            if (rect.getHeight() != 0.0) {
                double d = rect.getY();
                double d3 = rect.getY2();
                return new Poly(new double[]{dArray4[0] - 1.0, dArray4[0] + 1.0, dArray4[0] + 1.0, dArray4[0] - 1.0}, new double[]{d, d, d3, d3}, true);
            }
            return HitDetection.makePointPoly(dArray4[0], dArray3[0]);
        }
        return poly;
    }

    static Poly makePointPoly(double d, double d2) {
        return new Poly(new double[]{d - 1.0, d + 1.0, d + 1.0, d - 1.0}, new double[]{d2 - 1.0, d2 - 1.0, d2 + 1.0, d2 + 1.0}, true);
    }
}

