/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ImageMapPolyMaker {
    public static Point[] nodeToPoly(SceneNodeImpl sceneNodeImpl) {
        if (sceneNodeImpl.getShape() == null) {
            return new Point[0];
        }
        Geom geom = sceneNodeImpl.getRenderInfo().getRenderGeom();
        Point[] pointArray = geom != null ? ImageMapPolyMaker.geomToPoints(geom) : ImageMapPolyMaker.geomToPoints(sceneNodeImpl.getShape().getNodeBounds());
        Affine affine = sceneNodeImpl.getNetTransform();
        if (affine != null && !affine.isIdentity()) {
            int n = pointArray.length;
            for (int i = 0; i < n; ++i) {
                pointArray[i] = affine.transformPoint(pointArray[i]);
            }
        }
        return pointArray;
    }

    private static Point[] geomToPoints(Geom geom) {
        if (geom == null) {
            return new Point[0];
        }
        Rect rect = geom.getBounds();
        if (rect.getWidth() <= 1.0 && rect.getHeight() <= 1.0) {
            return ImageMapPolyMaker.smallShapeToPoints(rect.getCenterX(), rect.getCenterY());
        }
        if (geom instanceof CompositeGeom) {
            return ImageMapPolyMaker.rectToPoints(rect);
        }
        if (geom instanceof Rect) {
            return ImageMapPolyMaker.rectToPoints((Rect)geom);
        }
        if (geom instanceof Line) {
            Line line = (Line)geom;
            return ImageMapPolyMaker.outlineLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
        }
        if (geom instanceof Circle) {
            return ImageMapPolyMaker.circleToPoints((Circle)geom);
        }
        Poly poly = geom instanceof Poly ? (Poly)geom : geom.asBasic().asPoly();
        if (poly.isClosed()) {
            return ImageMapPolyMaker.expandPoly(poly, rect.getCenterX(), rect.getCenterY());
        }
        return ImageMapPolyMaker.outlinePoly(poly);
    }

    private static Point[] smallShapeToPoints(double d, double d2) {
        return new Point[]{new Point(d - 1.0, d2 - 1.0), new Point(d - 1.0, d2 + 1.0), new Point(d + 1.0, d2 + 1.0), new Point(d + 1.0, d2 - 1.0)};
    }

    private static Point[] rectToPoints(Rect rect) {
        double d = rect.getMinX() - 1.0;
        double d2 = rect.getMinY() - 1.0;
        double d3 = rect.getMaxX() + 1.0;
        double d4 = rect.getMaxY() + 1.0;
        return new Point[]{new Point(d, d2), new Point(d, d4), new Point(d3, d4), new Point(d3, d2)};
    }

    private static Point[] circleToPoints(Circle circle) {
        Poly poly = new Circle(circle.getX(), circle.getY(), circle.getR() + 1.0).asPoly();
        int n = poly.getPointCount();
        double[] dArray = poly.getX();
        double[] dArray2 = poly.getY();
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(dArray[i], dArray2[i]);
        }
        return pointArray;
    }

    private static Point[] expandPoly(Poly poly, double d, double d2) {
        int n = poly.getPointCount();
        double[] dArray = poly.getX();
        double[] dArray2 = poly.getY();
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i];
            if (d3 < d) {
                d3 -= 1.0;
            } else if (d3 > d) {
                d3 += 1.0;
            }
            double d4 = dArray2[i];
            if (d4 < d2) {
                d4 -= 1.0;
            } else if (d4 > d2) {
                d4 += 1.0;
            }
            pointArray[i] = new Point(d3, d4);
        }
        return pointArray;
    }

    private static Point[] outlineLine(double d, double d2, double d3, double d4) {
        double[] dArray = new double[2];
        ImageMapPolyMaker.getNormalizedDirection(d, d2, d3, d4, dArray);
        return new Point[]{new Point(d - dArray[0], d2 - dArray[1]), new Point(d + dArray[1], d2 - dArray[0]), new Point(d3 + dArray[1], d4 - dArray[0]), new Point(d3 + dArray[0], d4 + dArray[1]), new Point(d3 - dArray[1], d4 + dArray[0]), new Point(d - dArray[1], d2 + dArray[0])};
    }

    private static Point[] outlinePoly(Poly poly) {
        int n;
        int n2 = poly.getPointCount();
        if (n2 == 0) {
            return new Point[0];
        }
        if (n2 == 1) {
            return ImageMapPolyMaker.smallShapeToPoints(poly.getX()[0], poly.getY()[0]);
        }
        if (n2 == 2) {
            return ImageMapPolyMaker.outlineLine(poly.getX()[0], poly.getY()[0], poly.getX()[1], poly.getY()[1]);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        if ((n2 = ImageMapPolyMaker.dropClosePoints(n2, dArray, dArray2, poly.getX(), poly.getY())) == 2) {
            return ImageMapPolyMaker.outlineLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        }
        Point[] pointArray = new Point[2 * n2 + 2];
        double[] dArray3 = new double[2];
        ImageMapPolyMaker.getNormalizedDirection(dArray[0], dArray2[0], dArray[1], dArray2[1], dArray3);
        pointArray[0] = new Point(dArray[0] - dArray3[0], dArray2[0] - dArray3[1]);
        pointArray[1] = new Point(dArray[0] + dArray3[1], dArray2[0] - dArray3[0]);
        pointArray[2 * n2 + 1] = new Point(dArray[0] - dArray3[1], dArray2[0] + dArray3[0]);
        for (n = 1; n < n2 - 1; ++n) {
            ImageMapPolyMaker.getNormalizedBisector(dArray[n - 1], dArray2[n - 1], dArray[n], dArray2[n], dArray[n + 1], dArray2[n + 1], dArray3);
            pointArray[n + 1] = new Point(dArray[n] + dArray3[0], dArray2[n] + dArray3[1]);
            pointArray[2 * n2 + 1 - n] = new Point(dArray[n] - dArray3[0], dArray2[n] - dArray3[1]);
        }
        ImageMapPolyMaker.getNormalizedDirection(dArray[n2 - 2], dArray2[n2 - 2], dArray[n2 - 1], dArray2[n2 - 1], dArray3);
        pointArray[n2 + 1] = new Point(dArray[n2 - 1] + dArray3[0], dArray2[n2 - 1] + dArray3[1]);
        pointArray[n2] = new Point(dArray[n2 - 1] + dArray3[1], dArray2[n2 - 1] - dArray3[0]);
        pointArray[n2 + 2] = new Point(dArray[n2 - 1] - dArray3[1], dArray2[n2 - 1] + dArray3[0]);
        for (n = 0; n < 2 * n2 + 2; ++n) {
            assert (pointArray[n] != null);
        }
        return pointArray;
    }

    private static int dropClosePoints(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        dArray[0] = dArray3[0];
        dArray2[0] = dArray4[0];
        int n2 = 1;
        Point point = new Point(dArray[0], dArray2[0]);
        for (int i = 1; i < n - 1; ++i) {
            if (!(point.distanceToPt(dArray3[i], dArray4[i]) >= 1.0)) continue;
            dArray[n2] = dArray3[i];
            dArray2[n2] = dArray4[i];
            ++n2;
            point.setX(dArray3[i]);
            point.setY(dArray4[i]);
        }
        if (point.distanceToPt(dArray3[n - 1], dArray4[n - 1]) >= 1.0) {
            dArray[n2] = dArray3[n - 1];
            dArray2[n2] = dArray4[n - 1];
            ++n2;
        } else {
            dArray[n2 - 1] = dArray3[n - 1];
            dArray2[n2 - 1] = dArray4[n - 1];
        }
        return n2;
    }

    private static void getNormalizedDirection(double d, double d2, double d3, double d4, double[] dArray) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        dArray[0] = d5 / d7;
        dArray[1] = d6 / d7;
    }

    private static void getNormalizedBisector(double d, double d2, double d3, double d4, double d5, double d6, double[] dArray) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        d7 /= d9;
        d8 /= d9;
        double d10 = d5 - d3;
        double d11 = d6 - d4;
        d9 = Math.sqrt(d10 * d10 + d11 * d11);
        d10 /= d9;
        d11 /= d9;
        if (Math.abs(d10 - d7) < 0.001 && Math.abs(d11 - d8) < 0.001) {
            dArray[0] = d8;
            dArray[1] = -d7;
            return;
        }
        if (Math.abs(d10 + d7) < 0.001 && Math.abs(d11 + d8) < 0.001) {
            dArray[0] = -d7;
            dArray[1] = -d8;
            return;
        }
        double d12 = d7 + d10;
        double d13 = d8 + d11;
        d9 = Math.sqrt(d12 * d12 + d13 * d13);
        dArray[0] = d13 / d9;
        dArray[1] = -d12 / d9;
    }
}

