/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.data.DataDescriptor;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.DataDescriptorImpl;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.interaction.defender.DefenderFocus;
import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitRenderer;
import com.ibm.vis.engine.internal.interaction.effect.ChangeEffectsImpl;
import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.StyleEffect;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.EventCoordinateHelper;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.ChangeEffects;
import com.ibm.vis.interaction.GraphInteractivity;
import com.ibm.vis.interaction.HighlightRepresentation;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.MapPanZoomInteractivity;
import com.ibm.vis.interaction.PanZoom;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.ViewportZoom;
import com.ibm.vis.interaction.ZOrder;
import com.ibm.vis.interaction.events.DefenderViewPortEvent;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.internal.GraphInteractivityImpl;
import com.ibm.vis.interaction.internal.HighlightStateImpl;
import com.ibm.vis.interaction.internal.HitDetection;
import com.ibm.vis.interaction.internal.InteractivityMethod;
import com.ibm.vis.interaction.internal.InteractivityRegistry;
import com.ibm.vis.interaction.internal.InteractivityWrapper;
import com.ibm.vis.interaction.internal.PanZoomImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.SceneState;
import com.ibm.vis.interaction.internal.ViewportZoomImpl;
import com.ibm.vis.interaction.internal.ZOrderImpl;
import com.ibm.vis.interaction.internal.dragging.AbstractDragging;
import com.ibm.vis.interaction.internal.dragging.DataPointElementDragging;
import com.ibm.vis.interaction.internal.dragging.LabelElementDragging;
import com.ibm.vis.interaction.internal.dragging.NodeDragging;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import com.ibm.vis.interaction.internal.navigation.NavigationImpl;
import com.ibm.vis.interaction.navigation.Navigation;
import com.ibm.vis.scenetree.internal.SceneNodeJSONSerializer;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@OnDemandLoad(value="com/ibm/vis/layers/interactionLayer")
public abstract class InteractivityImpl
extends Interactivity {
    private static final String DEFAULT_HIGHLIGHT_FILL = "rgba(240,166,48,0.4)";
    private static final String DEFAULT_HIGHLIGHT_OUTLINE = "rgba(0,255,0,1.0)";
    private static final String GRAMMER_ID_PREFIX = "G";
    private static final String COORDS_ID = "Coords";
    protected final Vis vis;
    protected HashMap<Integer, StyleEffect> highlightEffect;
    protected ScrollUnitRenderer scrollUnitRenderer;
    protected DefenderFocus defenderObj;
    protected Point translate;
    protected EventCoordinateHelper coordHelper;
    private ChangeEffects changeEffects;
    private final SceneState sceneState;
    private VisJSONSpec updatedDefenderSpec;
    protected InteractivityImpl defenderTargetInteractivity;
    private final HitDetection hitDetection;
    private final ZOrder zOrder;
    private NavigationImpl navigation;
    private EventDispatcher eventDispatcher;
    private int defenderGrammarIndex = -1;
    private Double defenderZoomRange;
    private DefenderViewPortEvent defenderViewPortEvent;
    private final List<AbstractDragging> dragProviders = new ArrayList<AbstractDragging>();
    private static int endDigit = 0;
    private GraphInteractivity graphInteractivity;
    private AbstractDragging sceneItemDragging;
    private final DirtyNodeManager dirtyNodeManager;
    private InteractivityRegistry interactivityRegistry = new InteractivityRegistry();
    private ArrayList<SceneItem> newItemList;

    protected InteractivityImpl(Vis vis, EventCoordinateHelper eventCoordinateHelper, EventDispatcher eventDispatcher, Object object, DirtyNodeManager dirtyNodeManager) {
        this.vis = vis;
        this.dirtyNodeManager = dirtyNodeManager;
        this.sceneState = new SceneState();
        this.highlightEffect = new HashMap();
        HighlightRepresentation highlightRepresentation = InteractivityImpl.createHighlightRepresentation();
        StyleEffect styleEffect = new StyleEffect(0, highlightRepresentation, 0, this.sceneState);
        styleEffect.setEventDispatcher(eventDispatcher);
        this.highlightEffect.put(0, styleEffect);
        this.coordHelper = eventCoordinateHelper;
        this.zOrder = new ZOrderImpl(this);
        this.hitDetection = new HitDetection(vis, null);
        this.eventDispatcher = eventDispatcher;
        this.addDragProvider(new NodeDragging(this));
        this.addDragProvider(new LabelElementDragging(this));
        this.addDragProvider(new DataPointElementDragging(this));
        this.scrollUnitRenderer = new ScrollUnitRenderer();
        assert (eventDispatcher != null);
    }

    public final DirtyNodeManager getDirtyNodeManager() {
        return this.dirtyNodeManager;
    }

    public final SceneState getSceneState() {
        return this.sceneState;
    }

    @Override
    public final Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this);
        }
        return this.navigation;
    }

    public final Vis getVisInstance() {
        return this.vis;
    }

    public final EventCoordinateHelper getCoordHelper() {
        return this.coordHelper;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void visControlSizeChanged(int n, int n2) {
        InteractivityMethod interactivityMethod = this.interactivityRegistry.get(1000);
        if (interactivityMethod != null) {
            ((PanZoomImpl)interactivityMethod).setCanvasSize(n, n2);
        }
    }

    private static HighlightRepresentation createHighlightRepresentation() {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "fill", DEFAULT_HIGHLIGHT_FILL);
        BasicFactory.put(jSONObject, "outline", DEFAULT_HIGHLIGHT_OUTLINE);
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 2.0);
        return new HighlightRepresentation(jSONObject);
    }

    public void addLinkHighlights() {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "fill", "rgba(100,255,100,0.8)");
        BasicFactory.put(jSONObject, "outline", "rgba(100,255,100,1.0)");
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 2.0);
        HighlightRepresentation highlightRepresentation = new HighlightRepresentation(jSONObject);
        this.setHighlightRepresentation(87005, highlightRepresentation);
        jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "outline", "rgba(0, 102, 0 ,1.0)");
        BasicFactory.put(jSONObject, "fill", "rgba(100,255,100,0.6)");
        jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 3.0);
        highlightRepresentation = new HighlightRepresentation(jSONObject);
        this.setHighlightRepresentation(87006, highlightRepresentation);
        jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "outline", "rgba(255, 51, 0,1.0)");
        BasicFactory.put(jSONObject, "fill", "rgba(188,50,188,0.6)");
        jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 3.0);
        highlightRepresentation = new HighlightRepresentation(jSONObject);
        this.setHighlightRepresentation(87007, highlightRepresentation);
        jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "fill", "rgba(255, 153, 0, 0.6)");
        BasicFactory.put(jSONObject, "outline", "rgba(255, 153, 0, 1.0)");
        jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 6.0);
        highlightRepresentation = new HighlightRepresentation(jSONObject);
        this.setHighlightRepresentation(87009, highlightRepresentation);
        jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "fill", "rgba(50,255,150,0.8)");
        BasicFactory.put(jSONObject, "outline", "black");
        jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "stroke", jSONObject2);
        BasicFactory.put(jSONObject2, "width", 5.0);
        highlightRepresentation = new HighlightRepresentation(jSONObject);
        this.setHighlightRepresentation(87008, highlightRepresentation);
    }

    public void updateStateWithSceneTree(SceneTree sceneTree) {
        this.sceneState.setSceneTree(sceneTree);
        this.hitDetection.setSceneTree(sceneTree);
        if (this.navigation != null) {
            this.navigation.sceneChanged();
        }
    }

    @Override
    public SceneItem getTooltipItem(double d, double d2) {
        SceneItem sceneItem = this.hitDetection.getTooltipItem(d = this.coordHelper.shiftX(d), d2 = this.coordHelper.shiftY(d2));
        if (sceneItem != null) {
            ((SceneItemImpl)sceneItem).setVis(this.vis);
        }
        return sceneItem;
    }

    @Override
    public SceneItem getMetaItem(double d, double d2) {
        SceneItem sceneItem = this.hitDetection.getMetaItem(d = this.coordHelper.shiftX(d), d2 = this.coordHelper.shiftY(d2));
        if (sceneItem != null) {
            ((SceneItemImpl)sceneItem).setVis(this.vis);
        }
        return sceneItem;
    }

    @Override
    public SceneItem[] getAllItems(boolean bl) {
        SceneItem[] sceneItemArray = this.hitDetection.getAllItems();
        if (bl) {
            return this.decorate(sceneItemArray, 0.0, 0.0);
        }
        return this.setVis(sceneItemArray);
    }

    @Override
    @Deprecated
    public SceneItem[] createItemsForSceneTree(SceneTree sceneTree, boolean bl) {
        if (sceneTree == null) {
            return null;
        }
        HitDetection hitDetection = new HitDetection(this.vis, sceneTree);
        SceneItem[] sceneItemArray = hitDetection.getAllItems();
        if (bl) {
            return this.decorate(sceneItemArray, 0.0, 0.0);
        }
        return this.setVis(sceneItemArray);
    }

    @Override
    public SceneItem[] getItems() {
        return this.getAllItems(true);
    }

    @Override
    public SceneItem[] getItemsExcluding(SceneItem[] sceneItemArray) {
        SceneItem[] sceneItemArray2 = this.hitDetection.getItemsExcluding(sceneItemArray);
        return this.decorate(sceneItemArray2, 0.0, 0.0);
    }

    @Override
    public SceneItem[] getItemsAtPoint(double d, double d2) {
        d = this.coordHelper.shiftX(d);
        d2 = this.coordHelper.shiftY(d2);
        SceneItem[] sceneItemArray = this.hitDetection.getItemsAtPoint(d, d2);
        return this.decorate(sceneItemArray, d, d2);
    }

    @Override
    public SceneItem[] getItemsAtPointForType(double d, double d2, String string) {
        d = this.coordHelper.shiftX(d);
        d2 = this.coordHelper.shiftY(d2);
        SceneItem[] sceneItemArray = this.hitDetection.getItemsAtPointForType(d, d2, string);
        return this.decorate(sceneItemArray, d, d2);
    }

    @Override
    public SceneItem[] getItemsInPolygon(double[] dArray, double[] dArray2) {
        dArray = this.coordHelper.shiftXarray(dArray);
        dArray2 = this.coordHelper.shiftYarray(dArray2);
        SceneItem[] sceneItemArray = this.hitDetection.getItemsInPolygon(dArray, dArray2);
        return this.decorate(sceneItemArray, dArray[0], dArray2[0]);
    }

    @Override
    public SceneItem[] getItemsInPolygonForType(double[] dArray, double[] dArray2, String string) {
        dArray = this.coordHelper.shiftXarray(dArray);
        dArray2 = this.coordHelper.shiftYarray(dArray2);
        SceneItem[] sceneItemArray = this.hitDetection.getItemsInPolygonForType(dArray, dArray2, string);
        return this.decorate(sceneItemArray, dArray[0], dArray2[0]);
    }

    @Override
    public SceneItem[] getItemsForRows(int[] nArray) {
        SceneItem[] sceneItemArray = this.hitDetection.getItemsForRows(nArray);
        return this.decorate(sceneItemArray, 0.0, 0.0);
    }

    @Override
    public SceneItem[] getItemsMatchingAnyRows(int[] nArray) {
        SceneItem[] sceneItemArray = this.hitDetection.getItemsMatchingAnyRows(nArray);
        return this.decorate(sceneItemArray, 0.0, 0.0);
    }

    @Override
    public DataDescriptor[] getDataDescriptors() {
        Data[] dataArray = this.vis.getData();
        int n = dataArray.length;
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[n];
        for (int i = 0; i < n; ++i) {
            dataDescriptorArray[i] = new DataDescriptorImpl(dataArray[i]);
        }
        return dataDescriptorArray;
    }

    @Override
    public int getDataIndex(String string) {
        IdentifiableItem identifiableItem = this.vis.getByID(string);
        if (identifiableItem == null) {
            return -1;
        }
        if (identifiableItem instanceof Data) {
            return ((Data)identifiableItem).getIndex();
        }
        if (identifiableItem instanceof Field) {
            return ((Field)identifiableItem).data.getIndex();
        }
        return -1;
    }

    @Override
    public int[] getFieldIndex(String string) {
        IdentifiableItem identifiableItem = this.vis.getByID(string);
        if (identifiableItem == null || !(identifiableItem instanceof Field)) {
            return new int[]{-1, -1};
        }
        return new int[]{((Field)identifiableItem).getDataIndex(), ((Field)identifiableItem).getIndex()};
    }

    @Override
    public String getCategory(String string, double d) {
        Field field = (Field)this.vis.getByID(string);
        if (field == null) {
            return null;
        }
        int n = (int)Math.round(d);
        if (field.categories == null || n < 0 || n >= field.categories.length) {
            return null;
        }
        return field.categories[n];
    }

    @Override
    public String getFormattedLabel(String string, double d) {
        Field field = (Field)this.vis.getByID(string);
        return field == null ? null : field.getFormattedStringValue(d, -1, null);
    }

    @Override
    public int[] getMatchingRows(String[] stringArray, double[] dArray) {
        return this.vis.getMatchingRows(stringArray, dArray, true);
    }

    @Override
    public HighlightState makeHighlightState() {
        return new HighlightStateImpl(this.highlightEffect, this);
    }

    @Override
    public ZOrder getZOrder() {
        return this.zOrder;
    }

    @Override
    public GraphInteractivity getGraphInteractivity() {
        if (this.graphInteractivity == null) {
            this.graphInteractivity = new GraphInteractivityImpl(this, this.vis);
        }
        return this.graphInteractivity;
    }

    @Override
    public MapPanZoomInteractivity getMapPanZoomInteractivity() {
        return null;
    }

    @Override
    public final ViewportZoom getViewportZoom() {
        InteractivityMethod interactivityMethod = this.interactivityRegistry.get(1001);
        if (interactivityMethod == null) {
            interactivityMethod = new ViewportZoomImpl(this);
            this.interactivityRegistry.register(interactivityMethod);
        }
        return (ViewportZoom)((Object)interactivityMethod);
    }

    @Override
    public ChangeEffects getChangeEffects() {
        if (this.changeEffects == null) {
            this.changeEffects = new ChangeEffectsImpl(this.eventDispatcher);
        }
        return this.changeEffects;
    }

    public abstract void installMoreEffects();

    public abstract void installHighlightEffect(int var1);

    public abstract void installHighlightEffectOnScene(SceneTree var1, int var2);

    public abstract void rendererShowHighlights(SceneItem[] var1);

    @Override
    public void setHighlightRepresentation(int n, HighlightRepresentation highlightRepresentation) {
        if (highlightRepresentation == null) {
            this.highlightEffect.remove(n);
            return;
        }
        Effect effect = this.highlightEffect.get(n);
        if (effect == null) {
            StyleEffect styleEffect = new StyleEffect(0, highlightRepresentation, n, this.sceneState);
            styleEffect.setEventDispatcher(this.eventDispatcher);
            this.highlightEffect.put(n, styleEffect);
            this.installMoreEffects();
        } else {
            ((StyleEffect)effect).setRepresentation(highlightRepresentation);
        }
    }

    public void dispose() {
        this.highlightEffect = null;
    }

    public SceneItem[] decorate(SceneItem[] sceneItemArray, double d, double d2) {
        try {
            for (SceneItem sceneItem : sceneItemArray) {
                ((SceneItemImpl)sceneItem).decorateItem(this.vis, d, d2);
            }
            return sceneItemArray;
        }
        catch (VisException visException) {
            return new SceneItem[0];
        }
    }

    private SceneItem[] setVis(SceneItem[] sceneItemArray) {
        if (sceneItemArray != null) {
            for (SceneItem sceneItem : sceneItemArray) {
                ((SceneItemImpl)sceneItem).setVis(this.vis);
            }
        }
        return sceneItemArray;
    }

    @Override
    public SceneItem getMainHoverItem(SceneItem[] sceneItemArray) {
        if (sceneItemArray.length < 1) {
            return null;
        }
        ArrayList<SceneItem> arrayList = new ArrayList<SceneItem>();
        for (int i = 0; i < sceneItemArray.length; ++i) {
            String string = ((SceneItemImpl)sceneItemArray[i]).id;
            if (!InteractivityImpl.isInteresting(string) || string.indexOf("S") <= 0 && string.indexOf("I") <= 0) continue;
            arrayList.add(sceneItemArray[i]);
        }
        return InteractivityImpl.clipImageHighlight(arrayList);
    }

    public static boolean isInteresting(String string) {
        return string != null && !string.startsWith("_") && !SceneIdUtil.isBackId(string) && !SceneIdUtil.isOutId(string) && !SceneIdUtil.isStrokeId(string) && !SceneIdUtil.isCoordsId(string);
    }

    static SceneItem clipImageHighlight(ArrayList<SceneItem> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            SceneItemImpl sceneItemImpl = (SceneItemImpl)arrayList.get(i);
            if (SceneNodeType.IMAGE_HIGHLIGHT != sceneItemImpl.getSceneNode().getType()) {
                return sceneItemImpl;
            }
            String string = BasicFactory.replace(sceneItemImpl.getID(), "I", "S");
            for (int j = i + 1; j < n; ++j) {
                if (!string.equals(((SceneItemImpl)arrayList.get(j)).getID())) continue;
                return sceneItemImpl;
            }
        }
        return null;
    }

    public void setScrollUnitStartPoint(double d, double d2) {
        this.setTranslateInfo();
        if (this.defenderGrammarIndex != -1) {
            this.scrollUnitRenderer.setStartPoint(this.coordHelper.shiftX(d) - this.translate.getX(), this.coordHelper.shiftY(d2) - this.translate.getY());
        }
    }

    public double[] updateScrollUnit(double d, Shape shape, Shape shape2, Shape shape3, Shape shape4, boolean bl) {
        double[] dArray = null;
        this.setTranslateInfo();
        if (this.defenderGrammarIndex != -1) {
            dArray = this.scrollUnitRenderer.updateScrollUnit(this.coordHelper.shiftX(d) - this.translate.getX(), shape, shape2, shape3, shape4, bl);
            dArray[0] = this.coordHelper.reverseShiftY(dArray[0]);
            dArray[1] = this.coordHelper.reverseShiftY(dArray[1]);
            dArray[2] = this.coordHelper.reverseShiftX(dArray[2]);
            dArray[3] = this.coordHelper.reverseShiftX(dArray[3]);
            if (bl) {
                this.scrollUnitRenderer.resetGrabbers(shape, shape2, shape3, shape4);
                this.scrollUnitRenderer.updateSpec(this.getXCordinatesForSliderEndPoints(dArray), this.vis);
            }
        }
        return dArray;
    }

    public double[] getScrollUnitPosition() {
        double[] dArray = null;
        if (this.defenderGrammarIndex != -1) {
            dArray = this.scrollUnitRenderer.getScrollUnitPosition();
            dArray[0] = this.coordHelper.reverseShiftY(dArray[0]);
            dArray[1] = this.coordHelper.reverseShiftY(dArray[1]);
            dArray[2] = this.coordHelper.reverseShiftX(dArray[2]);
            dArray[3] = this.coordHelper.reverseShiftX(dArray[3]);
        }
        return dArray;
    }

    @Override
    public SceneTree buildDefenderScene() {
        this.vis.setScaleInteractively(true);
        VisState visState = this.vis.setTypedSpecification(this.getUpdatedDefenderSpec());
        this.vis.setScaleInteractively(false);
        return this.vis.makeSceneTree(null, visState).getSceneTree();
    }

    public VisJSONSpec getZoomChartSpec(double[] dArray) {
        double[] dArray2;
        if (this.defenderObj == null && this.defenderTargetInteractivity != null) {
            this.defenderObj = new DefenderFocus(this.defenderTargetInteractivity.vis, this.vis);
        }
        if ((dArray2 = this.getXCordinatesForSliderEndPoints(dArray)).length == 2) {
            return this.defenderObj.updateSpec(dArray2);
        }
        return null;
    }

    @Override
    public void initializeDefenderPosition() {
        double[] dArray = this.getScrollUnitPosition();
        this.defenderObj = new DefenderFocus(this.defenderTargetInteractivity.vis, this.vis);
        this.setTranslateInfo();
        this.defenderTargetInteractivity.vis.clearZoomData();
        VisJSONSpec visJSONSpec = this.getZoomChartSpec(dArray);
        this.getDefenderTargetInteractivity().setUpdatedDefenderSpec(visJSONSpec);
        this.getDefenderTargetInteractivity().setSceneTree(this.getDefenderTargetInteractivity().buildDefenderScene());
    }

    public ScrollUnitRenderer getScrollUnitRenderer() {
        return this.scrollUnitRenderer;
    }

    @Override
    public boolean isClickInScroll() {
        if (this.scrollUnitRenderer != null) {
            return this.scrollUnitRenderer.isBlnScroll();
        }
        return false;
    }

    public synchronized double[] getXCordinatesForSliderEndPoints(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = (dArray[0] + dArray[1]) * 0.5;
        SceneItem[] sceneItemArray = this.getItemsAtPointForType(dArray[2] + this.translate.getX(), d + this.translate.getY(), "coordinates");
        if (sceneItemArray.length != 0 && sceneItemArray[0].coordinates() != null) {
            dArray2[0] = sceneItemArray[0].coordinates()[1];
        }
        if ((sceneItemArray = this.getItemsAtPointForType(dArray[3] + this.translate.getX(), d + this.translate.getY(), "coordinates")).length != 0 && sceneItemArray[0].coordinates() != null) {
            dArray2[1] = sceneItemArray[0].coordinates()[1];
        }
        return dArray2;
    }

    private static double[] getTransform(SceneNode sceneNode) {
        if (sceneNode == null) {
            return null;
        }
        TransformInfo transformInfo = sceneNode.getTransform();
        if (transformInfo == null || transformInfo.getAffine() == null) {
            return null;
        }
        double[] dArray = new double[2];
        Affine affine = transformInfo.getAffine();
        dArray[0] = MathUtil.r3(affine.m02).doubleValue();
        dArray[1] = MathUtil.r3(affine.m12).doubleValue();
        return dArray;
    }

    private void setTranslateInfo() {
        this.setThumbnailGrammar();
        String string = GRAMMER_ID_PREFIX + this.defenderGrammarIndex + COORDS_ID;
        SceneNode sceneNode = this.sceneState.getSceneNodeById(string);
        double[] dArray = InteractivityImpl.getTransform(sceneNode);
        if (this.defenderGrammarIndex != -1 && dArray != null) {
            this.translate = new Point(dArray[0], dArray[1]);
        }
    }

    private void setThumbnailGrammar() {
        this.defenderGrammarIndex = -1;
        block0: for (int i = 0; i < this.vis.getGrammar().length; ++i) {
            Grammar grammar = this.vis.getGrammar()[i];
            for (Element element : grammar.elements) {
                if (!"scrollUnit".equals(element.interactionType)) continue;
                this.defenderGrammarIndex = i;
                continue block0;
            }
        }
    }

    @Override
    public void offsetSlices(SceneItem[] sceneItemArray, int n) {
        Object object;
        int[] nArray;
        AestheticSpec[] aestheticSpecArray = null;
        GrammarSpec[] grammarSpecArray = this.vis.getCurrentSpec().grammar;
        DataSpec[] dataSpecArray = this.vis.getCurrentSpec().data;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = sceneItemArray[0].getDataIndex();
        int n7 = sceneItemArray[0].elementIndex();
        int n8 = sceneItemArray[0].grammarIndex();
        aestheticSpecArray = grammarSpecArray[n8].elements[n7].offset;
        int n9 = 0;
        for (n3 = 0; n3 < sceneItemArray.length; ++n3) {
            nArray = null;
            nArray = sceneItemArray[n3].getRows();
            if (nArray == null) continue;
            n9 += nArray.length;
        }
        nArray = new int[n9];
        for (n3 = 0; n3 < sceneItemArray.length; ++n3) {
            int[] nArray2 = sceneItemArray[n3].getRows();
            if (nArray2 == null) continue;
            n4 = 0;
            while (n4 < nArray2.length) {
                nArray[n2] = nArray2[n4];
                ++n4;
                ++n2;
            }
        }
        boolean bl = false;
        if (aestheticSpecArray == null) {
            grammarSpecArray[n8].elements[n7].offset = aestheticSpecArray = new AestheticSpec[1];
            aestheticSpecArray[0] = new AestheticSpec();
            n2 = 0;
            bl = true;
        } else {
            n2 = aestheticSpecArray.length - 1;
            bl = aestheticSpecArray[n2].field == null;
        }
        if (aestheticSpecArray[n2].palette == null) {
            object = new MappingSpec();
            ((MappingSpec)object).at = 1;
            ((MappingSpec)object).size = n;
            MappingSpec mappingSpec = new MappingSpec();
            mappingSpec.at = 0;
            mappingSpec.size = 0;
            MappingSpec[] mappingSpecArray = new MappingSpec[]{mappingSpec, object};
            aestheticSpecArray[n2].mapping = mappingSpecArray;
        } else {
            object = new Object[]{0, n};
            aestheticSpecArray[n2].palette = object;
        }
        ++endDigit;
        if (bl) {
            object = new FieldValueRefSpec();
            ((FieldValueRefSpec)object).$ref = "_o_f_f_s_e_t_" + endDigit;
            aestheticSpecArray[n2].field = object;
        }
        if (bl) {
            object = new FieldSpec();
            ((FieldSpec)object).categories = new String[]{"unexploded", "explode_level_1"};
            ((FieldSpec)object).id = "_o_f_f_s_e_t_" + endDigit;
            ((FieldSpec)object).label = "offset";
            ((FieldSpec)object).key = false;
            int n10 = dataSpecArray[n6].fields.length;
            int n11 = dataSpecArray[n6].rows.length;
            FieldSpec[] fieldSpecArray = new FieldSpec[n10 + 1];
            for (n3 = 0; n3 < n10; ++n3) {
                fieldSpecArray[n3] = dataSpecArray[n6].fields[n3];
            }
            fieldSpecArray[n3] = object;
            dataSpecArray[n6].fields = fieldSpecArray;
            double[][] dArray = new double[n11][n10 + 1];
            for (n3 = 0; n3 < n11; ++n3) {
                for (n4 = 0; n4 < n10; ++n4) {
                    dArray[n3][n4] = dataSpecArray[n6].rows[n3][n4];
                }
                dArray[n3][n4] = 0.0;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                dArray[nArray[n3]][n10] = 1.0;
            }
            dataSpecArray[n6].rows = dArray;
        } else {
            for (n5 = 0; n5 < dataSpecArray[n6].fields.length && !dataSpecArray[n6].fields[n5].id.equals(aestheticSpecArray[n2].field.$ref); ++n5) {
            }
            for (n4 = 0; n4 < dataSpecArray[n6].rows.length; ++n4) {
                dataSpecArray[n6].rows[n4][n5] = 0.0;
            }
            for (n4 = 0; n4 < nArray.length; ++n4) {
                dataSpecArray[n6].rows[nArray[n4]][n5] = 1.0;
            }
        }
        object = this.vis.setTypedSpecification(this.vis.getCurrentSpec());
        object = this.vis.recreateSceneTree(null, (VisState)object, 0);
        this.setSceneTree(((VisState)object).getSceneTree());
    }

    @Override
    public double[] createDefenderViewPortEvent(double d, double d2, String string) {
        this.defenderViewPortEvent = new DefenderViewPortEvent(string, d, d2, this);
        return this.defenderViewPortEvent.getDefenderViewPortEndPoints();
    }

    @Override
    public void fireDefenderViewPortEvent() {
        if (this.defenderViewPortEvent != null) {
            this.eventDispatcher.notify(this.defenderViewPortEvent);
            this.defenderViewPortEvent = null;
        }
    }

    public final VisJSONSpec getUpdatedDefenderSpec() {
        return this.updatedDefenderSpec;
    }

    public final void setUpdatedDefenderSpec(VisJSONSpec visJSONSpec) {
        this.updatedDefenderSpec = visJSONSpec;
    }

    @Override
    public void addInteractivityListener(RaveListener raveListener) {
        this.eventDispatcher.addListenerToGroup("InteractivityEvent", raveListener);
    }

    @Override
    public final PanZoom getPanZoom() {
        InteractivityMethod interactivityMethod = this.interactivityRegistry.get(1000);
        if (interactivityMethod == null) {
            interactivityMethod = new PanZoomImpl(this.getCanvasDimensions(), this);
            this.interactivityRegistry.register(interactivityMethod);
        }
        return (PanZoom)((Object)interactivityMethod);
    }

    public final boolean hasRegisteredType(int n) {
        return this.interactivityRegistry.get(n) != null;
    }

    public final boolean hasPanZoom() {
        return this.interactivityRegistry.get(1000) != null;
    }

    public abstract Dim getCanvasDimensions();

    @Deprecated
    public abstract JSONArray getScene();

    public abstract void setScene(JSONArray var1);

    public abstract void setSceneTree(SceneTree var1);

    public abstract void executeInteractivity(InteractivityWrapper var1);

    @Deprecated
    public JSONArray recreateSceneTree() {
        VisState visState = this.vis.setTypedSpecification(this.vis.getCurrentSpec());
        return SceneNodeJSONSerializer.serialize(this.vis.recreateSceneTree(null, visState, 0).getSceneTree());
    }

    public SceneTree rebuildSceneTree() {
        VisState visState = this.vis.setTypedSpecification(this.vis.getCurrentSpec());
        return this.vis.recreateSceneTree(null, visState, 0).getSceneTree();
    }

    public SceneItem[] getSelected(int n) {
        SceneItem[] sceneItemArray = this.sceneState.getSelected(n);
        return this.decorate(sceneItemArray, 0.0, 0.0);
    }

    @Override
    public void startDrag(SceneItem[] sceneItemArray, double d, double d2) {
        Grammar[] grammarArray = this.vis.getGrammar();
        boolean bl = false;
        for (SceneItem sceneItem : sceneItemArray) {
            for (AbstractDragging abstractDragging : this.dragProviders) {
                if (!abstractDragging.isSupported(sceneItem, grammarArray)) continue;
                abstractDragging.startDrag(this.vis, sceneItem, sceneItemArray, d, d2);
                this.sceneItemDragging = abstractDragging;
                bl = true;
                break;
            }
            if (bl) break;
        }
    }

    @Override
    public void dragTo(double d, double d2, HighlightState highlightState) {
        if (this.sceneItemDragging != null) {
            int n = 87001;
            if (this.highlightEffect.get(n) == null) {
                n = 0;
            }
            this.sceneItemDragging.dragTo(d, d2, highlightState, n);
            this.rendererShowHighlights(this.sceneItemDragging.getHighlightedItems());
        }
    }

    @Override
    public void stopDrag() {
        if (this.sceneItemDragging != null) {
            this.sceneItemDragging.stopDrag();
        }
        this.sceneItemDragging = null;
    }

    public void addDragProvider(AbstractDragging abstractDragging) {
        this.dragProviders.add(abstractDragging);
    }

    @Override
    public void setZoomLimit(double d) {
        if (!Double.isNaN(d)) {
            this.defenderZoomRange = d;
        }
    }

    @Override
    public void setZoomUnit(String string) {
        this.vis.getVisContext().setZoomUnit(Unit.get(string, Unit.RATIO));
    }

    public double getZoomLimit() {
        return this.defenderZoomRange;
    }

    public Unit getZoomUnit() {
        return this.vis.getVisContext().getZoomUnit();
    }

    @Override
    public boolean canZoomOnDefender(double[] dArray, String string) {
        double d;
        double d2;
        Unit unit = Unit.get(string, Unit.RATIO);
        if (this.vis.getVisContext().getZoomUnit() != null) {
            unit = this.vis.getVisContext().getZoomUnit();
        }
        if (this.defenderZoomRange == null) {
            this.defenderZoomRange = 1.0;
        }
        return (d2 = dArray[1] - dArray[0]) >= (d = UnitConverter.convert(this.defenderZoomRange, unit, Unit.get(string, Unit.RATIO)));
    }

    @Override
    public void linkDefenderInteractivity(Interactivity interactivity) {
        InteractivityImpl interactivityImpl = (InteractivityImpl)interactivity;
        interactivityImpl.defenderTargetInteractivity = this;
        this.scrollUnitRenderer = interactivityImpl.getScrollUnitRenderer();
        interactivityImpl.defenderGrammarIndex = 0;
    }

    public InteractivityImpl getDefenderTargetInteractivity() {
        return this.defenderTargetInteractivity;
    }

    public void updateScene() {
        PanZoom panZoom = this.hasPanZoom() ? this.getPanZoom() : null;
        double d = 1.0;
        Point point = new Point(0.0, 0.0);
        if (panZoom != null) {
            d = panZoom.getScaleValue();
            point = panZoom.getPanValue();
        }
        VisState visState = this.vis.setTypedSpecification(this.vis.getCurrentSpec());
        visState = this.vis.recreateSceneTree(this.vis.getSize(), visState, 0);
        this.setSceneTree(visState.getSceneTree());
        if (panZoom != null) {
            ((PanZoomImpl)panZoom).setPanAndScale(point.getX(), point.getY(), d);
        }
    }

    public void applySelectionHighlightOnScene(SceneTree sceneTree, String[] stringArray, Integer n) {
        if (stringArray.length > 0) {
            this.installHighlightEffectOnScene(sceneTree, n);
            HighlightState highlightState = this.makeHighlightState();
            highlightState.setMultipleByID(stringArray, n);
            this.highlightEffect.get(n).apply();
        }
    }

    public void notifySceneChanged(boolean bl) {
        for (InteractivityMethod interactivityMethod : this.interactivityRegistry.getAll()) {
            interactivityMethod.sceneChanged(bl);
        }
    }
}

