/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.PanZoom;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.InteractivityMethod;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PanZoomImpl
implements PanZoom,
InteractivityMethod {
    private Dim canvasDim;
    private final InteractivityImpl interactivity;
    private double scaleValue;

    public PanZoomImpl(Dim dim, InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
        this.canvasDim = dim;
        this.scaleValue = 1.0;
    }

    @Override
    public void sceneChanged(boolean bl) {
        SceneTree sceneTree;
        if (bl && (sceneTree = this.getCurrentScene()) != null) {
            this.scaleValue = 1.0;
        }
    }

    @Override
    public final double getScaleValue() {
        return this.scaleValue;
    }

    @Override
    public final Point getPanValue() {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return new Point(0.0, 0.0);
        }
        Affine affine = sceneTree.getRoot().getTransform().getAffine();
        if (affine == null) {
            return new Point(0.0, 0.0);
        }
        return affine.transform(0.0, 0.0);
    }

    @Override
    public Rect getCurrentBounds() {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return null;
        }
        Dim dim = sceneTree.getScaledSize();
        Affine affine = sceneTree.getRoot().getTransform().getAffine();
        if (affine == null) {
            affine = Affine.identity();
        }
        return new Rect(affine.m02, affine.m12, dim.getWidth(), dim.getHeight());
    }

    @Override
    public void scaleBy(double d) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.scaleInternal(sceneTree, d, false);
        this.updateScene();
    }

    @Override
    public void setScale(double d) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.scaleInternal(sceneTree, d / this.scaleValue, false);
        this.updateScene();
    }

    @Override
    public void scaleAroundAPoint(double d, double d2, double d3) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.centerAroundPointInternal(sceneTree, d2, d3);
        this.scaleAroundCenter(d);
    }

    @Override
    public void scaleAroundCenter(double d) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        double d2 = this.canvasDim.getWidth() / 2.0;
        double d3 = this.canvasDim.getHeight() / 2.0;
        this.scaleInternal(sceneTree, d, false);
        this.centerAroundPointInternal(sceneTree, d2 * d, d3 * d);
        this.updateScene();
    }

    @Override
    public void centerAroundPoint(double d, double d2) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.centerAroundPointInternal(sceneTree, d, d2);
        this.updateScene();
    }

    @Override
    public void fitToCanvas() {
        double d;
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        Rect rect = this.getCurrentBounds();
        this.panInternal(sceneTree, -rect.getX(), -rect.getY());
        double d2 = rect.getHeight() < rect.getWidth() ? rect.getWidth() : rect.getHeight();
        double d3 = rect.getHeight() < rect.getWidth() ? this.canvasDim.getWidth() : this.canvasDim.getHeight();
        double d4 = d3 / d2;
        double d5 = rect.getHeight() > rect.getWidth() ? rect.getWidth() : rect.getHeight();
        double d6 = d = rect.getHeight() > rect.getWidth() ? this.canvasDim.getWidth() : this.canvasDim.getHeight();
        if (d5 * d4 > d) {
            d4 = d / d5;
        }
        this.scaleInternal(sceneTree, d4, false);
        this.updateScene();
    }

    @Override
    public void panBy(double d, double d2) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.panInternal(sceneTree, d, d2);
        this.updateScene();
    }

    @Override
    public void panByProportion(double d, double d2) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        Rect rect = this.getCurrentBounds();
        double d3 = d * rect.getWidth();
        double d4 = d2 * rect.getHeight();
        this.panInternal(sceneTree, d3, d4);
        this.updateScene();
    }

    @Override
    public void panAndScaleBy(double d, double d2, double d3) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.scaleInternal(sceneTree, d3, false);
        this.panInternal(sceneTree, d, d2);
        this.updateScene();
    }

    public void setPanAndScale(double d, double d2, double d3) {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.resetInternal(sceneTree);
        this.scaleInternal(sceneTree, d3, false);
        this.panInternal(sceneTree, d, d2);
        this.updateScene();
    }

    @Override
    public void reset() {
        SceneTree sceneTree = this.getCurrentScene();
        if (sceneTree == null) {
            return;
        }
        this.resetInternal(sceneTree);
        this.updateScene();
    }

    private SceneTree getCurrentScene() {
        return this.interactivity.getSceneState().getSceneTree();
    }

    private void updateScene() {
        this.interactivity.rendererRedrawSceneTree();
    }

    private void resetInternal(SceneTree sceneTree) {
        ((TransformInfoImpl)sceneTree.getRoot().getTransform()).setAffine(Affine.identity());
        this.scaleValue = 1.0;
    }

    private void scaleInternal(SceneTree sceneTree, double d, boolean bl) {
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneTree.getRoot().getTransform();
        Affine affine = transformInfoImpl.getAffine();
        if (affine == null) {
            affine = Affine.identity();
        } else if (bl) {
            affine = new Affine(1.0, affine.m01, affine.m02, affine.m10, 1.0, affine.m12);
        }
        affine = new Affine(d * affine.m00, d * affine.m01, d * affine.m02, d * affine.m10, d * affine.m11, d * affine.m12);
        transformInfoImpl.setAffine(affine);
        this.scaleValue *= d;
    }

    private void panInternal(SceneTree sceneTree, double d, double d2) {
        sceneTree.getRoot().translate(d, d2);
    }

    private void centerAroundPointInternal(SceneTree sceneTree, double d, double d2) {
        double d3 = this.canvasDim.getWidth() / 2.0;
        double d4 = this.canvasDim.getHeight() / 2.0;
        double d5 = d - d3;
        double d6 = d2 - d4;
        this.panInternal(sceneTree, -d5, -d6);
    }

    public void setCanvasSize(double d, double d2) {
        this.canvasDim = new Dim(d, d2);
    }

    @Override
    public int getType() {
        return 1000;
    }
}

