/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.DataAPIUtilities;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.TooltipEvaluator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.ImageMapPolyMaker;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.spec.internal.ElementRefSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.Map;

public class SceneItemImpl
extends SceneItem {
    private static final String PART = "part";
    public final String id;
    private final SceneNodeImpl sceneNode;
    public final String type;
    private double[] coords;
    private String[][] coordFieldsArray;
    private double[] aesValues;
    private String[] aesFieldIDs;
    private Vis vis;
    private boolean dataIndexCalculated;
    private Integer dataIndex;
    private boolean rowsCalculated;
    private int[] rows;
    private boolean originalRowsCalculated;
    private int[] originalRows;
    private int[] rowsWithoutAugmentedRows;
    private boolean rowsWithoutAugmentedRowsCalculated;
    private boolean dataIndexesCached;
    private int[] dataIndexes;
    private int[][] dataRowsByDataIndexPosition;
    private int[] primaryRowsByDataIndexPosition;
    private SceneItem[] hitChildren;
    private Rect bounds;
    private Point[] outlinePoints;

    public static SceneItemImpl createItem(SceneNodeImpl sceneNodeImpl) {
        return new SceneItemImpl(sceneNodeImpl);
    }

    public SceneItemImpl(SceneNodeImpl sceneNodeImpl) {
        this.id = sceneNodeImpl.getId();
        this.type = SceneItemImpl.getSceneType(this.id);
        this.sceneNode = sceneNodeImpl;
        ShapeInfo shapeInfo = sceneNodeImpl.getShape();
        this.bounds = shapeInfo != null ? SceneItemImpl.getTransformedBounds(sceneNodeImpl, shapeInfo) : null;
        this.outlinePoints = null;
        this.dataIndexCalculated = false;
        this.dataIndex = null;
        this.rowsCalculated = false;
        this.rows = null;
        this.originalRowsCalculated = false;
        this.originalRows = null;
        this.rowsWithoutAugmentedRowsCalculated = false;
        this.rowsWithoutAugmentedRows = null;
        this.dataIndexesCached = false;
        this.dataIndexes = null;
        this.dataRowsByDataIndexPosition = null;
        this.primaryRowsByDataIndexPosition = null;
    }

    private static Rect getTransformedBounds(SceneNodeImpl sceneNodeImpl, ShapeInfo shapeInfo) {
        Rect rect = shapeInfo.getNodeBounds();
        Affine affine = sceneNodeImpl.getNetTransform();
        if (affine != null) {
            rect = affine.transformBoundingBox(rect);
        }
        return rect;
    }

    public String getID() {
        if (this.id != null) {
            return this.id;
        }
        return "none";
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String subType() {
        return SceneItemImpl.getSceneSubType(this.id, this.sceneNode);
    }

    @Override
    public Integer getDataIndex() {
        if (!this.dataIndexCalculated) {
            if (this.vis != null) {
                this.decorateItem(this.vis, 0.0, 0.0);
            }
            this.dataIndexCalculated = true;
        }
        return this.dataIndex;
    }

    @Override
    public int[] getRows() {
        if (this.getType().equals("legend")) {
            return null;
        }
        if (!this.rowsCalculated) {
            this.rows = this.getRowsFromSceneItem();
            if (this.rows == null && this.vis != null) {
                String[] stringArray = this.aestheticFields();
                String[] stringArray2 = this.coordinateFields();
                if (stringArray != null) {
                    this.rows = this.vis.getMatchingRows(stringArray, this.aestheticValues(), false);
                } else if (stringArray2 != null) {
                    this.rows = this.vis.getMatchingRows(stringArray2, this.coordinates(), false);
                }
            }
        }
        this.rowsCalculated = true;
        return this.rows;
    }

    @Override
    public int[] getRowsWithoutAugmentedRows() {
        if (!this.rowsWithoutAugmentedRowsCalculated) {
            Integer n;
            int[] nArray = this.getRows();
            this.rowsWithoutAugmentedRows = (int[])(nArray == null ? null : ((n = this.getDataIndex()) == null ? nArray : this.vis.getData()[n].getRowsWithoutAugmentedRows(nArray)));
            this.rowsWithoutAugmentedRowsCalculated = true;
        }
        return this.rowsWithoutAugmentedRows;
    }

    @Override
    public int[] getOriginalRows() {
        if (this.getType().equals("legend")) {
            return null;
        }
        if (!this.originalRowsCalculated) {
            this.originalRows = this.getOriginalRowsFromSceneItem();
            this.originalRowsCalculated = true;
        }
        return this.originalRows;
    }

    @Override
    public int[] getDataIndexes() {
        if (!this.type.equals("element") || this.vis == null || this.getDataIndex() == null) {
            return null;
        }
        if (!this.dataIndexesCached) {
            this.dataIndexes = this.vis.getData()[this.dataIndex].getDataIndexes();
            this.dataIndexesCached = true;
        }
        return this.dataIndexes;
    }

    @Override
    public int[] getRowsInTable(Object object) {
        if (!this.isElementItemWithRows()) {
            return DataAPIUtilities.EMPTY_ROWS;
        }
        int n = this.findTablePositionInDataIndexes(object);
        if (n < 0) {
            return DataAPIUtilities.EMPTY_ROWS;
        }
        this.calculateDataRowsAndPrimariesForPosition(n);
        return this.dataRowsByDataIndexPosition[n];
    }

    @Override
    public int getPrimaryRow() {
        if (!this.isElementItemWithRows()) {
            return -1;
        }
        int[] nArray = this.getDataIndexes();
        if (nArray.length < 2) {
            return -1;
        }
        return this.getPrimaryRowInTable(nArray[1]);
    }

    @Override
    public int getPrimaryRowInTable(Object object) {
        if (!this.isElementItemWithRows()) {
            return -1;
        }
        int n = this.findTablePositionInDataIndexes(object);
        if (n < 0) {
            return -1;
        }
        this.calculateDataRowsAndPrimariesForPosition(n);
        return this.primaryRowsByDataIndexPosition[n];
    }

    @Override
    public double[] coordinates() {
        return this.coords;
    }

    @Override
    public String[] coordinateFields() {
        return SceneItemImpl.getSimplifiedFieldsArray(this.coordFieldsArray);
    }

    @Override
    public String[][] coordinateFieldsArray() {
        return this.coordFieldsArray;
    }

    @Override
    public double[] aestheticValues() {
        return this.aesValues;
    }

    @Override
    public String[] aestheticFields() {
        return this.aesFieldIDs;
    }

    @Override
    public String tooltipText() {
        String string = null;
        Shape shape = (Shape)this.sceneNode.getShape();
        if (shape != null) {
            string = TooltipEvaluator.getTooltip(this.vis, shape);
        }
        return string;
    }

    @Override
    public Point[] getHitOutlinePoints() {
        if (this.outlinePoints == null) {
            this.outlinePoints = ImageMapPolyMaker.nodeToPoly(this.sceneNode);
        }
        return this.outlinePoints;
    }

    @Override
    public SceneNode getSceneNode() {
        return this.sceneNode;
    }

    private Shape getShape() {
        if (this.sceneNode == null) {
            return null;
        }
        return (Shape)this.sceneNode.getShape();
    }

    @Override
    public String meta() {
        if (this.sceneNode == null) {
            return null;
        }
        Map<String, String> map = this.sceneNode.getMetaMap();
        if (map == null) {
            return null;
        }
        Object[] objectArray = map.keySet().toArray(new String[map.size()]);
        BasicFactory.sortArray(objectArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)objectArray[i]);
            stringBuilder.append(": ");
            stringBuilder.append(map.get(objectArray[i]));
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] getMetaKeys() {
        if (this.sceneNode == null) {
            return null;
        }
        Map<String, String> map = this.sceneNode.getMetaMap();
        if (map == null) {
            return null;
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    @Override
    public String getMetaValue(String string) {
        if (this.sceneNode == null || string == null) {
            return null;
        }
        Map<String, String> map = this.sceneNode.getMetaMap();
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    @Override
    public Integer elementIndex() {
        return this.getIndexFromID('E');
    }

    @Override
    public Integer facetIndex() {
        return this.getIndexFromID('F');
    }

    @Override
    public Integer dimensionIndex() {
        return this.getIndexFromID('A');
    }

    @Override
    public Integer grammarIndex() {
        return this.getIndexFromID('G');
    }

    @Override
    public Integer legendIndex() {
        return this.getIndexFromID('L');
    }

    @Override
    public SceneItem[] getHitChildren() {
        return this.hitChildren;
    }

    @Override
    public String getBidiTooltipText() {
        String string = null;
        Shape shape = (Shape)this.sceneNode.getShape();
        if (shape != null) {
            string = TooltipEvaluator.getBidiTooltip(this.vis, shape);
        }
        return string;
    }

    void setHitChildren(SceneItem[] sceneItemArray) {
        this.hitChildren = sceneItemArray;
    }

    private boolean isTitleID() {
        return this.id != null && this.id.contains("Title");
    }

    private Integer getIndexFromID(char c) {
        if (this.id != null) {
            int n = this.id.indexOf(c) + 1;
            int n2 = this.id.length();
            if (n > 0 && n < n2) {
                double d = BasicFactory.parseDouble(this.id.substring(n, n + 1));
                if (Double.isNaN(d)) {
                    return null;
                }
                if (n + 1 >= n2) {
                    return (int)Math.round(d);
                }
                double d2 = BasicFactory.parseDouble(this.id.substring(n, n + 2));
                if (Double.isNaN(d2)) {
                    return (int)Math.round(d);
                }
                if (n + 2 >= n2) {
                    return (int)Math.round(d2);
                }
                double d3 = BasicFactory.parseDouble(this.id.substring(n, n + 3));
                return (int)Math.round(Double.isNaN(d3) ? d2 : d3);
            }
        }
        return null;
    }

    public static String getSceneType(String string) {
        if (string == null) {
            return "other";
        }
        if (string.indexOf("L") == 0) {
            return "legend";
        }
        if (string.indexOf(69) >= 0) {
            if (string.indexOf(83) >= 0 || string.indexOf(76) >= 0) {
                return "element";
            }
            return "coordinates";
        }
        if (SceneIdUtil.isCoordsId(string)) {
            return "coordinates";
        }
        if (string.indexOf(65) >= 0) {
            return "axis";
        }
        if (string.indexOf(68) == 0) {
            return "title";
        }
        return "frame";
    }

    public static String getSceneSubType(String string, SceneNodeImpl sceneNodeImpl) {
        String string2 = SceneItemImpl.getSceneType(string);
        if (string2.equals("element")) {
            String string3;
            if (sceneNodeImpl != null && (string3 = sceneNodeImpl.getMeta(PART)) != null) {
                return string3;
            }
            if (string.indexOf(83) >= 0) {
                return "main";
            }
            if (string.indexOf(76) >= 0) {
                return "label";
            }
        } else {
            if (string2.equals("axis")) {
                if (string.indexOf("Title") >= 0) {
                    return "title";
                }
                if (string.indexOf(84) >= 0) {
                    return "label";
                }
                if (string.indexOf(77) >= 0) {
                    return "mark";
                }
                if (string.indexOf(78) >= 0) {
                    return "minorMark";
                }
                if (string.indexOf(76) >= 0) {
                    return "line";
                }
                if (string.indexOf(66) >= 0) {
                    return "gridBand";
                }
                return "gridLine";
            }
            if (string2.equals("legend")) {
                if (string.indexOf("LE") > 0) {
                    if (string.indexOf("SW") >= 0) {
                        return "swatch";
                    }
                    if (string.indexOf(84) >= 0) {
                        return "label";
                    }
                    return "legendEntry";
                }
                if (string.indexOf(84) >= 0 && string.indexOf("LB") < 0) {
                    return "title";
                }
                return "none";
            }
            if (string2.equals("frame")) {
                if (string.indexOf("Back") >= 0) {
                    return "vis";
                }
                if (string.indexOf("Out") >= 0) {
                    return "grammar";
                }
                if (string.indexOf(76) >= 0) {
                    return "legend";
                }
                return "none";
            }
        }
        return "none";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SceneItemImpl)) {
            return false;
        }
        return this.getID().equals(((SceneItemImpl)object).getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public final Rect getBounds() {
        return this.bounds;
    }

    public final void setBounds(Rect rect) {
        this.bounds = rect;
    }

    public final void setVis(Vis vis) {
        this.vis = vis;
    }

    public void decorateItem(Vis vis, double d, double d2) {
        Object object;
        this.vis = vis;
        if (this.sceneNode != null) {
            object = this.sceneNode.getValue();
            String object2 = this.sceneNode.getField();
            if (object != null && object2 != null && BasicFactory.isNumber(object)) {
                double n = ((Number)object).doubleValue();
                if ("legend".equals(this.type)) {
                    this.aesFieldIDs = new String[]{object2};
                    this.aesValues = new double[]{n};
                    this.setDataIndex(vis.getMatchingData(this.aesFieldIDs));
                } else {
                    this.coordFieldsArray = new String[][]{{object2}};
                    this.coords = new double[]{n};
                    this.setDataIndex(vis.getMatchingData(SceneItemImpl.getSimplifiedFieldsArray(this.coordFieldsArray)));
                }
            } else if (object != null && BasicFactory.isString(object)) {
                this.coords = SceneItemImpl.toArray((String)object);
            } else if (object != null && object2 != null && BasicFactory.isObject(object)) {
                if ("legend".equals(this.type)) {
                    this.aesFieldIDs = new String[]{object2, object2};
                    this.aesValues = new double[2];
                    this.aesValues[0] = (Double)BasicFactory.getItem(object, "min");
                    this.aesValues[1] = (Double)BasicFactory.getItem(object, "max");
                }
            } else if (object == null && "legend".equals(this.type)) {
                if (object2 != null) {
                    this.aesFieldIDs = new String[]{object2};
                    this.aesValues = null;
                    this.setDataIndex(vis.getMatchingData(this.aesFieldIDs));
                } else {
                    this.decorateComboLegends();
                }
            }
            Integer n = this.grammarIndex();
            Grammar[] grammarArray = vis.getGrammar();
            if (n != null && grammarArray.length > n) {
                Object object3;
                Grammar grammar = grammarArray[n];
                if ("element".equals(this.type)) {
                    Integer stringArray = this.elementIndex();
                    if (stringArray != null && stringArray < grammar.elements.length) {
                        object3 = grammar.elements[this.elementIndex()];
                        this.coords = object3.getCoordinates(this.getRows());
                        this.coordFieldsArray = object3.coordinateFieldsIDs;
                        this.aesValues = object3.getAestheticValues(this.getRows());
                        this.aesFieldIDs = object3.aestheticFieldIDs;
                        if (object3.data != null) {
                            this.setDataIndex(vis.getDataIndex(object3.data.id));
                        }
                    }
                } else if ("coordinates".equals(this.type)) {
                    Point point = new Point(0.0, 0.0);
                    object3 = this.sceneNode.getNetTransform();
                    if (object3 != null) {
                        point = object3.transformPoint(point);
                    }
                    this.coords = grammar.getDataValuesFor(d - point.getX(), d2 - point.getY());
                    this.coordFieldsArray = grammar.coordinates.coordinateFieldIDs;
                } else if ("axis".equals(this.type) && !this.decorateAxisTitle()) {
                    int n2 = this.dimensionIndex();
                    if (n2 > 0 && grammar.coordinates.containsCluster()) {
                        object3 = grammar.coordinates.getAxisForDimension(n2);
                        this.coordFieldsArray = object3.getHierarchicalFieldIDs();
                    } else if (n2 >= 0 && n2 < grammar.coordinates.coordinateFieldIDs.length && (object3 = grammar.coordinates.coordinateFieldIDs[n2]) != null && ((String[])object3).length > 0) {
                        this.coordFieldsArray = new String[][]{object3};
                    }
                    object3 = this.getSceneNode().getValue();
                    if (object3 == null && this.sceneNode.getParent() != null) {
                        object3 = this.sceneNode.getParent().getValue();
                    }
                    this.coords = SceneItemImpl.coordsFromValue(object3);
                }
                String[] stringArray = SceneItemImpl.getSimplifiedFieldsArray(this.coordFieldsArray);
                if (stringArray != null) {
                    this.setDataIndex(vis.getMatchingData(stringArray));
                }
            }
        }
        if ((object = this.getHitChildren()) != null) {
            for (SceneItem sceneItem : object) {
                ((SceneItemImpl)sceneItem).decorateItem(vis, d, d2);
            }
        }
    }

    private void setDataIndex(Integer n) {
        if (this.dataIndex == null && n != null) {
            this.dataIndex = n;
            this.dataIndexCalculated = true;
        }
    }

    private void decorateComboLegends() {
        VisJSONSpec visJSONSpec = this.vis.getCurrentSpec();
        if (visJSONSpec.legends != null) {
            int n = this.legendIndex();
            Integer n2 = this.elementIndex();
            if (n2 != null && n < visJSONSpec.legends.length) {
                int n3 = n2;
                LegendSpec legendSpec = visJSONSpec.legends[n];
                ElementRefSpec[] elementRefSpecArray = legendSpec.elements;
                if (elementRefSpecArray != null && elementRefSpecArray.length > n3) {
                    Grammar[] grammarArray;
                    for (Grammar grammar : grammarArray = this.vis.getGrammar()) {
                        if (grammar.elements.length <= n3 || elementRefSpecArray[n3].$ref == null) continue;
                        for (Element element : grammar.elements) {
                            Object[] objectArray;
                            if (!elementRefSpecArray[n3].$ref.equals(element.id) || (objectArray = element.getDescription()) == null || !(objectArray[0] instanceof FieldValueRefSpec)) continue;
                            this.coordFieldsArray = new String[2][];
                            this.coordFieldsArray[0] = new String[1];
                            this.coordFieldsArray[0][0] = ((FieldValueRefSpec)objectArray[0]).$ref;
                            this.coords = new double[1];
                            this.coords[0] = 0.0;
                        }
                    }
                }
            }
        }
    }

    private boolean decorateAxisTitle() {
        String string;
        Text text;
        String string2 = null;
        if (this.isTitleID() && (text = (Text)this.getSceneNode().getShape()) != null && (string = text.toString()) != null) {
            Element[] elementArray;
            int n = this.grammarIndex();
            Grammar grammar = this.vis.getGrammar()[n];
            for (Element element : elementArray = grammar.elements) {
                Field[] fieldArray;
                if (element.data == null || (fieldArray = element.data.fields) == null) continue;
                for (Field field : fieldArray) {
                    if (!string.equals(field.label)) continue;
                    string2 = field.id;
                    break;
                }
                if (string2 != null) break;
            }
        }
        if (string2 != null) {
            this.coordFieldsArray = new String[2][];
            this.coordFieldsArray[0] = new String[1];
            this.coordFieldsArray[0][0] = string2;
            this.coords = new double[1];
            this.coords[0] = 0.0;
            return true;
        }
        return false;
    }

    private static String[] getSimplifiedFieldsArray(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i] == null || stringArray[i].length > 1 ? null : stringArray[i][0];
        }
        return stringArray2;
    }

    static double[] coordsFromValue(Object object) {
        if (object == null) {
            return null;
        }
        if (BasicFactory.isNumber(object)) {
            return new double[]{((Number)object).doubleValue()};
        }
        if (BasicFactory.isString(object)) {
            return SceneItemImpl.toArray((String)object);
        }
        return null;
    }

    private static double[] toArray(String string) {
        String[] stringArray = string.split(";");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = BasicFactory.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    private int[] getRowsFromSceneItem() {
        int n;
        Shape shape = this.getShape();
        if (shape == null) {
            return null;
        }
        int[] nArray = shape.getRows();
        int[] nArray2 = shape.getStructuralRows();
        if (nArray2 == null) {
            return nArray;
        }
        if (nArray == null) {
            return nArray2;
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            nArray3[n4++] = nArray[n];
        }
        for (n = 0; n < n3; ++n) {
            nArray3[n4++] = nArray2[n];
        }
        return nArray3;
    }

    private int[] getOriginalRowsFromSceneItem() {
        Shape shape = this.getShape();
        if (shape == null) {
            return null;
        }
        return shape.getOriginalRows();
    }

    private boolean isElementItemWithRows() {
        return this.type.equals("element") && this.vis != null && this.getDataIndex() != null && this.getRows() != null;
    }

    private int findTablePositionInDataIndexes(Object object) {
        int n = object == null ? this.dataIndex : DataAPIUtilities.getTableIndex(this.vis, object);
        return DataAPIUtilities.checkTablesAndGetPosition(this.vis, this.dataIndex, n);
    }

    private void calculateDataRowsAndPrimariesForPosition(int n) {
        int n2 = this.dataIndexes.length;
        if (this.dataRowsByDataIndexPosition == null) {
            this.dataRowsByDataIndexPosition = new int[n2][];
            this.primaryRowsByDataIndexPosition = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.dataRowsByDataIndexPosition[i] = null;
                this.primaryRowsByDataIndexPosition[i] = -1;
            }
        }
        if (this.dataRowsByDataIndexPosition[n] != null) {
            return;
        }
        Data[] dataArray = this.vis.getData();
        for (int i = 0; i <= n; ++i) {
            if (this.dataRowsByDataIndexPosition[i] != null) continue;
            if (i == 0) {
                int[] nArray = this.getRows();
                this.primaryRowsByDataIndexPosition[i] = nArray.length == 1 ? nArray[0] : -1;
                this.dataRowsByDataIndexPosition[i] = DataAPIUtilities.getRowsInTable(this.vis, this.dataIndexes[0], nArray, this.primaryRowsByDataIndexPosition[i], this.dataIndexes[0]);
                continue;
            }
            if (this.primaryRowsByDataIndexPosition[i - 1] >= 0) {
                this.primaryRowsByDataIndexPosition[i] = dataArray[this.dataIndexes[i - 1]].rows[this.primaryRowsByDataIndexPosition[i - 1]].getPrimaryRow();
            }
            this.dataRowsByDataIndexPosition[i] = DataAPIUtilities.getRowsInTable(this.vis, this.dataIndexes[i - 1], this.dataRowsByDataIndexPosition[i - 1], this.primaryRowsByDataIndexPosition[i - 1], this.dataIndexes[i]);
        }
    }
}

