/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeJSONSerializer;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneState {
    private SceneTree sceneTree = null;
    private JSONArray jsonScene = null;
    private Map<String, JSONObject> jsonSceneMap = null;
    private Map<Integer, Collection<String>> selectedMap = new HashMap<Integer, Collection<String>>();

    @Deprecated
    public void setScene(JSONArray jSONArray) {
        this.sceneTree = null;
        this.jsonScene = jSONArray;
        this.jsonSceneMap = null;
    }

    public void setSceneTree(SceneTree sceneTree) {
        this.sceneTree = sceneTree;
        this.jsonScene = null;
        this.jsonSceneMap = null;
    }

    public SceneTree getSceneTree() {
        return this.sceneTree;
    }

    @Deprecated
    public JSONArray getScene() {
        if (this.jsonScene == null && this.sceneTree != null) {
            this.jsonScene = SceneNodeJSONSerializer.serialize(this.sceneTree);
        }
        return this.jsonScene;
    }

    public SceneNode getSceneNodeById(String string) {
        if (this.sceneTree == null) {
            return null;
        }
        return this.sceneTree.findNode(string);
    }

    public SceneItem getById(String string) {
        if (this.sceneTree == null) {
            return null;
        }
        SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.sceneTree.findNode(string);
        if (sceneNodeImpl == null) {
            return null;
        }
        return SceneItemImpl.createItem(sceneNodeImpl);
    }

    @Deprecated
    public JSONObject getSceneJSONById(String string) {
        return this.getSceneTreeMap().get(string);
    }

    public void setSelectedIds(ArrayList<String> arrayList, int n) {
        if (arrayList == null || arrayList.size() < 1) {
            this.selectedMap.remove(n);
            return;
        }
        this.selectedMap.put(n, arrayList);
    }

    public void setSelectedItemsIDs(Collection<String> collection, int n) {
        if (collection == null || collection.size() == 0) {
            this.selectedMap.remove(n);
            return;
        }
        this.selectedMap.put(n, collection);
    }

    public ArrayList<String> getSelectedIds(int n) {
        Collection<String> collection = this.getSelectedItemIds(n);
        if (collection == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(collection);
        return arrayList;
    }

    public Collection<String> getSelectedItemIds(int n) {
        return this.selectedMap.get(n);
    }

    public SceneItem[] getSelected(int n) {
        Collection<String> collection = this.selectedMap.get(n);
        if (this.sceneTree == null || collection == null || collection.size() < 1) {
            return new SceneItem[0];
        }
        ArrayList<SceneItemImpl> arrayList = new ArrayList<SceneItemImpl>();
        for (String string : collection) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.sceneTree.findNode(string);
            if (sceneNodeImpl == null) continue;
            arrayList.add(SceneItemImpl.createItem(sceneNodeImpl));
        }
        SceneItem[] sceneItemArray = arrayList.toArray(new SceneItem[arrayList.size()]);
        return sceneItemArray;
    }

    public Set<Integer> getSelectionKeys() {
        return this.selectedMap.keySet();
    }

    public void setSelected(SceneItem[] sceneItemArray, int n) {
        if (sceneItemArray == null || sceneItemArray.length < 1) {
            this.selectedMap.remove(n);
            return;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (SceneItem sceneItem : sceneItemArray) {
            String string;
            if (sceneItem == null || (string = ((SceneItemImpl)sceneItem).id) == null) continue;
            linkedHashSet.add(string);
        }
        this.selectedMap.put(n, linkedHashSet);
    }

    public Map<Integer, ArrayList<String>> getSelectionState() {
        HashMap<Integer, ArrayList<String>> hashMap = new HashMap<Integer, ArrayList<String>>();
        for (Integer n : this.selectedMap.keySet()) {
            Collection<String> collection = this.selectedMap.get(n);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(collection);
            hashMap.put(n, arrayList);
        }
        return hashMap;
    }

    public Map<Integer, Collection<String>> getSelectionStateMap() {
        return Collections.unmodifiableMap(this.selectedMap);
    }

    public void clearSelectionState() {
        this.selectedMap.clear();
    }

    private Map<String, JSONObject> getSceneTreeMap() {
        if (this.jsonSceneMap == null) {
            this.makeMap();
        }
        return this.jsonSceneMap;
    }

    private void makeMap() {
        this.jsonSceneMap = new HashMap<String, JSONObject>();
        if (this.sceneTree == null) {
            return;
        }
        JSONArray jSONArray = SceneNodeJSONSerializer.serialize(this.sceneTree);
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            this.addItemToMap(jSONObject);
        }
    }

    private void addItemToMap(JSONObject jSONObject) {
        JSONArray jSONArray;
        String string = (String)BasicFactory.getItem(jSONObject, "id");
        if (string != null && string.charAt(0) != '_') {
            this.jsonSceneMap.put(string, jSONObject);
        }
        if ((jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, "children")) == null) {
            return;
        }
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            this.addItemToMap(jSONObject2);
        }
    }
}

