/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanOutRangeSpec;
import com.ibm.vis.spec.internal.SpanSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Viewport {
    private double[][] viewports;

    public Viewport(GrammarSpec grammarSpec) {
        if (grammarSpec == null || grammarSpec.coordinates == null || grammarSpec.coordinates.dimensions == null) {
            this.viewports = new double[0][];
        } else {
            int n = grammarSpec.coordinates.dimensions.length;
            this.viewports = new double[n][];
            for (int i = 0; i < n; ++i) {
                this.viewports[i] = new double[]{0.0, 1.0};
            }
        }
    }

    int getDimensions() {
        return this.viewports.length;
    }

    public double[][] getViewport() {
        int n = this.viewports.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[]{this.viewports[i][0], this.viewports[i][1]};
        }
        return dArrayArray;
    }

    public void setViewport(double[][] dArray) {
        int n = this.viewports.length;
        if (dArray.length < n) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.viewports[i][0] = Math.min(dArray[i][0], dArray[i][1]);
            this.viewports[i][1] = Math.max(dArray[i][0], dArray[i][1]);
        }
    }

    void panBy(double[] dArray) {
        int n = this.viewports.length;
        if (dArray.length < n) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double[] dArray2 = this.viewports[i];
            dArray2[0] = dArray2[0] + d;
            double[] dArray3 = this.viewports[i];
            dArray3[1] = dArray3[1] + d;
        }
    }

    void panByProportion(double[] dArray) {
        int n = this.viewports.length;
        if (dArray.length < n) {
            n = dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            double d = dArray[i] * (this.viewports[i][1] - this.viewports[i][0]);
            double[] dArray2 = this.viewports[i];
            dArray2[0] = dArray2[0] + d;
            double[] dArray3 = this.viewports[i];
            dArray3[1] = dArray3[1] + d;
        }
    }

    void updateGrammarSpec(GrammarSpec grammarSpec) {
        if (grammarSpec == null || grammarSpec.coordinates == null || grammarSpec.coordinates.dimensions == null) {
            if (this.viewports.length == 0) {
                return;
            }
            throw new EngineException("Grammar specification does not match viewport", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (this.viewports.length != grammarSpec.coordinates.dimensions.length) {
            throw new EngineException("Grammar specification does not match viewport", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        int n = this.viewports.length;
        for (int i = 0; i < n; ++i) {
            DimensionSpec dimensionSpec = grammarSpec.coordinates.dimensions[i];
            ScaleSpec scaleSpec = dimensionSpec.scale;
            if (scaleSpec == null) {
                dimensionSpec.scale = scaleSpec = new ScaleSpec();
            }
            if (scaleSpec.spans == null) {
                scaleSpec.spans = new SpanSpec[]{new SpanSpec()};
            }
            for (int j = 0; j < scaleSpec.spans.length; ++j) {
                Viewport.updateSpan(scaleSpec.spans[j], this.viewports[i]);
            }
        }
    }

    static void updateSpan(SpanSpec spanSpec, double[] dArray) {
        if (spanSpec.outRange == null) {
            spanSpec.outRange = new SpanOutRangeSpec();
        }
        double d = spanSpec.outRange.min != null ? spanSpec.outRange.min.doubleValue() : 0.0;
        double d2 = spanSpec.outRange.max != null ? spanSpec.outRange.max.doubleValue() : 1.0;
        double d3 = (d2 - d) / (dArray[1] - dArray[0]);
        double d4 = d - d3 * dArray[0];
        spanSpec.outRange.min = d4;
        spanSpec.outRange.max = d4 + d3;
    }
}

