/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.ViewportZoom;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.InteractivityMethod;
import com.ibm.vis.interaction.internal.Viewport;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.ProjectionParametersSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ViewportZoomImpl
implements ViewportZoom,
InteractivityMethod {
    private Viewport[] viewports;
    private final InteractivityImpl interactivity;
    private boolean allShapesGenerated;
    private SceneTree sceneTree;

    public ViewportZoomImpl(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
        this.sceneChanged(false);
    }

    public void initializeWithViewport(double[][] dArray, boolean bl, SceneTree sceneTree) {
        int n;
        for (n = 0; n < this.viewports.length; ++n) {
            this.viewports[n].setViewport(dArray);
        }
        this.allShapesGenerated = bl;
        this.sceneTree = sceneTree;
        if (bl) {
            for (n = 0; n < this.viewports.length; ++n) {
                boolean bl2 = this.interactivity.getVisInstance().getGrammar()[n].coordinates.transposesAxes();
                this.moveNodes(this.getSceneTreeRoot().getChildren(), 0.0, 0.0, bl2, n);
            }
        }
    }

    @Override
    public int getType() {
        return 1001;
    }

    @Override
    public void sceneChanged(boolean bl) {
        this.allShapesGenerated = false;
        if (bl || this.viewports == null) {
            VisJSONSpec visJSONSpec = this.interactivity.vis.getCurrentSpec();
            int n = visJSONSpec.grammar == null ? 0 : visJSONSpec.grammar.length;
            this.viewports = new Viewport[n];
            for (int i = 0; i < n; ++i) {
                this.viewports[i] = new Viewport(visJSONSpec.grammar[i]);
            }
        }
    }

    @Override
    public int getGrammarCount() {
        return this.viewports.length;
    }

    @Override
    public int getGrammarDimension(int n) {
        this.checkGrammarIndex("getGrammarDimension", n);
        return this.viewports[n].getDimensions();
    }

    @Override
    @Deprecated
    public double[][] getViewPort() {
        return this.getViewport();
    }

    @Override
    public double[][] getViewport() {
        if (0 == this.viewports.length) {
            throw new EngineException("No grammars defined in ViewportZoom#getViewPort", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        return this.viewports[0].getViewport();
    }

    @Override
    @Deprecated
    public double[][] getGrammarViewPort(int n) {
        return this.getGrammarViewport(n);
    }

    @Override
    public double[][] getGrammarViewport(int n) {
        this.checkGrammarIndex("getGrammarViewPort", n);
        return this.viewports[n].getViewport();
    }

    private void doZoom(double[][] dArray, Integer n) {
        Vis.checkViewportArray("ViewportZoom#doZoom", dArray);
        this.allShapesGenerated = false;
        if (n == null) {
            for (int i = 0; i < this.viewports.length; ++i) {
                this.viewports[i].setViewport(dArray);
            }
        } else {
            this.viewports[n].setViewport(dArray);
        }
        this.updateSpecificationAndScene(false, false);
        this.render();
    }

    @Override
    public void setGrammarViewport(double[][] dArray, int n) {
        this.checkGrammarIndex("setGrammarViewport", n);
        Vis.checkViewportArray("ViewportZoom#setGrammarViewport", dArray);
        if (!this.viewportChanged(dArray, n)) {
            return;
        }
        if (this.isPanning(dArray, n)) {
            this.doPan(dArray, n);
        } else {
            this.doZoom(dArray, n);
        }
    }

    @Override
    public void panBy(double[] dArray) {
        for (int i = 0; i < this.viewports.length; ++i) {
            double[][] dArray2 = this.viewports[i].getViewport();
            int n = Math.min(dArray2.length, dArray.length);
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = dArray2[j];
                dArray3[0] = dArray3[0] + dArray[j];
                double[] dArray4 = dArray2[j];
                dArray4[1] = dArray4[1] + dArray[j];
            }
            this.doPan(dArray2, i);
        }
    }

    @Override
    public void panGrammarBy(double[] dArray, int n) {
        this.checkGrammarIndex("panGrammarBy", n);
        double[][] dArray2 = this.viewports[n].getViewport();
        int n2 = Math.min(dArray2.length, dArray.length);
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = dArray2[i];
            dArray3[0] = dArray3[0] + dArray[i];
            double[] dArray4 = dArray2[i];
            dArray4[1] = dArray4[1] + dArray[i];
        }
        this.doPan(dArray2, n);
    }

    @Override
    public void panByProportion(double[] dArray) {
        for (int i = 0; i < this.viewports.length; ++i) {
            double[][] dArray2 = this.viewports[i].getViewport();
            int n = Math.min(dArray2.length, dArray.length);
            for (int j = 0; j < n; ++j) {
                double d = dArray2[j][1] - dArray2[j][0];
                double[] dArray3 = dArray2[j];
                dArray3[0] = dArray3[0] + d * dArray[j];
                double[] dArray4 = dArray2[j];
                dArray4[1] = dArray4[1] + d * dArray[j];
            }
            this.doPan(dArray2, i);
        }
    }

    @Override
    public void panGrammarByProportion(double[] dArray, int n) {
        this.checkGrammarIndex("panGrammarByProportion", n);
        double[][] dArray2 = this.viewports[n].getViewport();
        int n2 = Math.min(dArray2.length, dArray.length);
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i][1] - dArray2[i][0];
            double[] dArray3 = dArray2[i];
            dArray3[0] = dArray3[0] + d * dArray[i];
            double[] dArray4 = dArray2[i];
            dArray4[1] = dArray4[1] + d * dArray[i];
        }
        this.doPan(dArray2, n);
    }

    private void updateSpecificationAndScene(boolean bl, boolean bl2) {
        VisState visState = this.interactivity.getVisInstance().updateViewports(this.viewports, bl, bl2);
        this.sceneTree = visState.getSceneTree();
    }

    private void checkGrammarIndex(String string, int n) {
        if (n < 0 || n >= this.viewports.length) {
            throw new EngineException("Illegal grammar index in ViewportZoom#" + string + ": " + n + " (specification has " + this.viewports.length + " grammars)", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    private void checkIndexes(String string, int n, int n2) {
        this.checkGrammarIndex(string, n);
        int n3 = this.getGrammarChartCount(n);
        if (n2 < 0 || n2 >= n3) {
            throw new EngineException("Illegal chart index in ViewportZoom#" + string + ": " + n2 + " (grammar " + n + " has " + n3 + " grammars)", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    private static void updateProjectionMethod(VisJSONSpec visJSONSpec) {
        for (GrammarSpec grammarSpec : visJSONSpec.grammar) {
            if (grammarSpec == null || grammarSpec.elements == null) continue;
            boolean bl = false;
            for (ElementsSpec elementsSpec : grammarSpec.elements) {
                if (elementsSpec == null || !"custom".equals(elementsSpec.type)) continue;
                bl = true;
                break;
            }
            if (!bl || grammarSpec.coordinates == null || grammarSpec.coordinates.transforms == null) continue;
            for (MappedJSONObject mappedJSONObject : grammarSpec.coordinates.transforms) {
                if (!"projection".equals(((TransformSpec)mappedJSONObject).type)) continue;
                ProjectionParametersSpec projectionParametersSpec = ((TransformSpec)mappedJSONObject).projectionParameters;
                if (projectionParametersSpec.method == null) continue;
                projectionParametersSpec.method = "stretch";
            }
        }
    }

    private boolean isPanning(double[][] dArray, Integer n) {
        int[] nArray = new int[2];
        if (n == null) {
            nArray[0] = 0;
            nArray[1] = this.viewports.length;
        } else {
            nArray[0] = n;
            nArray[1] = n + 1;
        }
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            for (int j = 0; j < dArray.length && j < this.viewports[i].getViewport().length; ++j) {
                double d;
                double d2 = this.viewports[i].getViewport()[j][1] - this.viewports[i].getViewport()[j][0];
                if (MathUtil.deltaEquals(d2, d = dArray[j][1] - dArray[j][0])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameViewport(double[][] dArray, Integer n) {
        int[] nArray = new int[2];
        if (n == null) {
            nArray[0] = 0;
            nArray[1] = this.viewports.length;
        } else {
            nArray[0] = n;
            nArray[1] = n + 1;
        }
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            for (int j = 0; j < dArray.length && j < this.viewports[i].getViewport().length; ++j) {
                if (MathUtil.deltaEquals(this.viewports[i].getViewport()[j][0], dArray[j][0]) && MathUtil.deltaEquals(this.viewports[i].getViewport()[j][1], dArray[j][1])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean viewportChanged(double[][] dArray, Integer n) {
        Vis.checkViewportArray("ViewportZoom#setViewport", dArray);
        return !this.isSameViewport(dArray, n);
    }

    @Override
    public void setViewport(double[][] dArray) {
        if (!this.viewportChanged(dArray, null)) {
            return;
        }
        if (this.isPanning(dArray, null)) {
            this.doPan(dArray, null);
        } else {
            this.doZoom(dArray, null);
        }
    }

    @Override
    public void setPanViewport(double[][] dArray) {
        if (!this.viewportChanged(dArray, null)) {
            return;
        }
        if (!this.isPanning(dArray, null)) {
            this.doZoom(dArray, null);
        }
        this.doPan(dArray, null);
    }

    private void doPan(double[][] dArray, Integer n) {
        Object object;
        int n2;
        boolean bl = false;
        int[] nArray = new int[2];
        if (n == null) {
            nArray[0] = 0;
            nArray[1] = this.viewports.length;
        } else {
            nArray[0] = n;
            nArray[1] = n + 1;
        }
        double[][] dArrayArray = new double[this.viewports.length][];
        for (n2 = nArray[0]; n2 < nArray[1]; ++n2) {
            object = this.viewports[n2].getViewport();
            dArrayArray[n2] = new double[((double[][])object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (dArray.length > i) {
                    dArrayArray[n2][i] = (double)((object[i][0] - dArray[i][0]) / (dArray[i][1] - dArray[i][0]));
                    if (i == 0) {
                        dArrayArray[n2][i] = -dArrayArray[n2][i];
                    }
                    if (!(dArray[i][0] < 0.0) && !(dArray[i][1] > 1.0)) continue;
                    bl = true;
                    continue;
                }
                dArrayArray[n2][i] = 0.0;
            }
        }
        if (bl) {
            for (n2 = nArray[0]; n2 < nArray[1]; ++n2) {
                this.viewports[n2].setViewport(dArray);
            }
            this.allShapesGenerated = false;
            this.updateSpecificationAndScene(false, true);
            this.render();
        } else {
            n2 = 1;
            if (!this.allShapesGenerated) {
                n2 = 0;
                this.allShapesGenerated = true;
                this.updateSpecificationAndScene(true, true);
            }
            object = this.interactivity.getVisInstance().getVisContext();
            ((VisContext)object).setHandlingSceneTree(true);
            for (int i = 0; i < this.viewports.length; ++i) {
                Coordinates coordinates = this.interactivity.getVisInstance().getGrammar()[i].coordinates;
                boolean bl2 = coordinates.transposesAxes();
                if (n == null || i == n) {
                    double d;
                    double d2;
                    this.viewports[i].setViewport(dArray);
                    if (dArrayArray[i].length == 1) {
                        if (bl2) {
                            d2 = bl2 ? dArrayArray[i][0] : dArrayArray[i][1];
                            this.moveNodes(this.getSceneTreeRoot().getChildren(), d2, 0.0, bl2, i);
                            continue;
                        }
                        d = bl2 ? dArrayArray[i][1] : dArrayArray[i][0];
                        this.moveNodes(this.getSceneTreeRoot().getChildren(), 0.0, d, bl2, i);
                        continue;
                    }
                    if (dArrayArray[i].length <= 1) continue;
                    d2 = bl2 ? dArrayArray[i][0] : dArrayArray[i][1];
                    double d3 = d = bl2 ? dArrayArray[i][1] : dArrayArray[i][0];
                    if (bl2 && coordinates.containsCategorical()) {
                        d *= -1.0;
                    }
                    this.moveNodes(this.getSceneTreeRoot().getChildren(), d2, d, bl2, i);
                    continue;
                }
                bl2 = this.interactivity.getVisInstance().getGrammar()[i].coordinates.transposesAxes();
                this.moveNodes(this.getSceneTreeRoot().getChildren(), 0.0, 0.0, bl2, i);
            }
            ((VisContext)object).setHandlingSceneTree(false);
            this.render();
            if (n2 != 0) {
                this.interactivity.vis.applyViewport(this.viewports);
            }
        }
    }

    void render() {
        VisContext visContext = this.interactivity.getVisInstance().getVisContext();
        visContext.setConstructionFlag(2, true);
        this.interactivity.setSceneTree(this.sceneTree);
        visContext.setConstructionFlag(2, false);
    }

    private void moveNodes(List<SceneNode> list, double d, double d2, boolean bl, Integer n) {
        boolean bl2 = this.isFaceted(list);
        SceneNode sceneNode = this.sceneTree.findNode("G" + n.toString() + "Coords");
        Rect rect = sceneNode.getPhysicalBounds();
        double d3 = d * rect.getWidth();
        double d4 = d2 * rect.getHeight();
        if (bl) {
            d3 *= -1.0;
            d4 *= -1.0;
        }
        for (SceneNode sceneNode2 : list) {
            if (SceneNodeType.ELEMENT.equals((Object)sceneNode2.getType())) {
                this.moveElement(sceneNode2, d3, d4, n);
                continue;
            }
            if (SceneNodeType.AXIS.equals((Object)sceneNode2.getType()) || SceneNodeType.AXIS_BACK.equals((Object)sceneNode2.getType())) {
                if (bl2) continue;
                this.moveAxis(sceneNode2, d3, d4, bl, n);
                this.fixNodeAxisClipping(sceneNode2, this.getAxisIndex(sceneNode2), bl, n);
                continue;
            }
            if (!SceneNodeType.FACET.equals((Object)sceneNode2.getType())) continue;
            this.moveNodes(sceneNode2.getChildren(), d, d2, bl, n);
        }
    }

    private SceneNode getCoordsNode(List<SceneNode> list) {
        for (SceneNode sceneNode : list) {
            if (!SceneNodeClassId.COORDINATES.equals((Object)sceneNode.getClassId())) continue;
            return sceneNode;
        }
        return null;
    }

    private void updateOutOfBounds(SceneNode sceneNode) {
        Rect rect = this.getNodeClipping(sceneNode);
        List<SceneNode> list = sceneNode.getChildren();
        for (SceneNode sceneNode2 : list) {
            Rect rect2 = sceneNode2.getPhysicalBounds();
            if (sceneNode2.getClipBounds() != null) {
                ((SceneNodeImpl)sceneNode2).setClipBounds(null);
            }
            if (rect.intersectsRect(rect2)) {
                ((SceneNodeImpl)sceneNode2).setOutOfBounds(false);
                this.updateOutOfBounds(sceneNode2);
                continue;
            }
            ((SceneNodeImpl)sceneNode2).setOutOfBounds(true);
        }
    }

    private void moveElement(SceneNode sceneNode, double d, double d2, int n) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        if (this.getNodeGrammar(sceneNode) == n) {
            sceneNode.translate(d, d2);
            Rect rect = this.getNodeClipping(sceneNode);
            rect.translate(-d, -d2);
            sceneNode.clipTo(rect);
            this.updateOutOfBounds(sceneNode);
        }
    }

    private int getNodeGrammar(SceneNode sceneNode) {
        int n;
        String string = sceneNode.getId();
        if (string != null && (n = this.getIDGrammar(string)) > -1) {
            return n;
        }
        List<SceneNode> list = sceneNode.getChildren();
        for (SceneNode sceneNode2 : list) {
            int n2 = this.getNodeGrammar(sceneNode2);
            if (n2 <= -1) continue;
            return n2;
        }
        return -1;
    }

    private int getIDGrammar(String string) {
        double d;
        String string2 = SceneIdUtil.getGraphIndex(string);
        if (string2 != null && (d = BasicFactory.parseDouble(string2 = string2.substring(1))) == d) {
            return (int)d;
        }
        return -1;
    }

    private void moveAxis(SceneNode sceneNode, double d, double d2, boolean bl, int n) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        if (this.getNodeGrammar(sceneNode) == n) {
            int n2 = this.getAxisIndex(sceneNode);
            if (this.isHorizontalMove(n2, bl)) {
                sceneNode.translate(d, 0.0);
                ViewportZoomImpl.moveAxisTitleBack(sceneNode, d, 0.0);
            } else {
                sceneNode.translate(0.0, d2);
                ViewportZoomImpl.moveAxisTitleBack(sceneNode, 0.0, d2);
            }
        }
    }

    private static void moveAxisTitleBack(SceneNode sceneNode, double d, double d2) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getShape() == null || !(sceneNode2.getShape() instanceof Text) || sceneNode2.getShape().getID() == null || !sceneNode2.getShape().getID().contains("Title")) continue;
            sceneNode2.translate(-d, -d2);
        }
    }

    private SceneNode getSceneTreeRoot() {
        return this.sceneTree.getRoot();
    }

    private void fixNodeAxisClipping(SceneNode sceneNode, int n, boolean bl, int n2) {
        if (this.getNodeGrammar(sceneNode) == n2) {
            int n3 = n == 0 ? 0 : 1;
            double[] dArray = this.viewports[n2].getViewport()[n3];
            Scale scale = this.interactivity.getVisInstance().getGrammar()[n2].coordinates.getAxisForDimension(n).getScale();
            int n4 = scale.getFirstVisibleTick(dArray);
            int n5 = scale.getLastVisibleTick(dArray);
            Rect rect = this.getCoordsBounds(n2);
            Affine affine = this.getNodeAffine(sceneNode);
            for (SceneNode sceneNode2 : sceneNode.getChildren()) {
                SceneNodeClassId sceneNodeClassId = sceneNode2.getClassId();
                Rect rect2 = this.getNodeClipping(sceneNode2).copy();
                rect2.setWidth(Math.max(1.0, rect2.getWidth()));
                rect2.setHeight(Math.max(1.0, rect2.getHeight()));
                if (SceneNodeClassId.SHAPE.equals((Object)sceneNodeClassId) || SceneNodeClassId.SCHEMA_SHAPE.equals((Object)sceneNodeClassId)) {
                    if (sceneNode2.getShape() != null && sceneNode2.getShape() instanceof Text && sceneNode2.getShape().getID() != null && sceneNode2.getShape().getID().contains("Title")) continue;
                    if (this.isHorizontalMove(n, bl)) {
                        rect2.setX(rect.getX() - affine.m02);
                        rect2.setWidth(rect.getWidth());
                    } else {
                        rect2.setY(rect.getY() - affine.m12);
                        rect2.setHeight(rect.getHeight());
                    }
                    sceneNode2.clipTo(rect2);
                    Rect rect3 = sceneNode2.getPhysicalBounds();
                    ((SceneNodeImpl)sceneNode2).setOutOfBounds(!rect2.intersectsRect(rect3));
                    continue;
                }
                if (!SceneNodeType.AXIS_MARK.equals((Object)sceneNode2.getType()) && !SceneNodeType.AXIS_LABEL.equals((Object)sceneNode2.getType())) continue;
                this.clipToFirstAndLastTicks(sceneNode2, n, bl, scale.getTicks().size() - 1, n4, n5, rect2);
                for (SceneNode sceneNode3 : sceneNode2.getChildren()) {
                    Rect rect4 = sceneNode3.getPhysicalBounds();
                    ((SceneNodeImpl)sceneNode3).setOutOfBounds(!rect2.intersectsRect(rect4));
                }
            }
        }
    }

    private void clipToFirstAndLastTicks(SceneNode sceneNode, int n, boolean bl, int n2, int n3, int n4, Rect rect) {
        List<SceneNode> list = sceneNode.getChildren();
        if (this.isHorizontalMove(n, bl)) {
            double d = n3 > n2 ? (n2 < list.size() ? list.get(n2).getPhysicalBounds().getX2() + 1.0 : list.get(list.size() - 1).getPhysicalBounds().getX2() + 1.0) : (n3 < 0 ? list.get(0).getPhysicalBounds().getX() - 1.0 : (n3 < list.size() ? list.get(n3).getPhysicalBounds().getX() : list.get(0).getPhysicalBounds().getX()));
            double d2 = n4 > n2 ? (n2 < list.size() ? list.get(n2).getPhysicalBounds().getX2() + 1.0 : list.get(list.size() - 1).getPhysicalBounds().getX2() + 1.0) : (n4 < 0 ? list.get(0).getPhysicalBounds().getX() - 1.0 : (n4 < list.size() ? list.get(n4).getPhysicalBounds().getX2() : list.get(list.size() - 1).getPhysicalBounds().getX2()));
            rect.setX(d);
            rect.setWidth(d2 - d);
            sceneNode.clipTo(rect);
        } else {
            if (bl) {
                Coordinates coordinates = this.interactivity.getVisInstance().getGrammar()[this.getNodeGrammar((SceneNode)sceneNode)].coordinates;
                for (int i = 0; i < coordinates.axes.length; ++i) {
                    int n5;
                    if (i < 0 || i >= coordinates.scales.length || !coordinates.scales[i].isCategorical()) continue;
                    int n6 = n4 - n3;
                    int n7 = n2 - n3;
                    n3 = n5 = n7 - n6;
                    n4 = n7;
                    break;
                }
            }
            double d = n3 > n2 ? (n2 < list.size() ? list.get(n2).getPhysicalBounds().getY() - 1.0 : list.get(list.size() - 1).getPhysicalBounds().getY() - 1.0) : (n3 < 0 ? list.get(0).getPhysicalBounds().getY2() + 1.0 : (n3 < list.size() ? list.get(n3).getPhysicalBounds().getY2() : list.get(0).getPhysicalBounds().getY2()));
            double d3 = n4 > n2 ? (n2 < list.size() ? list.get(n2).getPhysicalBounds().getY() - 1.0 : list.get(list.size() - 1).getPhysicalBounds().getY() - 1.0) : (n4 < 0 ? list.get(0).getPhysicalBounds().getY2() + 1.0 : (n4 < list.size() ? list.get(n4).getPhysicalBounds().getY() : list.get(list.size() - 1).getPhysicalBounds().getY()));
            rect.setY(d3);
            rect.setHeight(d - d3);
            sceneNode.clipTo(rect);
        }
    }

    private SceneNode getTicksNode(SceneNode sceneNode) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (!SceneNodeType.AXIS_MARK.equals((Object)sceneNode2.getType())) continue;
            return sceneNode2;
        }
        return null;
    }

    private boolean isHorizontalMove(int n, boolean bl) {
        return n > 0 && !bl || n == 0 && bl;
    }

    private Rect getNodeClipping(SceneNode sceneNode) {
        Rect rect = sceneNode.getClipBounds();
        if (rect == null) {
            rect = sceneNode.getPhysicalBounds();
        }
        return rect;
    }

    private Affine getNodeAffine(SceneNode sceneNode) {
        if (sceneNode.getTransform() != null && sceneNode.getTransform().getAffine() != null) {
            return sceneNode.getTransform().getAffine();
        }
        return Affine.identity();
    }

    public Rect getCoordsBounds(int n) {
        SceneTree sceneTree = this.interactivity.getSceneState().getSceneTree();
        List<SceneNode> list = sceneTree.getRoot().getChildren();
        for (SceneNode sceneNode : list) {
            if (!SceneNodeClassId.COORDINATES.equals((Object)sceneNode.getClassId()) || this.getNodeGrammar(sceneNode) != n) continue;
            return sceneNode.getPhysicalBounds();
        }
        return null;
    }

    private Integer getAxisIndex(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            return SceneIdUtil.getIndexFromID(string, "A".charAt(0));
        }
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            Integer n = this.getAxisIndex(sceneNode2);
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    private boolean isFaceted(List<SceneNode> list) {
        for (SceneNode sceneNode : list) {
            if (!SceneNodeType.FACET.equals((Object)sceneNode.getType())) continue;
            return true;
        }
        return false;
    }

    private Grammar getGrammar(int n) {
        Vis vis = this.interactivity.getVisInstance();
        return vis.getGrammar()[n];
    }

    @Override
    public double[] screenToViewport(int n, int n2, int n3, int n4) {
        this.checkIndexes("screenToViewport", n, n2);
        return this.getGrammar(n).screenToCoordinates(n2, n3, n4);
    }

    @Override
    public boolean pointInChart(int n, int n2, int n3, int n4) {
        this.checkIndexes("pointInChart", n, n2);
        return this.getGrammar(n).pointInChart(n2, n3, n4);
    }

    @Override
    public int getGrammarChartCount(int n) {
        this.checkGrammarIndex("getGrammarChartCount", n);
        return this.getGrammar(n).getChartCount();
    }
}

