/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.ZOrder;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ZOrderImpl
extends ZOrder {
    private final InteractivityImpl interactivity;

    ZOrderImpl(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
    }

    @Override
    public void setZOrder(SceneItem sceneItem, int n) {
        SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
        if (sceneNodeImpl == null) {
            return;
        }
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
        this.setZOrderInternalSingle(elementGroupSceneNode, sceneNodeImpl, n, false);
    }

    @Override
    public void setZOrderMultiple(SceneItem[] sceneItemArray, int n) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            return;
        }
        if (sceneItemArray.length == 1) {
            this.setZOrder(sceneItemArray[0], n);
            return;
        }
        for (Map.Entry<ElementGroupSceneNode, Set<SceneNodeImpl>> entry : ZOrderImpl.makeGroups(sceneItemArray).entrySet()) {
            this.setZOrderInternalMultiple(entry.getKey(), entry.getValue(), n, false);
        }
    }

    @Override
    public void moveToFront(SceneItem sceneItem) {
        SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
        if (sceneNodeImpl == null) {
            return;
        }
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
        this.setZOrderInternalSingle(elementGroupSceneNode, sceneNodeImpl, ZOrderImpl.getLastZOrder(elementGroupSceneNode), false);
    }

    @Override
    public void moveToFrontMultiple(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            return;
        }
        if (sceneItemArray.length == 1) {
            this.moveToFront(sceneItemArray[0]);
            return;
        }
        for (Map.Entry<ElementGroupSceneNode, Set<SceneNodeImpl>> entry : ZOrderImpl.makeGroups(sceneItemArray).entrySet()) {
            ElementGroupSceneNode elementGroupSceneNode = entry.getKey();
            this.setZOrderInternalMultiple(elementGroupSceneNode, entry.getValue(), ZOrderImpl.getLastZOrder(elementGroupSceneNode), false);
        }
    }

    @Override
    public void moveToBack(SceneItem sceneItem) {
        SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
        if (sceneNodeImpl == null) {
            return;
        }
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
        this.setZOrderInternalSingle(elementGroupSceneNode, sceneNodeImpl, ZOrderImpl.getFirstZOrder(elementGroupSceneNode), true);
    }

    @Override
    public void moveToBackMultiple(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            return;
        }
        if (sceneItemArray.length == 1) {
            this.moveToBack(sceneItemArray[0]);
            return;
        }
        for (Map.Entry<ElementGroupSceneNode, Set<SceneNodeImpl>> entry : ZOrderImpl.makeGroups(sceneItemArray).entrySet()) {
            ElementGroupSceneNode elementGroupSceneNode = entry.getKey();
            this.setZOrderInternalMultiple(elementGroupSceneNode, entry.getValue(), ZOrderImpl.getFirstZOrder(elementGroupSceneNode), true);
        }
    }

    @Override
    public void resetZOrder(SceneItem sceneItem) {
        SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
        if (sceneNodeImpl == null) {
            return;
        }
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
        this.setZOrderInternalSingle(elementGroupSceneNode, sceneNodeImpl, sceneNodeImpl.getInitialZOrder(), false);
    }

    @Override
    public void resetZOrderMultiple(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            return;
        }
        if (sceneItemArray.length == 1) {
            this.resetZOrder(sceneItemArray[0]);
            return;
        }
        for (Map.Entry<ElementGroupSceneNode, Set<SceneNodeImpl>> entry : ZOrderImpl.makeGroups(sceneItemArray).entrySet()) {
            this.resetZOrderInternalMultiple(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void resetGroup(SceneItem sceneItem) {
        SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
        if (sceneNodeImpl == null) {
            return;
        }
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
        this.resetGroupInternal(elementGroupSceneNode);
    }

    @Override
    public void resetGroupMultiple(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            return;
        }
        if (sceneItemArray.length == 1) {
            this.resetGroup(sceneItemArray[0]);
            return;
        }
        for (Map.Entry<ElementGroupSceneNode, Set<SceneNodeImpl>> entry : ZOrderImpl.makeGroups(sceneItemArray).entrySet()) {
            this.resetGroupInternal(entry.getKey());
        }
    }

    @Override
    public void apply() {
        this.interactivity.rendererRedrawSceneTree();
    }

    void setZOrderInternalSingle(ElementGroupSceneNode elementGroupSceneNode, SceneNodeImpl sceneNodeImpl, int n, boolean bl) {
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        boolean bl2 = false;
        for (SceneNode sceneNode : list) {
            SceneNodeImpl sceneNodeImpl2 = (SceneNodeImpl)sceneNode;
            if (sceneNodeImpl2 == sceneNodeImpl) {
                this.setNodeZOrder(sceneNodeImpl2, n);
                continue;
            }
            if (!bl2) {
                String string = sceneNodeImpl2.getId();
                int n2 = sceneNodeImpl2.getZOrder();
                if (string != null && SceneIdUtil.isHighlightShape(string) || n2 > n || bl && n2 == n) {
                    arrayList.add(sceneNodeImpl);
                    bl2 = true;
                }
            }
            arrayList.add(sceneNodeImpl2);
        }
        if (!bl2) {
            arrayList.add(sceneNodeImpl);
        }
        list.clear();
        list.addAll(arrayList);
    }

    void setZOrderInternalMultiple(ElementGroupSceneNode elementGroupSceneNode, Set<SceneNodeImpl> set, int n, boolean bl) {
        if (set.size() == 1) {
            this.setZOrderInternalSingle(elementGroupSceneNode, set.iterator().next(), n, bl);
            return;
        }
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        ArrayList<SceneNodeImpl> arrayList2 = new ArrayList<SceneNodeImpl>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList<SceneNodeImpl> arrayList4 = arrayList2;
        for (SceneNode sceneNode : list) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneNode;
            if (set.contains(sceneNodeImpl)) {
                arrayList.add(sceneNodeImpl);
                this.setNodeZOrder(sceneNodeImpl, n);
                continue;
            }
            if (arrayList4 == arrayList2) {
                String string = sceneNodeImpl.getId();
                int n2 = sceneNodeImpl.getZOrder();
                if (string != null && SceneIdUtil.isHighlightShape(string) || n2 > n || bl && n2 == n) {
                    arrayList4 = arrayList3;
                }
            }
            arrayList4.add(sceneNodeImpl);
        }
        list.clear();
        list.addAll(arrayList2);
        list.addAll(arrayList);
        list.addAll(arrayList3);
    }

    void resetZOrderInternalMultiple(ElementGroupSceneNode elementGroupSceneNode, Set<SceneNodeImpl> set) {
        int n = set.size();
        if (n == 1) {
            SceneNodeImpl sceneNodeImpl = set.iterator().next();
            this.setZOrderInternalSingle(elementGroupSceneNode, sceneNodeImpl, sceneNodeImpl.getInitialZOrder(), false);
            return;
        }
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        int n2 = list.size();
        SceneNodeImpl[] sceneNodeImplArray = set.toArray(new SceneNodeImpl[n]);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.setNodeZOrder(sceneNodeImplArray[i], sceneNodeImplArray[i].getInitialZOrder());
            dArray[i] = sceneNodeImplArray[i].getInitialZOrder();
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 || n4 < n) {
            if (n3 < n2 && set.contains(list.get(n3))) {
                ++n3;
                continue;
            }
            if (n4 == n) {
                arrayList.add(list.get(n3++));
                continue;
            }
            if (n3 == n2) {
                arrayList.add(sceneNodeImplArray[nArray[n4++]]);
                continue;
            }
            SceneNode sceneNode = list.get(n3);
            SceneNodeImpl sceneNodeImpl = sceneNodeImplArray[nArray[n4]];
            String string = sceneNode.getId();
            if (string != null && SceneIdUtil.isHighlightShape(string) || sceneNodeImpl.getZOrder() < sceneNode.getZOrder()) {
                arrayList.add(sceneNodeImpl);
                ++n4;
                continue;
            }
            arrayList.add(sceneNode);
            ++n3;
        }
        list.clear();
        list.addAll(arrayList);
    }

    void resetGroupInternal(ElementGroupSceneNode elementGroupSceneNode) {
        int n;
        SceneNode sceneNode;
        Object object;
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        int n2 = 0;
        boolean bl = false;
        Object object2 = list.iterator();
        while (object2.hasNext() && ((object = (sceneNode = object2.next()).getId()) == null || !SceneIdUtil.isHighlightShape((String)object))) {
            ++n2;
            if (!this.setNodeZOrder((SceneNodeImpl)sceneNode, ((SceneNodeImpl)sceneNode).getInitialZOrder())) continue;
            bl = true;
        }
        if (!bl || n2 < 2) {
            return;
        }
        object2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            object2[i] = (double)list.get(i).getZOrder();
        }
        int[] nArray = BasicFactory.makeSortOrder((double[])object2);
        object = new ArrayList();
        for (n = 0; n < n2; ++n) {
            object.add(list.get(nArray[n]));
        }
        n = elementGroupSceneNode.getChildren().size();
        for (int i = n2; i < n; ++i) {
            object.add(list.get(i));
        }
        list.clear();
        list.addAll((Collection<SceneNode>)object);
    }

    boolean setNodeZOrder(SceneNodeImpl sceneNodeImpl, int n) {
        if (sceneNodeImpl.getZOrder() == n) {
            return false;
        }
        sceneNodeImpl.setZOrder(n);
        if (this.interactivity != null && this.interactivity.getDirtyNodeManager() != null) {
            this.interactivity.getDirtyNodeManager().modifyNode(sceneNodeImpl);
        }
        return true;
    }

    static Map<ElementGroupSceneNode, Set<SceneNodeImpl>> makeGroups(SceneItem[] sceneItemArray) {
        HashMap<ElementGroupSceneNode, Set<SceneNodeImpl>> hashMap = new HashMap<ElementGroupSceneNode, Set<SceneNodeImpl>>();
        for (SceneItem sceneItem : sceneItemArray) {
            SceneNodeImpl sceneNodeImpl = ZOrderImpl.findNodeForItem(sceneItem);
            if (sceneNodeImpl == null) continue;
            ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)sceneNodeImpl.getParent();
            HashSet<SceneNodeImpl> hashSet = (HashSet<SceneNodeImpl>)hashMap.get(elementGroupSceneNode);
            if (hashSet == null) {
                hashSet = new HashSet<SceneNodeImpl>();
                hashMap.put(elementGroupSceneNode, hashSet);
            }
            hashSet.add(sceneNodeImpl);
        }
        return hashMap;
    }

    public static SceneNodeImpl findNodeForItem(SceneItem sceneItem) {
        if (sceneItem == null) {
            return null;
        }
        String string = ((SceneItemImpl)sceneItem).getID();
        if (!(SceneIdUtil.identifiesElement(string) && !SceneIdUtil.isHighlightShape(string) || SceneIdUtil.isElementGroup(string))) {
            return null;
        }
        SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneItem.getSceneNode();
        if (sceneNodeImpl == null) {
            return null;
        }
        while (sceneNodeImpl.getParent() != null && sceneNodeImpl.getParent().getClassId() != SceneNodeClassId.ELEMENT_GROUP) {
            sceneNodeImpl = sceneNodeImpl.getParent();
        }
        if (sceneNodeImpl.getParent() == null || sceneNodeImpl.getParent().getClassId() != SceneNodeClassId.ELEMENT_GROUP) {
            return null;
        }
        return sceneNodeImpl;
    }

    public static int getLastZOrder(ElementGroupSceneNode elementGroupSceneNode) {
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)list.get(i);
            if (sceneNodeImpl.getId() != null && SceneIdUtil.isHighlightShape(sceneNodeImpl.getId())) continue;
            return sceneNodeImpl.getZOrder();
        }
        return 0;
    }

    public static int getFirstZOrder(ElementGroupSceneNode elementGroupSceneNode) {
        List<SceneNode> list = elementGroupSceneNode.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)list.get(i);
            if (sceneNodeImpl.getId() != null && SceneIdUtil.isHighlightShape(sceneNodeImpl.getId())) continue;
            return sceneNodeImpl.getZOrder();
        }
        return 0;
    }
}

