/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.dragging;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.HighlightStateImpl;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.VisJSONSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractDragging {
    private static final SceneItem[] NO_ITEMS = new SceneItem[0];
    protected VisJSONSpec currentSpec;
    protected SceneItem[] originalElements;
    private SceneItem[] highlightItems;
    protected Grammar[] grammar;
    private Rect dragPhysicalBounds;
    private Point previousPoint;
    protected Point totalAmountMoved;
    protected boolean mirrored = false;
    boolean needToDrawDragNode = false;
    protected final InteractivityImpl interactivity;

    protected AbstractDragging(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
        this.highlightItems = NO_ITEMS;
    }

    public final SceneItem[] getHighlightedItems() {
        return this.highlightItems;
    }

    public void startDrag(Vis vis, SceneItem sceneItem, SceneItem[] sceneItemArray, double d, double d2) {
        this.grammar = vis.getGrammar();
        this.currentSpec = vis.getCurrentSpec();
        this.mirrored = vis.getMirror();
        this.previousPoint = new Point(d, d2);
        this.totalAmountMoved = new Point(0.0, 0.0);
        if (sceneItem.grammarIndex() != null) {
            int n = sceneItem.grammarIndex();
            this.dragPhysicalBounds = this.grammar[n].getContentBounds();
        } else {
            this.dragPhysicalBounds = AbstractDragging.getCoordBoundsForItem(sceneItem, this.interactivity);
        }
        this.originalElements = this.selectDragItems(sceneItemArray);
        this.needToDrawDragNode = true;
    }

    public void dragTo(double d, double d2, HighlightState highlightState, int n) {
        if (this.needToDrawDragNode) {
            HighlightStateImpl highlightStateImpl = (HighlightStateImpl)highlightState;
            if (highlightStateImpl == null) {
                highlightStateImpl = (HighlightStateImpl)this.interactivity.makeHighlightState();
            }
            highlightStateImpl.setMultiple(this.originalElements, n);
            highlightStateImpl.applyForKey(n);
            this.highlightItems = highlightStateImpl.getAddedSceneItemsForKey(n);
            this.correctForMirroredText();
            this.needToDrawDragNode = false;
        }
        double d3 = d - this.previousPoint.getX();
        double d4 = d2 - this.previousPoint.getY();
        if (d3 == 0.0 && d4 == 0.0) {
            return;
        }
        for (SceneItem sceneItemArray : this.highlightItems) {
            Rect rect = ((SceneItemImpl)sceneItemArray).getSceneNode().getPhysicalBounds();
            if (rect == null) continue;
            double d5 = this.dragPhysicalBounds.getWidth() - rect.getX2();
            double sceneItemImpl = this.dragPhysicalBounds.getHeight() - rect.getY2();
            double d6 = -rect.getX();
            double d7 = -rect.getY();
            if (this.mirrored) {
                d6 = rect.getX2() - this.dragPhysicalBounds.getWidth();
                d5 = rect.getX();
            }
            d3 = Math.min(Math.max(d3, d6), d5);
            d4 = Math.min(Math.max(d4, d7), sceneItemImpl);
        }
        if (d3 != 0.0 || d4 != 0.0) {
            DirtyNodeManager dirtyNodeManager = this.interactivity.getDirtyNodeManager();
            double d9 = this.mirrored ? -d3 : d3;
            for (SceneItem sceneItem : this.highlightItems) {
                SceneItemImpl sceneItemImpl = (SceneItemImpl)sceneItem;
                SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneItemImpl.getSceneNode();
                dirtyNodeManager.modifyNode(sceneNodeImpl);
                AbstractDragging.translateNode(sceneNodeImpl, d9, d4);
                dirtyNodeManager.modifyNode(sceneNodeImpl);
            }
            this.totalAmountMoved = this.totalAmountMoved.add(d3, d4);
        }
        this.previousPoint.setX(d);
        this.previousPoint.setY(d2);
    }

    private static void translateNode(SceneNodeImpl sceneNodeImpl, double d, double d2) {
        if (sceneNodeImpl.getRoot() != null) {
            Point point = sceneNodeImpl.getRoot().getScale();
            sceneNodeImpl.translate(d / point.getX(), d2 / point.getY());
        }
    }

    public void stopDrag() {
        this.highlightItems = NO_ITEMS;
        this.totalAmountMoved = new Point(0.0, 0.0);
        this.interactivity.updateScene();
    }

    public abstract boolean isSupported(SceneItem var1, Grammar[] var2);

    protected abstract SceneItem[] selectDragItems(SceneItem[] var1);

    protected Dim getPhysicalSize(int n) {
        return new Dim(this.dragPhysicalBounds.getWidth(), this.dragPhysicalBounds.getHeight());
    }

    private void correctForMirroredText() {
        if (this.mirrored) {
            for (int i = 0; i < this.originalElements.length; ++i) {
                int n;
                SceneItemImpl sceneItemImpl = (SceneItemImpl)this.originalElements[i];
                Shape shape = (Shape)sceneItemImpl.getSceneNode().getShape();
                if (shape == null || 1009 != (n = shape.getType())) continue;
                SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.highlightItems[i].getSceneNode();
                TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneNodeImpl.getTransform();
                transformInfoImpl.mirror();
            }
        }
    }

    static Rect getCoordBoundsForItem(SceneItem sceneItem, InteractivityImpl interactivityImpl) {
        SceneTree sceneTree = interactivityImpl.getSceneState().getSceneTree();
        CompositeSceneNode compositeSceneNode = new CompositeSceneNode();
        for (SceneNode sceneNode : sceneTree.getRoot().getChildren()) {
            if (sceneNode.getClassId() != SceneNodeClassId.COORDINATES) continue;
            compositeSceneNode.addChild(sceneNode);
        }
        return compositeSceneNode.getPhysicalBounds();
    }

    public final SceneItem[] getHighlightItems() {
        return this.highlightItems;
    }
}

