/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.dragging;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.dragging.AbstractDragging;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FieldSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ElementDragging
extends AbstractDragging {
    protected int grammarIndex = -1;
    protected int dataIndex;
    private final Point originPoint = new Point(0.0, 0.0);
    protected Scale[] scales;
    private int[] elementsRowIndecies;
    private int fieldIndexX;
    private int fieldIndexY;
    public static final String LABEL = "L";

    public ElementDragging(InteractivityImpl interactivityImpl) {
        super(interactivityImpl);
    }

    @Override
    public void startDrag(Vis vis, SceneItem sceneItem, SceneItem[] sceneItemArray, double d, double d2) {
        super.startDrag(vis, sceneItem, sceneItemArray, d, d2);
        this.originPoint.setX(d);
        this.originPoint.setY(d2);
        if (this.grammarIndex != -1) {
            this.scales = this.grammar[0].coordinates.scales;
        }
        this.setFieldIndex(this.originalElements);
    }

    private void modifySpec() {
        double d = 0.0;
        double d2 = 0.0;
        Range range = new Range(0.0, 0.0);
        Range range2 = new Range(0.0, 0.0);
        int n = this.currentSpec.data.length;
        DataSpec[] dataSpecArray = new DataSpec[n + 1];
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4;
            dataSpecArray[i] = this.currentSpec.data[i];
            if (i != this.dataIndex) continue;
            double[][] dArray = dataSpecArray[i].rows;
            Dim dim = this.getPhysicalSize(this.grammarIndex);
            if (dim.getWidth() > 0.0 && dim.getHeight() > 0.0) {
                if (this.scales[0] != null && this.scales[0].getSpans() != null) {
                    range = this.scales[0].getSpans().get(0).getAdjustedInputRange();
                }
                if (this.scales[1] != null && this.scales[1].getSpans() != null) {
                    range2 = this.scales[1].getSpans().get(0).getAdjustedInputRange();
                }
                d4 = this.totalAmountMoved.getX();
                d3 = this.totalAmountMoved.getY();
                if (this.mirrored) {
                    d4 = -d4;
                }
                double d5 = d4 / dim.getWidth();
                double d6 = d3 / dim.getHeight();
                d = range2.getRange() * d5;
                d2 = range.getRange() * d6;
            }
            d4 = dArray[this.elementsRowIndecies[0]][this.fieldIndexX] + d;
            d3 = dArray[this.elementsRowIndecies[0]][this.fieldIndexY] - d2;
            double[] dArray2 = ElementDragging.constrainData(d4, d3, range2, range);
            dArray[this.elementsRowIndecies[0]][this.fieldIndexX] = dArray2[0];
            dArray[this.elementsRowIndecies[0]][this.fieldIndexY] = dArray2[1];
        }
    }

    private static double[] constrainData(double d, double d2, Range range, Range range2) {
        double[] dArray = new double[]{d, d2};
        if (d > range.getMax()) {
            dArray[0] = range.getMax();
        } else if (d < range.getMin()) {
            dArray[0] = range.getMin();
        }
        if (d2 > range2.getMax()) {
            dArray[1] = range2.getMax();
        } else if (d2 < range2.getMin()) {
            dArray[1] = range2.getMin();
        }
        return dArray;
    }

    public void setFieldIndex(SceneItem[] sceneItemArray) {
        if (sceneItemArray != null) {
            this.elementsRowIndecies = sceneItemArray[0].getRows();
            this.dataIndex = sceneItemArray[0].getDataIndex();
            String[] stringArray = sceneItemArray[0].coordinateFields();
            FieldSpec[] fieldSpecArray = this.currentSpec.data[this.dataIndex].fields;
            if (fieldSpecArray.length > 1) {
                for (int i = 0; i < fieldSpecArray.length; ++i) {
                    if (stringArray[0].equals(fieldSpecArray[i].id)) {
                        this.fieldIndexY = i;
                    }
                    if (!stringArray[1].equals(fieldSpecArray[i].id)) continue;
                    this.fieldIndexX = i;
                }
            }
        }
    }

    @Override
    public void stopDrag() {
        if (this.totalAmountMoved.getX() == 0.0 && this.totalAmountMoved.getY() == 0.0) {
            super.stopDrag();
            return;
        }
        this.modifySpec();
        super.stopDrag();
    }

    protected static boolean isLabel(SceneItem sceneItem) {
        String string = ((SceneItemImpl)sceneItem).getID();
        if (string == null) {
            return false;
        }
        return string.indexOf(LABEL) > -1;
    }
}

