/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.dragging;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.dragging.AbstractDragging;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.PositionOverrideSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NodeDragging
extends AbstractDragging {
    protected int grammarIndex = -1;
    protected int elementIndex = -1;
    private LayoutSpec layout;
    private boolean swapXY;
    private boolean reflectY;

    public NodeDragging(InteractivityImpl interactivityImpl) {
        super(interactivityImpl);
    }

    @Override
    protected SceneItem[] selectDragItems(SceneItem[] sceneItemArray) {
        ArrayList<SceneItem> arrayList = new ArrayList<SceneItem>();
        for (SceneItem sceneItem : sceneItemArray) {
            Integer n = sceneItem.grammarIndex();
            Integer n2 = sceneItem.elementIndex();
            if (n2 == null || n == null) continue;
            this.grammarIndex = n;
            this.elementIndex = n2;
            Element element = this.grammar[this.grammarIndex].elements[this.elementIndex];
            if (!SceneIdUtil.isGraphNode(sceneItem, element)) continue;
            arrayList.add(sceneItem);
            break;
        }
        SceneItem[] sceneItemArray2 = new SceneItem[arrayList.size()];
        return arrayList.toArray(sceneItemArray2);
    }

    private void modifySpec(Point point, int n) {
        Dim dim = this.getPhysicalSize(this.grammarIndex);
        double d = point.getX() / dim.getWidth();
        double d2 = (dim.getHeight() - point.getY()) / dim.getHeight();
        if (this.swapXY) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        if (this.reflectY) {
            d2 = 1.0 - d2;
        }
        PositionOverrideSpec positionOverrideSpec = new PositionOverrideSpec();
        positionOverrideSpec.node = n;
        positionOverrideSpec.x = d;
        positionOverrideSpec.y = d2;
        this.layout.positionOverride = NodeDragging.modifyPositionOverride(this.layout.positionOverride, positionOverrideSpec);
    }

    private static PositionOverrideSpec[] modifyPositionOverride(PositionOverrideSpec[] positionOverrideSpecArray, PositionOverrideSpec positionOverrideSpec) {
        PositionOverrideSpec[] positionOverrideSpecArray2;
        if (positionOverrideSpecArray == null) {
            positionOverrideSpecArray2 = new PositionOverrideSpec[]{positionOverrideSpec};
        } else {
            int n;
            int n2 = positionOverrideSpec.node.intValue();
            int n3 = -1;
            int n4 = positionOverrideSpecArray.length;
            for (n = 0; n3 == -1 && n < n4; ++n) {
                if (positionOverrideSpecArray[n].node.intValue() != n2) continue;
                n3 = n;
            }
            if (n3 == -1) {
                positionOverrideSpecArray2 = new PositionOverrideSpec[n4 + 1];
                for (n = 0; n < n4; ++n) {
                    positionOverrideSpecArray2[n] = positionOverrideSpecArray[n];
                }
                positionOverrideSpecArray2[n4] = positionOverrideSpec;
            } else {
                for (n = n3; n < n4 - 1; ++n) {
                    positionOverrideSpecArray[n] = positionOverrideSpecArray[n + 1];
                }
                positionOverrideSpecArray[n4 - 1] = positionOverrideSpec;
                positionOverrideSpecArray2 = positionOverrideSpecArray;
            }
        }
        return positionOverrideSpecArray2;
    }

    @Override
    public boolean isSupported(SceneItem sceneItem, Grammar[] grammarArray) {
        Integer n = sceneItem.grammarIndex();
        Integer n2 = sceneItem.elementIndex();
        if (n != null && n2 != null) {
            Element element = grammarArray[n.intValue()].elements[n2];
            if (element.layout != null && element.layout.isGraph()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void stopDrag() {
        if (this.totalAmountMoved.getX() == 0.0 && this.totalAmountMoved.getY() == 0.0) {
            super.stopDrag();
            return;
        }
        this.setLayoutProperties();
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int i = this.getHighlightItems().length - 1; i >= 0; --i) {
            SceneItem sceneItem = this.getHighlightItems()[i];
            Rect rect = ((SceneItemImpl)sceneItem).getSceneNode().getPhysicalBounds();
            if (rect == null) continue;
            Point point = rect.getCenter();
            int[] nArray = this.originalElements[i].getRows();
            if (nArray == null) continue;
            for (int n : nArray) {
                if (intPrimitiveArrayList.contains(n)) continue;
                this.modifySpec(point, n);
                intPrimitiveArrayList.add(n);
            }
        }
        super.stopDrag();
    }

    private void setLayoutProperties() {
        this.layout = this.currentSpec.grammar[this.grammarIndex].elements[this.elementIndex].positioning;
        this.swapXY = false;
        this.reflectY = false;
        if ("dag".equals(this.layout.method) || "tree".equals(this.layout.method)) {
            return;
        }
        if ("right-to-left".equals(this.layout.orientation)) {
            this.swapXY = true;
            this.reflectY = false;
        } else if ("bottom-to-top".equals(this.layout.orientation)) {
            this.swapXY = false;
            this.reflectY = true;
        } else if ("left-to-right".equals(this.layout.orientation)) {
            this.swapXY = true;
            this.reflectY = true;
        }
    }
}

