/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.events;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.events.RaveEvent;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import com.ibm.vis.ui.VisController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class EventDispatcherImpl
implements EventDispatcher {
    private final Map<Object, Collection<RaveListener>> listenersMap = new HashMap<Object, Collection<RaveListener>>();
    private final VisController visControl;
    private boolean enabled = true;
    public static final String EVENT_GROUP_ALL = "EVENT_GROUP_ALL";

    public EventDispatcherImpl(VisController visController) {
        this.visControl = visController;
    }

    @Override
    public void addListener(RaveListener raveListener) {
        this.addListenerToGroup(EVENT_GROUP_ALL, raveListener);
    }

    @Override
    public void addListenerToGroup(Object object, RaveListener raveListener) {
        Collection<RaveListener> collection = this.listenersMap.get(object);
        if (collection == null) {
            collection = new HashSet<RaveListener>();
            this.listenersMap.put(object, collection);
        }
        collection.add(raveListener);
    }

    @Override
    public void removeListener(RaveListener raveListener) {
        this.removeListenerFromGroup(EVENT_GROUP_ALL, raveListener);
    }

    @Override
    public void removeListenerFromGroup(Object object, RaveListener raveListener) {
        Collection<RaveListener> collection = this.listenersMap.get(object);
        if (collection != null) {
            collection.remove(raveListener);
        }
    }

    @Override
    public void removeAllListenersFromGroup(Object object) {
        this.listenersMap.remove(object);
    }

    @Override
    public Collection<RaveListener> getListeners(Object object) {
        Collection<RaveListener> collection = this.listenersMap.get(object);
        if (collection == null) {
            collection = new HashSet<RaveListener>();
        }
        return collection;
    }

    @Override
    public void notify(RaveEvent raveEvent) {
        if (!this.enabled) {
            return;
        }
        Collection<RaveListener> collection = this.getListenersFor(raveEvent);
        try {
            for (RaveListener raveListener : collection) {
                if (raveListener == null) continue;
                raveListener.update(raveEvent, this.visControl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private Collection<RaveListener> getListenersFor(RaveEvent raveEvent) {
        Collection<RaveListener> collection;
        Object object;
        HashSet<RaveListener> hashSet = new HashSet<RaveListener>();
        Object object2 = raveEvent.getEventSource();
        if (object2 != null && (object = this.listenersMap.get(object2)) != null) {
            hashSet.addAll((Collection<RaveListener>)object);
        }
        if ((object = raveEvent.getEventGroup()) != null && (collection = this.listenersMap.get(object)) != null) {
            hashSet.addAll(collection);
        }
        if ((collection = this.listenersMap.get(EVENT_GROUP_ALL)) != null) {
            hashSet.addAll(collection);
        }
        return hashSet;
    }
}

