/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.hitdetection;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionFilter;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.HashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class HitDetectionExclusionFilter
implements HitDetectionFilter {
    private final Set<String> excludeItems;

    public HitDetectionExclusionFilter(SceneItem[] sceneItemArray) {
        if (sceneItemArray == null || sceneItemArray.length == 0) {
            this.excludeItems = null;
        } else {
            this.excludeItems = new HashSet<String>();
            for (SceneItem sceneItem : sceneItemArray) {
                String string = ((SceneItemImpl)sceneItem).id;
                if (string == null) continue;
                this.excludeItems.add(string);
            }
        }
    }

    @Override
    public boolean matches(SceneNode sceneNode) {
        String string;
        return this.excludeItems == null || (string = sceneNode.getId()) == null || !this.excludeItems.contains(string);
    }
}

