/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.hitdetection;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionFilter;
import com.ibm.vis.scenetree.provisional.ElementInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import java.util.HashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class HitDetectionRowsFilter
implements HitDetectionFilter {
    private static final int ROW_METHOD_ALL = 0;
    private static final int ROW_METHOD_ANY = 1;
    private final int rowMethod;
    private final Set<Integer> rowSet;

    public static HitDetectionFilter createAllRowsFilter(int[] nArray) {
        return new HitDetectionRowsFilter(0, nArray);
    }

    public static HitDetectionFilter createAnyRowsFilter(int[] nArray) {
        return new HitDetectionRowsFilter(1, nArray);
    }

    private HitDetectionRowsFilter(int n, int[] nArray) {
        this.rowMethod = n;
        if (nArray == null || nArray.length == 0) {
            this.rowSet = null;
        } else {
            this.rowSet = new HashSet<Integer>();
            for (int n2 : nArray) {
                this.rowSet.add(n2);
            }
        }
    }

    @Override
    public boolean matches(SceneNode sceneNode) {
        if (this.rowSet == null) {
            return false;
        }
        ShapeInfo shapeInfo = sceneNode.getShape();
        if (shapeInfo == null) {
            return false;
        }
        ElementInfo elementInfo = shapeInfo.getElementInfo();
        int[] nArray = elementInfo.getRows();
        if (nArray == null) {
            return false;
        }
        if (this.rowMethod == 0) {
            for (int n : nArray) {
                if (this.rowSet.contains(n)) continue;
                return false;
            }
            return true;
        }
        for (int n : nArray) {
            if (!this.rowSet.contains(n)) continue;
            return true;
        }
        return false;
    }
}

