/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.internal.navigation.ChordPart;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ChordGroupPart
extends FeaturePart {
    private ChordPart pointOfRegard;
    private ArrayList<FeaturePart> xList = new ArrayList();
    private ArrayList<FeaturePart> yList = new ArrayList();

    protected ChordGroupPart(String string, Point point) {
        super(string, point);
    }

    void setPointOfRegard(ChordPart chordPart) {
        this.pointOfRegard = chordPart;
    }

    void addChord(ChordPart chordPart) {
        this.xList.add(chordPart);
        this.yList.add(chordPart);
    }

    ArrayList<FeaturePart> getChordListX() {
        return this.xList;
    }

    ArrayList<FeaturePart> getChordListY() {
        return this.yList;
    }

    void sort() {
        for (FeaturePart featurePart : this.xList) {
            ((ChordPart)featurePart).setActiveGroup(this);
        }
        for (FeaturePart featurePart : this.yList) {
            ((ChordPart)featurePart).setActiveGroup(this);
        }
        BasicFactory.sortList(this.xList, FeaturePartComparator.X);
        BasicFactory.sortList(this.yList, FeaturePartComparator.Y);
    }

    @Override
    protected FeaturePart changePart(FeatureShift featureShift) {
        if (FeatureShift.NEXT == featureShift) {
            for (FeaturePart featurePart : this.xList) {
                ((ChordPart)featurePart).setActiveGroup(this);
            }
            return this.pointOfRegard == null ? this.xList.get(0) : this.pointOfRegard;
        }
        return this;
    }
}

