/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.navigation.ChordGroupPart;
import com.ibm.vis.interaction.internal.navigation.ChordPart;
import com.ibm.vis.interaction.internal.navigation.DirectionalNavigation;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ChordNavigationBuilder {
    private SceneHelper helper;

    static FeatureNavigation getChordNavigation(InteractivityImpl interactivityImpl, NavigationInfo navigationInfo, ElementGroupSceneNode elementGroupSceneNode) {
        return new ChordNavigationBuilder(interactivityImpl).getFeatureNavigation(navigationInfo, elementGroupSceneNode);
    }

    private ChordNavigationBuilder(InteractivityImpl interactivityImpl) {
        this.helper = new SceneHelper(interactivityImpl.getVisInstance());
    }

    FeatureNavigation getFeatureNavigation(NavigationInfo navigationInfo, ElementGroupSceneNode elementGroupSceneNode) {
        Object object;
        Object object2;
        Object object3;
        HashMap<Double, ChordGroupPart> hashMap2 = new HashMap<Double, ChordGroupPart>();
        HashMap<Double, ChordGroupPart> hashMap3 = new HashMap<Double, ChordGroupPart>();
        HashMap<String, FeaturePart> hashMap4 = new HashMap<String, FeaturePart>();
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        for (SceneNode object52 : elementGroupSceneNode.getChildren()) {
            object3 = ((SceneNodeImpl)object52).getA11y();
            if (object3 != null) {
                if (this.addToGroupMap(hashMap2, (SceneNodeImpl)object52, "chordFrom", (AccessibleInfo)object3) || this.addToGroupMap(hashMap3, (SceneNodeImpl)object52, "chordTo", (AccessibleInfo)object3)) continue;
                arrayList.add((SceneNodeImpl)object52);
                continue;
            }
            arrayList.add((SceneNodeImpl)object52);
        }
        Field field = this.helper.getToField(navigationInfo.getBaseId());
        Field field2 = this.helper.getFromField(navigationInfo.getBaseId());
        object3 = this.mapToCategory(field2, hashMap2);
        HashMap<String, ChordGroupPart> hashMap = this.mapToCategory(field, hashMap3);
        this.populateCombinedCategories(field, (HashMap<String, ChordGroupPart>)object3, hashMap);
        this.populateCombinedCategories(field2, hashMap, (HashMap<String, ChordGroupPart>)object3);
        for (SceneNodeImpl sceneNodeImpl : arrayList) {
            object2 = sceneNodeImpl.getId();
            if (!SceneHelper.isElementSymbol((String)object2)) continue;
            Shape shape = (Shape)sceneNodeImpl.getShape();
            object = shape.getRows();
            ChordGroupPart chordGroupPart = this.getGroup(hashMap3, hashMap, field, object[0]);
            ChordGroupPart chordGroupPart2 = this.getGroup(hashMap2, (HashMap<String, ChordGroupPart>)object3, field2, object[0]);
            Point point = this.getNearestPointToAnchor(shape, chordGroupPart2.getAnchor());
            Point point2 = this.getNearestPointToAnchor(shape, chordGroupPart.getAnchor());
            hashMap4.put((String)object2, new ChordPart((String)object2, point, point2, chordGroupPart2, chordGroupPart));
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<FeaturePart> arrayList3 = new ArrayList<FeaturePart>();
        for (ChordGroupPart chordGroupPart : hashMap2.values()) {
            chordGroupPart.sort();
            chordGroupPart.setListX(arrayList2);
            chordGroupPart.setListY(arrayList3);
            hashMap4.put(chordGroupPart.getId(), chordGroupPart);
        }
        for (ChordGroupPart chordGroupPart : hashMap3.values()) {
            chordGroupPart.sort();
            chordGroupPart.setListX(arrayList2);
            chordGroupPart.setListY(arrayList3);
            hashMap4.put(chordGroupPart.getId(), chordGroupPart);
        }
        BasicFactory.sortList(arrayList2, FeaturePartComparator.X);
        BasicFactory.sortList(arrayList3, FeaturePartComparator.Y);
        object2 = (FeaturePart)arrayList2.get(0);
        HashMap<String, FacetLocator> hashMap5 = FeatureNavigationBuilder.makeFacetMapForUnfacetedChart(navigationInfo, (FeaturePart)object2);
        object = new FeatureNavigation(hashMap4, navigationInfo, hashMap5, SceneIdUtil.baseId(((FeaturePart)object2).getId()));
        ((DirectionalNavigation)object).setSkipEquals(false);
        return object;
    }

    private Point getNearestPointToAnchor(Shape shape, Point point) {
        int n = shape.getType();
        if (1003 == n || 1002 == n) {
            PolyShape polyShape = (PolyShape)shape;
            double[] dArray = polyShape.getXArray();
            double[] dArray2 = polyShape.getYArray();
            double d = point.getX();
            double d2 = point.getY();
            double d3 = dArray[0];
            double d4 = dArray[0];
            double d5 = (d - d3) * (d - d3) + (d2 - d4) * (d2 - d4);
            for (int i = 1; i < dArray.length; ++i) {
                double d6 = (d - dArray[i]) * (d - dArray[i]) + (d2 - dArray2[i]) * (d2 - dArray2[i]);
                if (!(d6 < d5)) continue;
                d5 = d6;
                d3 = dArray[i];
                d4 = dArray2[i];
            }
            return new Point(d3, d4);
        }
        return shape.getCenter();
    }

    private void populateCombinedCategories(Field field, HashMap<String, ChordGroupPart> hashMap, HashMap<String, ChordGroupPart> hashMap2) {
        for (String string : field.categories) {
            ChordGroupPart chordGroupPart = hashMap2.get(string);
            if (chordGroupPart != null || (chordGroupPart = hashMap.get(string)) == null) continue;
            hashMap2.put(string, chordGroupPart);
        }
    }

    private HashMap<String, ChordGroupPart> mapToCategory(Field field, HashMap<Double, ChordGroupPart> hashMap) {
        HashMap<String, ChordGroupPart> hashMap2 = new HashMap<String, ChordGroupPart>();
        for (Double d : hashMap.keySet()) {
            int n = (int)Math.round(d);
            hashMap2.put(field.categories[n], hashMap.get(d));
        }
        return hashMap2;
    }

    private ChordGroupPart getGroup(HashMap<Double, ChordGroupPart> hashMap, HashMap<String, ChordGroupPart> hashMap2, Field field, int n) {
        double d = field.getRowValue(n);
        ChordGroupPart chordGroupPart = hashMap.get(d);
        return chordGroupPart == null ? hashMap2.get(this.toCat(field, d)) : chordGroupPart;
    }

    private String toCat(Field field, double d) {
        int n = (int)Math.round(d);
        return field.categories[n];
    }

    private boolean addToGroupMap(HashMap<Double, ChordGroupPart> hashMap, SceneNodeImpl sceneNodeImpl, String string, AccessibleInfo accessibleInfo) {
        Object object = accessibleInfo.getProperty(string);
        if (object == null) {
            return false;
        }
        Rect rect = sceneNodeImpl.getPhysicalBounds();
        ChordGroupPart chordGroupPart = new ChordGroupPart(sceneNodeImpl.getId(), rect.getCenter());
        hashMap.put((Double)object, chordGroupPart);
        return true;
    }
}

