/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.internal.navigation.ChordGroupPart;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ChordPart
extends FeaturePart {
    private final ChordGroupPart from;
    private final ChordGroupPart to;
    private final Point anchorTo;
    private boolean activeGroupIsFromGroup;

    protected ChordPart(String string, Point point, Point point2, ChordGroupPart chordGroupPart, ChordGroupPart chordGroupPart2) {
        super(string, point);
        this.from = chordGroupPart;
        this.to = chordGroupPart2;
        this.anchorTo = point2;
        chordGroupPart.addChord(this);
        chordGroupPart2.addChord(this);
    }

    void setActiveGroup(ChordGroupPart chordGroupPart) {
        this.activeGroupIsFromGroup = chordGroupPart == this.from;
    }

    void toggleActiveChordGroup() {
        this.activeGroupIsFromGroup = !this.activeGroupIsFromGroup;
    }

    boolean isFrom(ChordGroupPart chordGroupPart) {
        return chordGroupPart == this.from;
    }

    @Override
    FeaturePart toggleSelectedLink() {
        this.from.setPointOfRegard(this);
        this.to.setPointOfRegard(this);
        this.activeGroupIsFromGroup = !this.activeGroupIsFromGroup;
        return this.activeGroupIsFromGroup ? this.from : this.to;
    }

    @Override
    public Point getAnchor() {
        return this.activeGroupIsFromGroup ? super.getAnchor() : this.anchorTo;
    }

    @Override
    public ArrayList<FeaturePart> getListX() {
        return this.activeGroupIsFromGroup ? this.from.getChordListX() : this.to.getChordListX();
    }

    @Override
    public ArrayList<FeaturePart> getListY() {
        return this.activeGroupIsFromGroup ? this.from.getChordListY() : this.to.getChordListY();
    }

    @Override
    protected FeaturePart changePart(FeatureShift featureShift) {
        if (FeatureShift.PREVIOUS == featureShift) {
            return this.activeGroupIsFromGroup ? this.from : this.to;
        }
        return this;
    }
}

