/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.navigation.MoveWeight;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DirectionalNavigation {
    private static double BIG_DISTANCE = 9.0E8;
    protected final HashMap<String, FeaturePart> featurePartsMap;
    protected final NavigationInfo info;
    protected boolean skipEquals;

    public DirectionalNavigation(HashMap<String, FeaturePart> hashMap, NavigationInfo navigationInfo) {
        this.featurePartsMap = hashMap;
        this.info = navigationInfo;
        this.skipEquals = true;
    }

    protected String firstItem(String string) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        ArrayList<FeaturePart> arrayList = featurePart.getListX();
        return arrayList.get(0).getId();
    }

    protected String lastItem(String string) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        ArrayList<FeaturePart> arrayList = featurePart.getListX();
        int n = arrayList.size();
        return arrayList.get(n - 1).getId();
    }

    protected String nextLesserX(String string, MoveWeight moveWeight) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        double d = moveWeight == MoveWeight.HEAVY ? this.info.getHeavyWeight() : this.info.getNormalWeight();
        boolean bl = moveWeight == MoveWeight.HEAVY;
        featurePart = this.lesserX(d, bl, featurePart);
        if (this.info.getWrapX() && featurePart.getId().equals(string)) {
            ArrayList<FeaturePart> arrayList = featurePart.getListX();
            int n = arrayList.size() - 1;
            featurePart = arrayList.get(n);
        }
        return featurePart.getId();
    }

    protected String nextLesserY(String string, MoveWeight moveWeight) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        double d = moveWeight == MoveWeight.HEAVY ? this.info.getHeavyWeight() : this.info.getNormalWeight();
        boolean bl = moveWeight == MoveWeight.HEAVY;
        featurePart = this.lesserY(d, bl, featurePart);
        if (this.info.getWrapY() && featurePart.getId().equals(string)) {
            ArrayList<FeaturePart> arrayList = featurePart.getListY();
            int n = arrayList.size() - 1;
            featurePart = arrayList.get(n);
        }
        return featurePart.getId();
    }

    protected String nextGreaterX(String string, MoveWeight moveWeight) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        double d = moveWeight == MoveWeight.HEAVY ? this.info.getHeavyWeight() : this.info.getNormalWeight();
        boolean bl = moveWeight == MoveWeight.HEAVY;
        featurePart = this.greaterX(d, bl, featurePart);
        if (this.info.getWrapX() && featurePart.getId().equals(string)) {
            featurePart = featurePart.getListX().get(0);
        }
        return featurePart.getId();
    }

    protected String nextGreaterY(String string, MoveWeight moveWeight) {
        FeaturePart featurePart = this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        double d = moveWeight == MoveWeight.HEAVY ? this.info.getHeavyWeight() : this.info.getNormalWeight();
        boolean bl = moveWeight == MoveWeight.HEAVY;
        featurePart = this.greaterY(d, bl, featurePart);
        if (this.info.getWrapY() && featurePart.getId().equals(string)) {
            featurePart = featurePart.getListY().get(0);
        }
        return featurePart.getId();
    }

    private FeaturePart greaterY(double d, boolean bl, FeaturePart featurePart) {
        ArrayList<FeaturePart> arrayList = featurePart.getListY();
        int n = arrayList.indexOf(featurePart);
        int n2 = arrayList.size();
        FeaturePart featurePart2 = featurePart;
        double d2 = featurePart.getAnchor().getY();
        double d3 = featurePart.getAnchor().getX();
        double d4 = BIG_DISTANCE;
        for (int i = n + 1; i < n2; ++i) {
            double d5;
            FeaturePart featurePart3 = arrayList.get(i);
            double d6 = featurePart3.getAnchor().getY();
            if (d2 > d6 || this.skipEquals && d2 == d6) continue;
            double d7 = d6 - d2;
            double d8 = d7 * d7;
            if (d8 > d4) break;
            double d9 = featurePart3.getAnchor().getX() - d3;
            double d10 = d9 * d9;
            if (bl && d8 < d10 || !((d5 = d * d10 + d8) < d4)) continue;
            featurePart2 = featurePart3;
            d4 = d5;
        }
        return featurePart2;
    }

    private FeaturePart greaterX(double d, boolean bl, FeaturePart featurePart) {
        ArrayList<FeaturePart> arrayList = featurePart.getListX();
        int n = arrayList.indexOf(featurePart);
        int n2 = arrayList.size();
        FeaturePart featurePart2 = featurePart;
        double d2 = featurePart.getAnchor().getX();
        double d3 = BIG_DISTANCE;
        for (int i = n + 1; i < n2; ++i) {
            double d4;
            FeaturePart featurePart3 = arrayList.get(i);
            double d5 = featurePart3.getAnchor().getX();
            if (d2 > d5 || this.skipEquals && d2 == d5) continue;
            double d6 = d5 - d2;
            double d7 = d6 * d6;
            if (d7 > d3) break;
            double d8 = featurePart3.getAnchor().getY() - featurePart.getAnchor().getY();
            double d9 = d8 * d8;
            if (bl && d9 > d7 || !((d4 = d7 + d * d9) < d3)) continue;
            featurePart2 = featurePart3;
            d3 = d4;
        }
        return featurePart2;
    }

    private ArrayList<FeaturePart> refineList(ArrayList<FeaturePart> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).getId().startsWith("_")) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    private FeaturePart lesserX(double d, boolean bl, FeaturePart featurePart) {
        ArrayList<FeaturePart> arrayList = this.refineList(featurePart.getListX());
        int n = arrayList.indexOf(featurePart);
        FeaturePart featurePart2 = featurePart;
        double d2 = featurePart.getAnchor().getX();
        double d3 = featurePart.getAnchor().getY();
        double d4 = BIG_DISTANCE;
        for (int i = n - 1; i > -1; --i) {
            double d5;
            FeaturePart featurePart3 = arrayList.get(i);
            double d6 = featurePart3.getAnchor().getX();
            if (d2 < d6 || this.skipEquals && d2 == d6) continue;
            double d7 = d6 - d2;
            double d8 = d7 * d7;
            if (d8 > d4) break;
            double d9 = featurePart3.getAnchor().getY() - d3;
            double d10 = d9 * d9;
            if (bl && d10 > d8 || !((d5 = d8 + d * d10) < d4)) continue;
            featurePart2 = featurePart3;
            d4 = d5;
        }
        return featurePart2;
    }

    private FeaturePart lesserY(double d, boolean bl, FeaturePart featurePart) {
        ArrayList<FeaturePart> arrayList = this.refineList(featurePart.getListY());
        int n = arrayList.indexOf(featurePart);
        FeaturePart featurePart2 = featurePart;
        double d2 = featurePart.getAnchor().getY();
        double d3 = featurePart.getAnchor().getX();
        double d4 = BIG_DISTANCE;
        for (int i = n - 1; i > -1; --i) {
            double d5;
            FeaturePart featurePart3 = arrayList.get(i);
            double d6 = featurePart3.getAnchor().getY();
            if (d2 <= d6 || this.skipEquals && d2 == d6) continue;
            double d7 = d6 - d2;
            double d8 = d7 * d7;
            if (d8 > d4) break;
            double d9 = featurePart3.getAnchor().getX() - d3;
            double d10 = d9 * d9;
            if (bl && d8 < d10 || !((d5 = d * d10 + d8) < d4)) continue;
            featurePart2 = featurePart3;
            d4 = d5;
        }
        return featurePart2;
    }

    protected void setSkipEquals(boolean bl) {
        this.skipEquals = bl;
    }
}

