/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.navigation.ElementIdShifter;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartShiftBuilder;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ElementShiftBuilder
extends FeaturePartShiftBuilder {
    private Map<String, ElementIdShifter> shiftMap;

    protected ElementShiftBuilder(String string, List<String> list) {
        super(string);
        if (list.size() > 1) {
            this.shiftMap = this.makeShiftMap(string, list);
        } else {
            String string2 = list.isEmpty() ? null : list.get(0);
            this.orderedKeys = new String[]{string2};
        }
    }

    private Map<String, ElementIdShifter> makeShiftMap(String string, List<String> list) {
        HashMap<String, ElementIdShifter> hashMap = new HashMap<String, ElementIdShifter>();
        ArrayList<ElementIdShifter> arrayList = new ArrayList<ElementIdShifter>();
        for (String string2 : list) {
            ElementIdShifter elementIdShifter = ElementIdShifter.create(string, string2);
            hashMap.put(string2, elementIdShifter);
            arrayList.add(elementIdShifter);
        }
        BasicFactory.sortList(arrayList, (Comparator)arrayList.get(0));
        this.orderedKeys = new String[arrayList.size()];
        for (int i = 0; i < this.orderedKeys.length; ++i) {
            this.orderedKeys[i] = ((ElementIdShifter)arrayList.get(i)).getKey();
        }
        ElementIdShifter elementIdShifter = (ElementIdShifter)arrayList.get(0);
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            ElementIdShifter elementIdShifter2 = (ElementIdShifter)arrayList.get(i);
            elementIdShifter.setNext(elementIdShifter2);
            elementIdShifter = elementIdShifter2;
        }
        elementIdShifter.setNext((ElementIdShifter)arrayList.get(0));
        return hashMap;
    }

    @Override
    protected void addShifts(HashMap<String, FeaturePart> hashMap, HashMap<String, ArrayList<SceneNode>> hashMap2) {
        if (this.shiftMap == null) {
            return;
        }
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        for (String string : hashMap.keySet()) {
            if (hashMap3.get(string) != null) continue;
            this.addShiftsOnSiblings(string, hashMap, hashMap3);
        }
    }

    private void addShiftsOnSiblings(String string, HashMap<String, FeaturePart> hashMap, HashMap<String, String> hashMap2) {
        FeaturePart featurePart;
        hashMap2.put(string, string);
        FeaturePart featurePart2 = featurePart = hashMap.get(string);
        String string2 = this.nextPartId(string);
        while (!string.equals(string2)) {
            FeaturePart featurePart3 = hashMap.get(string2);
            hashMap2.put(string2, string2);
            if (featurePart3 != null) {
                featurePart3.setPrevious(featurePart2);
                featurePart2.setNext(featurePart3);
                featurePart2 = featurePart3;
            }
            string2 = this.nextPartId(string2);
        }
        if (featurePart2 != featurePart) {
            featurePart2.setNext(featurePart);
            featurePart.setPrevious(featurePart2);
        }
    }

    private String nextPartId(String string) {
        String string2 = ElementIdShifter.makeKey(this.baseIdLength, string);
        ElementIdShifter elementIdShifter = this.shiftMap.get(string2);
        return elementIdShifter.getNextId(string);
    }
}

