/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.DirectionalNavigation;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.navigation.MoveWeight;
import com.ibm.vis.interaction.navigation.NavigationDirection;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetNavigation
extends DirectionalNavigation {
    private HashMap<String, FacetLocator> facets;
    private boolean isUnfaceted;
    private String pointOfRegardId;

    public FacetNavigation(HashMap<String, FeaturePart> hashMap, NavigationInfo navigationInfo, HashMap<String, FacetLocator> hashMap2, String string) {
        super(hashMap, navigationInfo);
        this.facets = hashMap2;
        this.isUnfaceted = hashMap2.size() < 2;
        this.pointOfRegardId = string;
    }

    protected FacetLocator facetForPointOfRegard() {
        return this.facets.get(this.pointOfRegardId);
    }

    protected String moveFacet(String string, NavigationDirection navigationDirection, MoveWeight moveWeight, FeaturePart featurePart) {
        if (this.isUnfaceted || navigationDirection == null) {
            return string;
        }
        String string2 = SceneIdUtil.baseId(string);
        FacetLocator facetLocator = this.facets.get(string2);
        if (facetLocator != null) {
            facetLocator.setPointOfRegard(featurePart);
        }
        String string3 = null;
        if (navigationDirection == NavigationDirection.GREATER_X) {
            string3 = this.nextGreaterX(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_X) {
            string3 = this.nextLesserX(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_Y) {
            string3 = this.nextLesserY(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.GREATER_Y) {
            string3 = this.nextGreaterY(string2, moveWeight);
        }
        FacetLocator facetLocator2 = this.facets.get(string3);
        return facetLocator2.pointOfRegard().getId();
    }

    protected FacetLocator getFacet(String string) {
        return this.facets.get(string);
    }

    protected void setPointOfRegard(FeaturePart featurePart) {
        if (featurePart == null) {
            return;
        }
        String string = SceneIdUtil.baseId(featurePart.getId());
        FacetLocator facetLocator = this.facets.get(string);
        if (facetLocator != null) {
            facetLocator.setPointOfRegard(featurePart);
            this.pointOfRegardId = string;
        }
    }

    protected HashMap<String, FacetLocator> getFacets() {
        return this.facets;
    }

    protected String getPointOfRegardString() {
        return this.pointOfRegardId;
    }
}

