/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetNavigationBuilder {
    private final HashMap<String, FacetLocator> facetMap;
    private final HashMap<String, FeaturePart> partsMap;
    private final ArrayList<FeaturePart> xList;
    private final ArrayList<FeaturePart> yList;
    private final NavigationInfo info;

    FacetNavigationBuilder(NavigationInfo navigationInfo) {
        this.info = navigationInfo;
        this.facetMap = new HashMap();
        this.partsMap = new HashMap();
        this.xList = new ArrayList();
        this.yList = new ArrayList();
    }

    void addFacet(FacetLocator facetLocator) {
        if (facetLocator == null) {
            return;
        }
        FeaturePart featurePart = facetLocator.getLocator();
        featurePart.setListX(this.xList);
        featurePart.setListY(this.yList);
        String string = featurePart.getId();
        this.facetMap.put(string, facetLocator);
    }

    ArrayList<SceneNode> getFacetItems(SceneNode sceneNode, String string, boolean bl, FeatureNavigationBuilder featureNavigationBuilder) {
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            ArrayList<SceneNode> arrayList2;
            String string2 = SceneIdUtil.getBaseIdForSceneNode(sceneNode2);
            if (string.equals(string2 = SceneIdUtil.stripFacetIndexFromId(string2))) {
                if (bl && !featureNavigationBuilder.isFirstChildVisible(sceneNode2)) continue;
                arrayList.add(sceneNode2);
                continue;
            }
            if (SceneNodeType.FACET != sceneNode2.getType() || (arrayList2 = this.getFacetItems(sceneNode2, string, false, featureNavigationBuilder)) == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    FeatureNavigation makeNavigation() {
        if (this.xList.isEmpty()) {
            return null;
        }
        BasicFactory.sortList(this.xList, FeaturePartComparator.X);
        BasicFactory.sortList(this.yList, FeaturePartComparator.Y);
        FeaturePart featurePart = this.xList.get(0);
        String string = featurePart.getId();
        return new FeatureNavigation(this.partsMap, this.info, this.facetMap, string);
    }

    public final HashMap<String, FeaturePart> getPartsMap() {
        return this.partsMap;
    }
}

