/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.navigation.DirectionalNavigation;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FacetNavigation;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.navigation.FeatureShift;
import com.ibm.vis.interaction.navigation.MoveWeight;
import com.ibm.vis.interaction.navigation.NavigationDirection;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FeatureNavigation
extends DirectionalNavigation {
    protected final FacetNavigation facetNavigation;

    public FeatureNavigation(HashMap<String, FeaturePart> hashMap, NavigationInfo navigationInfo, HashMap<String, FacetLocator> hashMap2, String string) {
        super(hashMap, navigationInfo);
        this.facetNavigation = this.buildFacetNavigation(hashMap2, navigationInfo, string);
    }

    private FacetNavigation buildFacetNavigation(HashMap<String, FacetLocator> hashMap, NavigationInfo navigationInfo, String string) {
        HashMap<String, FeaturePart> hashMap2 = new HashMap<String, FeaturePart>();
        for (String string2 : hashMap.keySet()) {
            FacetLocator facetLocator = hashMap.get(string2);
            FeaturePart featurePart = facetLocator.getLocator();
            hashMap2.put(featurePart.getId(), featurePart);
        }
        return new FacetNavigation(hashMap2, navigationInfo, hashMap, string);
    }

    protected String pointOfRegard() {
        FacetLocator facetLocator = this.facetNavigation.facetForPointOfRegard();
        return facetLocator.pointOfRegard().getId();
    }

    protected void setPointOfRegard(String string) {
        FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(string);
        this.facetNavigation.setPointOfRegard(featurePart);
    }

    protected String moveFacet(String string, NavigationDirection navigationDirection, MoveWeight moveWeight) {
        FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(string);
        return this.facetNavigation.moveFacet(string, navigationDirection, moveWeight, featurePart);
    }

    protected String getPointOfRegardForFacet(String string) {
        FacetLocator facetLocator = this.facetNavigation.getFacet(string);
        return facetLocator == null ? null : facetLocator.pointOfRegard().getId();
    }

    protected String partMove(String string, FeatureShift featureShift) {
        FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        return featurePart.changePart(featureShift).getId();
    }

    protected boolean doesLinkMove() {
        return false;
    }

    protected NavigationInfo getInfo() {
        return this.info;
    }

    protected final HashMap<String, FeaturePart> getFeaturePartMap() {
        return this.featurePartsMap;
    }

    protected String toggleLink(String string) {
        FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(string);
        if (featurePart == null) {
            return string;
        }
        return featurePart.toggleSelectedLink().getId();
    }
}

