/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.navigation.AxisShiftBuilder;
import com.ibm.vis.interaction.internal.navigation.ChordNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.ElementIdShifter;
import com.ibm.vis.interaction.internal.navigation.ElementShiftBuilder;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FacetNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.FeaturePartShiftBuilder;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.GroupPart;
import com.ibm.vis.interaction.internal.navigation.LegendShiftBuilder;
import com.ibm.vis.interaction.internal.navigation.ListNavigation;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.interaction.internal.navigation.TitleShiftBuilder;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FeatureNavigationBuilder {
    private static final String B = "B";
    private static final String N = "N";
    private static final String TEXT = "text";
    private final String CLIP = "clip";
    private final String X = "x";
    private final String Y = "y";
    private final String TRANSFORM = "transform";
    private InteractivityImpl interactivity;

    public FeatureNavigationBuilder(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
    }

    public FeatureNavigation getFeatureNavigation(NavigationInfo navigationInfo, SceneTree sceneTree) {
        CompositeSceneNode compositeSceneNode = sceneTree.getRoot();
        if (navigationInfo.isFaceted()) {
            if (navigationInfo.getType() == FeatureType.ELEMENT) {
                return this.makeFacetedElementNavigation(navigationInfo, compositeSceneNode);
            }
            if (navigationInfo.getType() == FeatureType.AXIS) {
                return this.makeFacetedAxisNavigation(navigationInfo, compositeSceneNode);
            }
            if (navigationInfo.getType() == FeatureType.GRIDLINE) {
                return this.makeFacetedGridlineNavigation(navigationInfo, compositeSceneNode);
            }
            return null;
        }
        if (navigationInfo.getType() == FeatureType.ELEMENT) {
            return this.makeElementNavigation(navigationInfo, compositeSceneNode);
        }
        if (navigationInfo.getType() == FeatureType.AXIS || navigationInfo.getType() == FeatureType.LEGEND || navigationInfo.getType() == FeatureType.TITLE) {
            return this.makeFeatureNavigation(navigationInfo, compositeSceneNode);
        }
        if (navigationInfo.getType() == FeatureType.GRIDLINE) {
            return this.makeUnfacetedGridlineNavigation(navigationInfo, compositeSceneNode);
        }
        return null;
    }

    protected FeatureNavigation makeFacetedElementNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        List<SceneNode> list = compositeSceneNode.getChildren();
        FacetNavigationBuilder facetNavigationBuilder = new FacetNavigationBuilder(navigationInfo);
        HashMap<String, FeaturePart> hashMap = facetNavigationBuilder.getPartsMap();
        String string = navigationInfo.getBaseId();
        for (SceneNode sceneNode : list) {
            ArrayList<SceneNode> arrayList;
            if (FeatureType.FACET != SceneHelper.getFeatureType(sceneNode) || (arrayList = facetNavigationBuilder.getFacetItems(sceneNode, string, true, this)) == null) continue;
            for (SceneNode sceneNode2 : arrayList) {
                FacetLocator facetLocator = this.makeElementFeatureFacet(navigationInfo, sceneNode2, hashMap, sceneNode);
                facetNavigationBuilder.addFacet(facetLocator);
            }
        }
        return facetNavigationBuilder.makeNavigation();
    }

    private FacetLocator makeElementFeatureFacet(NavigationInfo navigationInfo, SceneNode sceneNode, HashMap<String, FeaturePart> hashMap, SceneNode sceneNode2) {
        Object object;
        Object object2;
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        FeaturePart featurePart = null;
        if (this.elementHasGroups(sceneNode)) {
            featurePart = this.createElementBranchHierarchy(sceneNode, navigationInfo, null, hashMap);
        } else {
            object2 = new HashMap<String, ArrayList<SceneNode>>();
            this.addToPartKeyMap(navigationInfo, (HashMap<String, ArrayList<SceneNode>>)object2, sceneNode, string);
            object = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, FeaturePart> hashMap2 = new HashMap<String, FeaturePart>();
            for (String string2 : ((HashMap)object2).keySet()) {
                ArrayList<FeaturePart> arrayList2 = this.addToMap((HashMap<String, ArrayList<SceneNode>>)object2, string2, hashMap2, false, sceneNode);
                ((HashMap)object).put(string2, arrayList2);
                arrayList.add(string2);
            }
            ElementShiftBuilder elementShiftBuilder = new ElementShiftBuilder(string, arrayList);
            ((FeaturePartShiftBuilder)elementShiftBuilder).addShifts(hashMap2, (HashMap<String, ArrayList<SceneNode>>)object2);
            hashMap.putAll(hashMap2);
            featurePart = elementShiftBuilder.getFirst((HashMap<String, ArrayList<FeaturePart>>)object);
        }
        object2 = new Point(0.0, 0.0);
        object2 = this.addTransform(sceneNode, (Point)object2);
        object2 = this.addTransform(sceneNode2, (Point)object2);
        object = new FeaturePart(string, (Point)object2);
        return new FacetLocator(featurePart, (FeaturePart)object);
    }

    protected FeatureNavigation makeFacetedAxisNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        FacetNavigationBuilder facetNavigationBuilder = new FacetNavigationBuilder(navigationInfo);
        String string = navigationInfo.getBaseId();
        for (SceneNode sceneNode : compositeSceneNode.getChildren()) {
            ArrayList<SceneNode> arrayList;
            if (FeatureType.FACET != SceneHelper.getFeatureType(sceneNode) || (arrayList = facetNavigationBuilder.getFacetItems(sceneNode, string, false, this)) == null) continue;
            for (SceneNode sceneNode2 : arrayList) {
                HashMap<String, FeaturePart> hashMap = new HashMap<String, FeaturePart>();
                FacetLocator facetLocator = this.makeAxisFeatureFacet(navigationInfo, sceneNode2, hashMap, sceneNode);
                facetNavigationBuilder.getPartsMap().putAll(hashMap);
                facetNavigationBuilder.addFacet(facetLocator);
            }
        }
        return facetNavigationBuilder.makeNavigation();
    }

    protected FeatureNavigation makeFacetedGridlineNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        FacetNavigationBuilder facetNavigationBuilder = new FacetNavigationBuilder(navigationInfo);
        HashMap<String, FeaturePart> hashMap = facetNavigationBuilder.getPartsMap();
        String string = navigationInfo.getBaseId();
        for (SceneNode sceneNode : compositeSceneNode.getChildren()) {
            ArrayList<SceneNode> arrayList;
            if (FeatureType.FACET != SceneHelper.getFeatureType(sceneNode) || (arrayList = facetNavigationBuilder.getFacetItems(sceneNode, string, false, this)) == null) continue;
            for (SceneNode sceneNode2 : arrayList) {
                FeaturePart featurePart = this.addBasicFacet(sceneNode2, hashMap);
                Point point = this.addTransform(sceneNode, new Point(0.0, 0.0));
                String string2 = SceneIdUtil.getBaseIdForSceneNode(sceneNode2);
                FeaturePart featurePart2 = new FeaturePart(string2, point);
                FacetLocator facetLocator = new FacetLocator(featurePart, featurePart2);
                facetNavigationBuilder.addFacet(facetLocator);
            }
        }
        return facetNavigationBuilder.makeNavigation();
    }

    protected FeatureNavigation makeUnfacetedGridlineNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        String string = navigationInfo.getBaseId();
        for (SceneNode sceneNode : compositeSceneNode.getChildren()) {
            if (!this.matchesBaseId(sceneNode, string)) continue;
            return this.makeGridlineNavigation(sceneNode, navigationInfo);
        }
        return null;
    }

    protected FeatureNavigation makeGridlineNavigation(SceneNode sceneNode, NavigationInfo navigationInfo) {
        HashMap<String, FeaturePart> hashMap = new HashMap<String, FeaturePart>();
        FeaturePart featurePart = this.addBasicFacet(sceneNode, hashMap);
        HashMap<String, FacetLocator> hashMap2 = FeatureNavigationBuilder.makeFacetMapForUnfacetedChart(navigationInfo, featurePart);
        String string = featurePart.getId();
        string = SceneIdUtil.baseId(string);
        return new FeatureNavigation(hashMap, navigationInfo, hashMap2, string);
    }

    private FacetLocator makeAxisFeatureFacet(NavigationInfo navigationInfo, SceneNode sceneNode, HashMap<String, FeaturePart> hashMap, SceneNode sceneNode2) {
        Object object;
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        HashMap<String, ArrayList<SceneNode>> hashMap2 = new HashMap<String, ArrayList<SceneNode>>();
        this.addToPartKeyMap(navigationInfo, hashMap2, sceneNode, string);
        if (hashMap2.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<FeaturePart>> hashMap3 = new HashMap<String, ArrayList<FeaturePart>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object22 : hashMap2.keySet()) {
            object = this.addToMap(hashMap2, object22, hashMap, false, sceneNode);
            hashMap3.put(object22, (ArrayList<FeaturePart>)object);
            arrayList.add(object22);
        }
        AxisShiftBuilder axisShiftBuilder = new AxisShiftBuilder(string, arrayList);
        ((FeaturePartShiftBuilder)axisShiftBuilder).addShifts(hashMap, hashMap2);
        FeaturePart featurePart = axisShiftBuilder.getFirst(hashMap3);
        object = this.addTransform(sceneNode, new Point(0.0, 0.0));
        object = this.addTransform(sceneNode2, (Point)object);
        FeaturePart featurePart2 = new FeaturePart(string, (Point)object);
        return new FacetLocator(featurePart, featurePart2);
    }

    private FeaturePart addBasicFacet(SceneNode sceneNode, HashMap<String, FeaturePart> hashMap) {
        ArrayList<FeaturePart> arrayList = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
        List<SceneNode> list = sceneNode.getChildren();
        FeaturePart featurePart = null;
        for (SceneNode sceneNode2 : list) {
            Point point = SceneHelper.getCenter(sceneNode2);
            String string = sceneNode2.getId();
            if (point == null || string == null || ((SceneNodeImpl)sceneNode2).isEffect()) continue;
            FeaturePart featurePart2 = new FeaturePart(string, point);
            hashMap.put(string, featurePart2);
            featurePart2.setListX(arrayList);
            featurePart2.setListY(arrayList2);
            if (featurePart != null) continue;
            featurePart = featurePart2;
        }
        BasicFactory.sortList(arrayList, FeaturePartComparator.X);
        BasicFactory.sortList(arrayList2, FeaturePartComparator.Y);
        return featurePart;
    }

    private FeatureNavigation makeFeatureNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        String string = navigationInfo.getBaseId();
        for (SceneNode sceneNode : compositeSceneNode.getChildren()) {
            if (!this.matchesBaseId(sceneNode, string)) continue;
            return this.makeUnfacetedNavigation(sceneNode, navigationInfo);
        }
        return null;
    }

    protected FeatureNavigation makeUnfacetedNavigation(SceneNode sceneNode, NavigationInfo navigationInfo) {
        HashMap<String, ArrayList<SceneNode>> hashMap = new HashMap<String, ArrayList<SceneNode>>();
        this.addToPartKeyMap(navigationInfo, hashMap, sceneNode, navigationInfo.getBaseId());
        if (hashMap.size() < 1) {
            return null;
        }
        return this.makeSimpleNavigation(hashMap, navigationInfo, sceneNode);
    }

    protected FeatureNavigation makeElementNavigation(NavigationInfo navigationInfo, CompositeSceneNode compositeSceneNode) {
        Object object;
        Object object22;
        HashMap<String, ArrayList<SceneNode>> hashMap = new HashMap<String, ArrayList<SceneNode>>();
        for (SceneNode object32 : compositeSceneNode.getChildren()) {
            if (!this.matchesBaseId(object32, navigationInfo.getBaseId()) || !this.isFirstChildVisible(object32)) continue;
            if (navigationInfo.isChordLayout()) {
                return ChordNavigationBuilder.getChordNavigation(this.interactivity, navigationInfo, (ElementGroupSceneNode)object32);
            }
            if (this.elementHasGroups(object32)) {
                HashMap<String, FeaturePart> arrayList = new HashMap<String, FeaturePart>();
                GroupPart elementShiftBuilder = this.createElementBranchHierarchy(object32, navigationInfo, null, arrayList);
                String object22 = SceneIdUtil.baseId(elementShiftBuilder.getId());
                HashMap<String, FacetLocator> object3 = FeatureNavigationBuilder.makeFacetMapForUnfacetedChart(navigationInfo, elementShiftBuilder);
                return new FeatureNavigation(arrayList, navigationInfo, object3, object22);
            }
            this.addToPartKeyMap(navigationInfo, hashMap, object32, navigationInfo.getBaseId());
        }
        HashMap hashMap4 = new HashMap();
        HashMap<String, ArrayList<FeaturePart>> hashMap2 = new HashMap<String, ArrayList<FeaturePart>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object22 : hashMap.keySet()) {
            object = this.addToMap(hashMap, (String)object22, hashMap4, false, null);
            hashMap2.put((String)object22, (ArrayList<FeaturePart>)object);
            arrayList.add((String)object22);
        }
        ElementShiftBuilder elementShiftBuilder = new ElementShiftBuilder(navigationInfo.getBaseId(), arrayList);
        ((FeaturePartShiftBuilder)elementShiftBuilder).addShifts(hashMap4, hashMap);
        object22 = elementShiftBuilder.getFirst(hashMap2);
        object = ((FeaturePart)object22).getId();
        object = SceneIdUtil.baseId((String)object);
        HashMap<String, FacetLocator> hashMap3 = FeatureNavigationBuilder.makeFacetMapForUnfacetedChart(navigationInfo, (FeaturePart)object22);
        return new FeatureNavigation(hashMap4, navigationInfo, hashMap3, (String)object);
    }

    private void addElementBranchLeaves(SceneNode sceneNode, NavigationInfo navigationInfo, GroupPart groupPart, HashMap<String, FeaturePart> hashMap) {
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        int n = string.length();
        HashMap<String, FeaturePart> hashMap2 = new HashMap<String, FeaturePart>();
        HashMap<String, ArrayList<FeaturePart>> hashMap3 = new HashMap<String, ArrayList<FeaturePart>>();
        this.addElementShapeParts(sceneNode, navigationInfo, groupPart, hashMap, n, hashMap2, hashMap3);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : hashMap3.keySet()) {
            arrayList.add(string2);
            ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
            ArrayList<FeaturePart> arrayList3 = new ArrayList<FeaturePart>();
            ArrayList<FeaturePart> arrayList4 = hashMap3.get(string2);
            for (FeaturePart featurePart : arrayList4) {
                featurePart.setListX(arrayList2);
                featurePart.setListY(arrayList3);
            }
            BasicFactory.sortList(arrayList2, FeaturePartComparator.X);
            BasicFactory.sortList(arrayList3, FeaturePartComparator.Y);
        }
        ElementShiftBuilder elementShiftBuilder = new ElementShiftBuilder(string, arrayList);
        elementShiftBuilder.addShifts(hashMap2, null);
    }

    private void addElementShapeParts(SceneNode sceneNode, NavigationInfo navigationInfo, GroupPart groupPart, HashMap<String, FeaturePart> hashMap, int n, HashMap<String, FeaturePart> hashMap2, HashMap<String, ArrayList<FeaturePart>> hashMap3) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            GroupPart groupPart2 = this.makeGroupPart(sceneNode2, navigationInfo, groupPart);
            hashMap.put(groupPart2.getId(), groupPart2);
            String string = ElementIdShifter.makeKey(n, groupPart2.getId());
            if (string == null) continue;
            ArrayList<FeaturePart> arrayList = hashMap3.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap3.put(string, arrayList);
            }
            arrayList.add(groupPart2);
            hashMap2.put(groupPart2.getId(), groupPart2);
            this.addElementShapeParts(sceneNode2, navigationInfo, groupPart, hashMap, n, hashMap2, hashMap3);
        }
    }

    private GroupPart createElementBranchHierarchy(SceneNode sceneNode, NavigationInfo navigationInfo, GroupPart groupPart, HashMap<String, FeaturePart> hashMap) {
        List<SceneNode> list = sceneNode.getChildren();
        String string = null;
        if (list.size() > 0) {
            string = list.get(0).getId();
        }
        ArrayList<FeaturePart> arrayList = null;
        if (string == null || SceneIdUtil.isElementGroup(string)) {
            arrayList = this.makeElementGroupBranches(navigationInfo, groupPart, hashMap, list);
        } else {
            this.addElementBranchLeaves(sceneNode, navigationInfo, groupPart, hashMap);
        }
        return groupPart == null && arrayList != null ? (GroupPart)arrayList.get(0) : null;
    }

    private ArrayList<FeaturePart> makeElementGroupBranches(NavigationInfo navigationInfo, GroupPart groupPart, HashMap<String, FeaturePart> hashMap, List<SceneNode> list) {
        ArrayList<FeaturePart> arrayList = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
        for (SceneNode sceneNode : list) {
            GroupPart groupPart2 = this.makeGroupPart(sceneNode, navigationInfo, groupPart);
            hashMap.put(groupPart2.getId(), groupPart2);
            groupPart2.setListX(arrayList);
            groupPart2.setListY(arrayList2);
            this.createElementBranchHierarchy(sceneNode, navigationInfo, groupPart2, hashMap);
        }
        BasicFactory.sortList(arrayList, FeaturePartComparator.X);
        BasicFactory.sortList(arrayList2, FeaturePartComparator.Y);
        return arrayList;
    }

    private GroupPart makeGroupPart(SceneNode sceneNode, NavigationInfo navigationInfo, GroupPart groupPart) {
        Rect rect = sceneNode.getPhysicalBounds();
        if (rect == null) {
            return null;
        }
        return new GroupPart(sceneNode.getId(), rect.getCenter(), groupPart);
    }

    private boolean elementHasGroups(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list.isEmpty()) {
            return false;
        }
        String string = list.get(0).getId();
        return string != null && SceneIdUtil.isElementGroup(string);
    }

    private FeatureNavigation makeSimpleNavigation(HashMap<String, ArrayList<SceneNode>> hashMap, NavigationInfo navigationInfo, SceneNode sceneNode) {
        ArrayList<FeaturePart> arrayList;
        HashMap<String, FeaturePart> hashMap2 = new HashMap<String, FeaturePart>();
        HashMap<String, ArrayList<FeaturePart>> hashMap3 = new HashMap<String, ArrayList<FeaturePart>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = navigationInfo.getType() == FeatureType.LEGEND;
        for (String object2 : hashMap.keySet()) {
            arrayList = this.addToMap(hashMap, object2, hashMap2, bl, sceneNode);
            hashMap3.put(object2, arrayList);
            arrayList2.add(object2);
        }
        Object object3 = null;
        if (navigationInfo.getType() == FeatureType.ELEMENT) {
            object3 = new ElementShiftBuilder(navigationInfo.getBaseId(), arrayList2);
        } else if (navigationInfo.getType() == FeatureType.AXIS) {
            object3 = new AxisShiftBuilder(navigationInfo.getBaseId(), arrayList2);
        } else if (bl) {
            object3 = new LegendShiftBuilder(navigationInfo.getBaseId());
        } else if (navigationInfo.getType() == FeatureType.TITLE) {
            object3 = new TitleShiftBuilder(navigationInfo.getBaseId());
        }
        ((FeaturePartShiftBuilder)object3).addShifts(hashMap2, hashMap);
        FeaturePart featurePart = ((FeaturePartShiftBuilder)object3).getFirst(hashMap3);
        arrayList = bl ? ((LegendShiftBuilder)object3).getLast() : null;
        HashMap<String, FacetLocator> hashMap4 = FeatureNavigationBuilder.makeFacetMapForUnfacetedChart(navigationInfo, featurePart);
        String string = featurePart.getId();
        String string2 = SceneIdUtil.baseId(string);
        if (bl) {
            return new ListNavigation(hashMap2, navigationInfo, hashMap4, string2, string, ((FeaturePart)((Object)arrayList)).getId());
        }
        return new FeatureNavigation(hashMap2, navigationInfo, hashMap4, string2);
    }

    protected static HashMap<String, FacetLocator> makeFacetMapForUnfacetedChart(NavigationInfo navigationInfo, FeaturePart featurePart) {
        FacetLocator facetLocator = new FacetLocator(featurePart, featurePart);
        HashMap<String, FacetLocator> hashMap = new HashMap<String, FacetLocator>();
        hashMap.put(navigationInfo.getBaseId(), facetLocator);
        return hashMap;
    }

    private ArrayList<FeaturePart> addToMap(HashMap<String, ArrayList<SceneNode>> hashMap, String string, HashMap<String, FeaturePart> hashMap2, boolean bl, Object object) {
        ArrayList<SceneNode> arrayList = hashMap.get(string);
        ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList3 = new ArrayList<FeaturePart>();
        for (SceneNode sceneNode : arrayList) {
            Point point = SceneHelper.getCenter(sceneNode);
            String string2 = sceneNode.getId();
            if (point == null && (!bl || (point = SceneHelper.getCenterFromChildren(sceneNode)) == null)) continue;
            FeaturePart featurePart = new FeaturePart(string2, point);
            featurePart.setListX(arrayList2);
            featurePart.setListY(arrayList3);
            hashMap2.put(string2, featurePart);
        }
        BasicFactory.sortList(arrayList2, FeaturePartComparator.X);
        BasicFactory.sortList(arrayList3, FeaturePartComparator.Y);
        return arrayList2;
    }

    private Point addTransform(SceneNode sceneNode, Point point) {
        TransformInfo transformInfo = sceneNode.getTransform();
        if (transformInfo == null || transformInfo.getAffine() == null) {
            return new Point(0.0, 0.0);
        }
        return transformInfo.getAffine().transformPoint(point);
    }

    protected void addToPartKeyMap(NavigationInfo navigationInfo, HashMap<String, ArrayList<SceneNode>> hashMap, SceneNode sceneNode, String string) {
        Object object;
        String string2 = sceneNode.getId();
        if (string2 != null && !((SceneNodeImpl)sceneNode).isEffect() && (object = this.getPartKey(string2, string, navigationInfo)) != null) {
            this.addToMapList(hashMap, sceneNode, (String)object);
        }
        if ((object = sceneNode.getChildren()) != null && !object.isEmpty()) {
            boolean bl;
            boolean bl2 = navigationInfo.getType() == FeatureType.LEGEND && SceneHelper.getFeatureType(sceneNode) == FeatureType.LEGEND;
            boolean bl3 = bl = navigationInfo.getType() == FeatureType.TITLE;
            if (string2 == null || bl2 || bl || SceneNodeType.SCHEMA == sceneNode.getType()) {
                this.addChildPartKeys(navigationInfo, hashMap, string, (List<SceneNode>)object);
            }
        }
    }

    private String getPartKey(String string, String string2, NavigationInfo navigationInfo) {
        FeatureType featureType = navigationInfo.getType();
        if (FeatureType.ELEMENT == featureType) {
            return ElementIdShifter.makeKey(string2.length(), string);
        }
        if (FeatureType.AXIS == featureType) {
            return AxisShiftBuilder.makeKey(string);
        }
        if (FeatureType.TITLE == featureType) {
            return FeaturePartShiftBuilder.makeTitleKey(string);
        }
        if (FeatureType.GRIDLINE == featureType) {
            return "G";
        }
        if (FeatureType.LEGEND == featureType) {
            return LegendShiftBuilder.makeKey(string);
        }
        return null;
    }

    private void addChildPartKeys(NavigationInfo navigationInfo, HashMap<String, ArrayList<SceneNode>> hashMap, String string, List<SceneNode> list) {
        for (SceneNode sceneNode : list) {
            this.addToPartKeyMap(navigationInfo, hashMap, sceneNode, string);
        }
    }

    protected void addToMapList(HashMap<String, ArrayList<SceneNode>> hashMap, SceneNode sceneNode, String string) {
        if (string.length() == 0) {
            return;
        }
        ArrayList<SceneNode> arrayList = hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(string, arrayList);
        }
        arrayList.add(sceneNode);
    }

    protected boolean isFirstChildVisible(SceneNode sceneNode) {
        Rect rect = sceneNode.getClipBounds();
        if (rect == null) {
            return true;
        }
        List<SceneNode> list = sceneNode.getChildren();
        if (list.isEmpty()) {
            return false;
        }
        SceneNode sceneNode2 = list.get(0);
        ShapeInfo shapeInfo = sceneNode2.getShape();
        if (shapeInfo == null) {
            return this.isFirstChildVisible(sceneNode2);
        }
        Rect rect2 = shapeInfo.getNodeBounds();
        if (rect2 == null) {
            return true;
        }
        return rect.containsRect(rect2) || rect.intersectsRect(rect2);
    }

    private boolean matchesBaseId(SceneNode sceneNode, String string) {
        String string2 = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        return string.equals(string2);
    }
}

