/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.GraphNavigation;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.OrganizerMap;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.interaction.internal.navigation.SceneMap;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.TransformSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FeatureOrganizer {
    private static final String EDGE = "edge";
    private static final String CHORD = "chord";
    private static final String INTERVAL = "interval";
    private static final String POLAR = "polar";
    private static final String GRIDLINE = "gridline";
    public static final String T = "T";
    protected HashMap<String, NavigationInfo> elementTemplates;
    protected NavigationInfo standardElement;
    protected HashMap<FeatureType, NavigationInfo> typeTemplates;
    protected HashMap<String, NavigationInfo> circularTemplates;
    protected FeatureType[] orderedTypes;

    public FeatureOrganizer() {
        this.populateTemplates();
        this.orderedTypes = new FeatureType[]{FeatureType.TITLE, FeatureType.AXIS, FeatureType.LEGEND, FeatureType.ELEMENT, FeatureType.GRIDLINE};
    }

    public SceneMap createSceneMap(SceneTree sceneTree) {
        OrganizerMap organizerMap = new OrganizerMap();
        GraphNavigation graphNavigation = SceneHelper.makeGraphNavigationAndCoordinateMap(sceneTree.getRoot(), organizerMap.getCoordMap(), true, this.standardElement);
        this.gatherFeatures(sceneTree.getRoot(), organizerMap);
        graphNavigation.removeNonNavigableGrammars(organizerMap);
        HashMap<String, NavigationInfo> hashMap = new HashMap<String, NavigationInfo>();
        NavigationInfo navigationInfo = null;
        if (graphNavigation.isSingleGraph()) {
            navigationInfo = this.populateMapAndBuildChainOfFeatures(hashMap, organizerMap);
        } else {
            HashMap<String, OrganizerMap> hashMap2 = organizerMap.splitByGraph();
            NavigationInfo navigationInfo2 = null;
            HashMap<String, NavigationInfo> hashMap3 = new HashMap<String, NavigationInfo>();
            for (String string : graphNavigation.getKeys()) {
                OrganizerMap organizerMap2 = hashMap2.get(string);
                navigationInfo2 = this.populateMapAndBuildChainOfFeatures(hashMap, organizerMap2);
                hashMap3.put(string, navigationInfo2);
                if (navigationInfo != null) continue;
                navigationInfo = navigationInfo2;
            }
            graphNavigation.setStartingFeatureMap(hashMap3);
            hashMap.putAll(hashMap3);
        }
        return new SceneMap(hashMap, navigationInfo, graphNavigation);
    }

    private NavigationInfo populateMapAndBuildChainOfFeatures(HashMap<String, NavigationInfo> hashMap, OrganizerMap organizerMap) {
        ArrayList<NavigationInfo> arrayList;
        NavigationInfo navigationInfo = null;
        NavigationInfo navigationInfo2 = null;
        for (FeatureType featureType : this.orderedTypes) {
            arrayList = organizerMap.getFeatureList(featureType);
            if (arrayList == null) continue;
            if (navigationInfo == null && arrayList.size() > 0) {
                navigationInfo = arrayList.get(0);
            }
            navigationInfo2 = this.addListMembersToChain(arrayList, navigationInfo2, hashMap);
        }
        while (organizerMap.hasFacets()) {
            organizerMap = organizerMap.getFacets();
            for (FeatureType featureType : this.orderedTypes) {
                arrayList = organizerMap.getFeatureList(featureType);
                if (arrayList == null) continue;
                navigationInfo2 = this.addListMembersToChain(arrayList, navigationInfo2, hashMap);
                if (navigationInfo != null) continue;
                navigationInfo = navigationInfo2;
            }
        }
        if (navigationInfo2 != navigationInfo) {
            navigationInfo2.setNext(navigationInfo);
            navigationInfo.setPrevious(navigationInfo2);
        }
        return navigationInfo;
    }

    private NavigationInfo addListMembersToChain(ArrayList<NavigationInfo> arrayList, NavigationInfo navigationInfo, HashMap<String, NavigationInfo> hashMap) {
        if (arrayList == null) {
            return navigationInfo;
        }
        for (NavigationInfo navigationInfo2 : arrayList) {
            NavigationInfo navigationInfo3 = hashMap.get(navigationInfo2.getBaseId());
            if (navigationInfo3 != null) continue;
            if (navigationInfo != null) {
                navigationInfo.setNext(navigationInfo2);
            }
            navigationInfo2.setPrevious(navigationInfo);
            hashMap.put(navigationInfo2.getBaseId(), navigationInfo2);
            navigationInfo = navigationInfo2;
        }
        return navigationInfo;
    }

    private void gatherFeatures(SceneNodeImpl sceneNodeImpl, OrganizerMap organizerMap) {
        List<SceneNode> list = sceneNodeImpl.getChildren();
        for (SceneNode sceneNode : list) {
            List<SceneNode> list2;
            FeatureType featureType = SceneHelper.getFeatureType(sceneNode);
            if (featureType == null || FeatureType.AXIS == featureType && !this.isAxisNavigable(sceneNode)) continue;
            String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
            if (SceneIdUtil.isGridBandId(string = SceneIdUtil.stripFacetIndexFromId(string))) continue;
            if (featureType == FeatureType.FACET) {
                list2 = sceneNode.getChildren();
                if (list2 == null) continue;
                OrganizerMap organizerMap2 = organizerMap.getFacets();
                this.gatherFeatures((SceneNodeImpl)sceneNode, organizerMap2);
                continue;
            }
            list2 = this.makeNavigationInfo(sceneNode, featureType, string, organizerMap);
            organizerMap.addFeature((NavigationInfo)((Object)list2));
        }
    }

    private NavigationInfo makeNavigationInfo(SceneNode sceneNode, FeatureType featureType, String string, OrganizerMap organizerMap) {
        Object object;
        if (string == null) {
            return null;
        }
        if (featureType == FeatureType.ELEMENT) {
            Object object2;
            Object object3;
            String string2 = ((ElementGroupSceneNode)sceneNode).getElementType();
            NavigationInfo navigationInfo = this.elementTemplates.get(string2);
            if (navigationInfo == null) {
                navigationInfo = this.standardElement;
            } else if (INTERVAL.equals(string2)) {
                object3 = organizerMap.getCoords(string);
                object2 = ((CoordinatesSceneNode)object3).getCoordinates().transforms;
                if (object2 != null) {
                    for (int i = 0; i < ((TransformSpec[])object2).length; ++i) {
                        if (!"stack".equals(object2[i].type)) continue;
                        if (((TransformSpec[])object2).length <= i + 1 || !POLAR.equals(object2[i + 1].type)) break;
                        navigationInfo = this.standardElement;
                        break;
                    }
                }
            }
            object3 = navigationInfo.createCopy(string, organizerMap.isFacet());
            object2 = ((ElementGroupSceneNode)sceneNode).getLink();
            if (object2 != null) {
                if ("*".equals(object2)) {
                    navigationInfo = this.elementTemplates.get(CHORD);
                    object3 = navigationInfo.createCopy(string, organizerMap.isFacet());
                    ((NavigationInfo)object3).setChordLayout(true);
                } else {
                    ArrayList<NavigationInfo> arrayList = organizerMap.getFeatureList(FeatureType.ELEMENT);
                    if (arrayList != null) {
                        for (NavigationInfo navigationInfo2 : arrayList) {
                            if (!((String)object2).equals(navigationInfo2.getBaseId())) continue;
                            navigationInfo2.setLinks((NavigationInfo)object3);
                            ((NavigationInfo)object3).setNodes(navigationInfo2);
                            break;
                        }
                    }
                }
            }
            return object3;
        }
        if (featureType == FeatureType.AXIS || featureType == FeatureType.GRIDLINE) {
            object = organizerMap.getCoords(string);
            TransformSpec[] transformSpecArray = ((CoordinatesSceneNode)object).getCoordinates().transforms;
            if (transformSpecArray != null) {
                for (int i = 0; i < transformSpecArray.length; ++i) {
                    if (!POLAR.equals(transformSpecArray[i].type)) continue;
                    NavigationInfo navigationInfo = featureType == FeatureType.AXIS ? this.circularTemplates.get(POLAR) : this.circularTemplates.get(GRIDLINE);
                    return navigationInfo.createCopy(string, organizerMap.isFacet());
                }
            }
        }
        object = this.typeTemplates.get((Object)featureType);
        return ((NavigationInfo)object).createCopy(string, organizerMap.isFacet());
    }

    private void populateTemplates() {
        this.typeTemplates = new HashMap();
        this.elementTemplates = new HashMap();
        this.circularTemplates = new HashMap();
        NavigationInfo navigationInfo = new NavigationInfo(null, FeatureType.ELEMENT, 3.0, 27.0, false, false, true, null);
        this.standardElement = new NavigationInfo(null, FeatureType.ELEMENT, 3.0, 27.0, false, false, false, navigationInfo);
        NavigationInfo navigationInfo2 = new NavigationInfo(null, FeatureType.ELEMENT, 0.01, 27.0, false, false, false, navigationInfo);
        this.elementTemplates.put(INTERVAL, navigationInfo2);
        NavigationInfo navigationInfo3 = new NavigationInfo(null, FeatureType.ELEMENT, 1.0, 27.0, false, false, false, navigationInfo);
        this.elementTemplates.put(EDGE, navigationInfo3);
        NavigationInfo navigationInfo4 = new NavigationInfo(null, FeatureType.ELEMENT, 1.0, 27.0, false, false, false, navigationInfo);
        this.elementTemplates.put(CHORD, navigationInfo4);
        NavigationInfo navigationInfo5 = new NavigationInfo(null, FeatureType.AXIS, 1.0, 27.0, false, false, false, navigationInfo);
        this.circularTemplates.put(POLAR, navigationInfo5);
        NavigationInfo navigationInfo6 = new NavigationInfo(null, FeatureType.GRIDLINE, 1.0, 27.0, false, false, false, navigationInfo);
        this.circularTemplates.put(GRIDLINE, navigationInfo6);
        this.addNonElementTemplate(FeatureType.AXIS);
        this.addNonElementTemplate(FeatureType.GRIDLINE);
        this.addNonElementTemplate(FeatureType.LEGEND);
        this.addNonElementTemplate(FeatureType.TITLE);
    }

    private void addNonElementTemplate(FeatureType featureType) {
        NavigationInfo navigationInfo = new NavigationInfo(null, featureType, 1.1, 27.0, false, false, true, null);
        NavigationInfo navigationInfo2 = new NavigationInfo(null, featureType, 0.01, 27.0, true, true, false, navigationInfo);
        this.typeTemplates.put(featureType, navigationInfo2);
    }

    private boolean isAxisNavigable(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null) {
            return false;
        }
        for (SceneNode sceneNode2 : list) {
            SceneNodeType sceneNodeType = sceneNode2.getType();
            if (SceneNodeType.AXIS_LABEL == sceneNodeType) {
                return true;
            }
            String string = sceneNode2.getId();
            if (string == null || string.indexOf(T) == -1) continue;
            return true;
        }
        return false;
    }
}

