/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FeaturePart {
    private final String id;
    private Point anchor;
    private FeaturePart next;
    private FeaturePart previous;
    private ArrayList<FeaturePart> sortedListX;
    private ArrayList<FeaturePart> sortedListY;

    public FeaturePart(String string, Point point) {
        this.id = string;
        this.anchor = point;
    }

    public final String getId() {
        return this.id;
    }

    protected void setNext(FeaturePart featurePart) {
        this.next = featurePart;
    }

    protected void setPrevious(FeaturePart featurePart) {
        this.previous = featurePart;
    }

    protected void setListX(ArrayList<FeaturePart> arrayList) {
        this.sortedListX = arrayList;
        if (arrayList != null) {
            arrayList.add(this);
        }
    }

    protected void setListY(ArrayList<FeaturePart> arrayList) {
        this.sortedListY = arrayList;
        if (arrayList != null) {
            arrayList.add(this);
        }
    }

    public ArrayList<FeaturePart> getListX() {
        return this.sortedListX;
    }

    public ArrayList<FeaturePart> getListY() {
        return this.sortedListY;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    protected FeaturePart changePart(FeatureShift featureShift) {
        FeaturePart featurePart = this;
        if (featureShift == FeatureShift.NEXT) {
            featurePart = this.next == null ? this : this.next;
        } else if (featureShift == FeatureShift.PREVIOUS) {
            featurePart = this.previous == null ? this : this.previous;
        }
        return featurePart;
    }

    FeaturePart toggleSelectedLink() {
        return this;
    }
}

