/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.DirectionalNavigation;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.OrganizerMap;
import com.ibm.vis.interaction.navigation.MoveWeight;
import com.ibm.vis.interaction.navigation.NavigationDirection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GraphNavigation
extends DirectionalNavigation {
    private boolean isSingleGraph;
    private String pointOfRegardId;
    private HashMap<String, NavigationInfo> startingFeatureMap;

    public GraphNavigation(HashMap<String, FeaturePart> hashMap, NavigationInfo navigationInfo, String string) {
        super(hashMap, navigationInfo);
        this.pointOfRegardId = string;
        this.isSingleGraph = hashMap.size() < 2;
    }

    public void setStartingFeatureMap(HashMap<String, NavigationInfo> hashMap) {
        this.startingFeatureMap = hashMap;
    }

    public final boolean isSingleGraph() {
        return this.isSingleGraph;
    }

    protected Set<String> getKeys() {
        return this.featurePartsMap.keySet();
    }

    public String firstGraphFeature() {
        return this.startingFeatureMap.get(this.pointOfRegardId).getBaseId();
    }

    void removeNonNavigableGrammars(OrganizerMap organizerMap) {
        if (this.isSingleGraph) {
            return;
        }
        HashMap<String, OrganizerMap> hashMap = organizerMap.splitByGraph();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String object2 : this.featurePartsMap.keySet()) {
            FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(object2);
            OrganizerMap organizerMap2 = hashMap.get(object2);
            if (organizerMap2 == null) {
                arrayList.add(object2);
                featurePart.getListX().remove(featurePart);
                featurePart.getListY().remove(featurePart);
                continue;
            }
            arrayList2.add(object2);
        }
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                this.featurePartsMap.remove(string);
            }
            FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(arrayList2.get(0));
            ArrayList<FeaturePart> arrayList3 = featurePart.getListX();
            BasicFactory.sortList(arrayList3, FeaturePartComparator.X);
            BasicFactory.sortList(featurePart.getListY(), FeaturePartComparator.Y);
            this.pointOfRegardId = arrayList3.get(0).getId();
        }
    }

    public String moveGraph(NavigationInfo navigationInfo, String string, NavigationDirection navigationDirection, MoveWeight moveWeight) {
        if (this.isSingleGraph || navigationDirection == null) {
            return string;
        }
        String string2 = SceneIdUtil.getGraphIndex(string);
        String string3 = null;
        if (navigationDirection == NavigationDirection.GREATER_X) {
            string3 = this.nextGreaterX(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_X) {
            string3 = this.nextLesserX(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_Y) {
            string3 = this.nextLesserY(string2, moveWeight);
        } else if (navigationDirection == NavigationDirection.GREATER_Y) {
            string3 = this.nextGreaterY(string2, moveWeight);
        }
        if (string3.equals(string2)) {
            return string;
        }
        this.pointOfRegardId = string3;
        if (navigationInfo != null) {
            this.startingFeatureMap.put(string2, navigationInfo);
        }
        return this.startingFeatureMap.get(string3).getBaseId();
    }
}

