/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.FeaturePartShiftBuilder;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LegendShiftBuilder
extends FeaturePartShiftBuilder {
    private static final String LE = "LE";
    private FeaturePart first;
    private FeaturePart last;

    static String makeKey(String string) {
        if (string == null || SceneIdUtil.isBackId(string) || SceneIdUtil.isPartId(string)) {
            return null;
        }
        int n = string.indexOf("T");
        if (n > 0) {
            return n == string.length() - 1 ? "T" : null;
        }
        int n2 = string.indexOf(LE);
        if (n2 == -1) {
            return null;
        }
        return string.indexOf("S") > 0 ? null : LE;
    }

    public LegendShiftBuilder(String string) {
        super(string);
    }

    private HashMap<String, SceneNode> makeLegendEntryMap(HashMap<String, ArrayList<SceneNode>> hashMap) {
        HashMap<String, SceneNode> hashMap2 = new HashMap<String, SceneNode>();
        for (String string : hashMap.keySet()) {
            ArrayList<SceneNode> arrayList = hashMap.get(string);
            for (SceneNode sceneNode : arrayList) {
                SceneNodeType sceneNodeType = sceneNode.getType();
                if (SceneNodeType.LEGEND_ENTRY != sceneNodeType) continue;
                String string2 = sceneNode.getId();
                hashMap2.put(string2, sceneNode);
            }
        }
        return hashMap2;
    }

    @Override
    protected void addShifts(HashMap<String, FeaturePart> hashMap, HashMap<String, ArrayList<SceneNode>> hashMap2) {
        HashMap<String, SceneNode> hashMap3 = this.makeLegendEntryMap(hashMap2);
        ArrayList<FeaturePart> arrayList = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList3 = new ArrayList<FeaturePart>();
        for (String string : hashMap.keySet()) {
            FeaturePart featurePart = hashMap.get(string);
            featurePart.setListX(arrayList2);
            featurePart.setListY(arrayList3);
            SceneNode sceneNode = hashMap3.get(featurePart.getId());
            if (sceneNode != null) continue;
            arrayList.add(featurePart);
        }
        BasicFactory.sortList(arrayList2, FeaturePartComparator.X);
        BasicFactory.sortList(arrayList3, FeaturePartComparator.Y);
        this.orderedKeys = new String[1];
        if (arrayList.size() > 0) {
            this.first = (FeaturePart)arrayList.get(0);
            int n = arrayList3.size();
            this.last = n > 0 ? arrayList3.get(n - 1) : this.first;
        } else if (arrayList3.size() > 0) {
            this.first = arrayList3.get(0);
            this.last = arrayList3.get(arrayList3.size() - 1);
        }
    }

    @Override
    protected FeaturePart getFirst(HashMap<String, ArrayList<FeaturePart>> hashMap) {
        return this.first;
    }

    public FeaturePart getLast() {
        return this.last;
    }
}

