/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.navigation.FacetLocator;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.IslandNode;
import com.ibm.vis.interaction.internal.navigation.LinkNav;
import com.ibm.vis.interaction.internal.navigation.LinkNavState;
import com.ibm.vis.interaction.internal.navigation.NavLink;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.NodeNav;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LinkNavigation
extends FeatureNavigation {
    private final HashMap<String, LinkNavState> linkMap = new HashMap();
    private LinkNavState targetLink;
    private boolean isLink;
    private HashMap<String, ArrayList<NavLink>> linksFromAnchor;
    private HashMap<String, ArrayList<NavLink>> linksToAnchor;
    private HashMap<String, NavLink> linkLinkMap;
    private boolean linksSelectable;

    public LinkNavigation(HashMap<String, FeaturePart> hashMap, NavigationInfo navigationInfo, HashMap<String, FacetLocator> hashMap2, String string) {
        super(hashMap, navigationInfo, hashMap2, string);
    }

    @Override
    protected boolean doesLinkMove() {
        return true;
    }

    protected void linkToggleTarget(String string, InteractivityImpl interactivityImpl) {
        this.targetLink = this.getLinkNavState(string);
        if (this.targetLink != null) {
            this.targetLink.toggleTarget(interactivityImpl);
            this.targetLink.highlightState(interactivityImpl);
        }
    }

    protected void setToLinks(HashMap<String, NavLink> hashMap) {
        this.linkLinkMap = hashMap;
        this.isLink = true;
    }

    protected void setToNodes(HashMap<String, ArrayList<NavLink>> hashMap, HashMap<String, ArrayList<NavLink>> hashMap2, boolean bl) {
        this.linksFromAnchor = hashMap;
        this.linksToAnchor = hashMap2;
        this.linksSelectable = bl;
        this.isLink = false;
    }

    protected void linkSetSelected(String string, InteractivityImpl interactivityImpl, boolean bl) {
        this.targetLink = this.getLinkNavState(string);
        if (bl && this.targetLink != null) {
            this.targetLink.highlightState(interactivityImpl);
        }
    }

    protected void linkShift(String string, FeatureShift featureShift, InteractivityImpl interactivityImpl) {
        this.targetLink = this.getLinkNavState(string);
        if (this.targetLink != null) {
            this.targetLink.shift(featureShift, interactivityImpl);
            this.targetLink.highlightState(interactivityImpl);
        }
    }

    protected String linkSelectTarget(InteractivityImpl interactivityImpl) {
        String string = this.targetLink.select();
        if (this.isFeature(string)) {
            this.linkSetSelected(string, interactivityImpl, true);
        } else {
            this.setPointOfRegard(this.targetLink.getId());
        }
        return string;
    }

    private boolean isFeature(String string) {
        String string2 = SceneIdUtil.baseId(string);
        return this.info.getBaseId().equals(string2);
    }

    private LinkNavState getLinkNavState(String string) {
        LinkNavState linkNavState = this.linkMap.get(string);
        if (linkNavState == null) {
            linkNavState = this.makeLinkNavState(string);
            this.linkMap.put(string, linkNavState);
        }
        return linkNavState;
    }

    private LinkNavState makeLinkNavState(String string) {
        if (this.isLink) {
            NavLink navLink = this.linkLinkMap.get(string);
            return new LinkNav(navLink);
        }
        ArrayList<NavLink> arrayList = this.linksFromAnchor.get(string);
        ArrayList<NavLink> arrayList2 = this.linksToAnchor.get(string);
        FeaturePart featurePart = (FeaturePart)this.featurePartsMap.get(string);
        return arrayList == null && arrayList2 == null ? new IslandNode(featurePart) : new NodeNav(arrayList, arrayList2, this.linksSelectable, featurePart);
    }
}

