/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.LinkNavigation;
import com.ibm.vis.interaction.internal.navigation.NavLink;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.spec.internal.ElementsSpec;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LinkNavigationBuilder {
    private InteractivityImpl interactivity;
    private SceneHelper helper;

    protected static LinkNavigation[] buildLinkNavigations(FeatureNavigation featureNavigation, FeatureNavigation featureNavigation2, InteractivityImpl interactivityImpl) {
        return new LinkNavigationBuilder(interactivityImpl).getLinkNavigation(featureNavigation, featureNavigation2);
    }

    private LinkNavigationBuilder(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
        this.helper = new SceneHelper(interactivityImpl.getVisInstance());
    }

    private LinkNavigation[] getLinkNavigation(FeatureNavigation featureNavigation, FeatureNavigation featureNavigation2) {
        ArrayList<NavLink> arrayList = this.makeLinks(featureNavigation, featureNavigation2);
        boolean bl = this.isLinkSelectable(featureNavigation2.getInfo());
        HashMap<String, ArrayList<NavLink>> hashMap = new HashMap<String, ArrayList<NavLink>>();
        HashMap<String, ArrayList<NavLink>> hashMap2 = new HashMap<String, ArrayList<NavLink>>();
        HashMap<String, NavLink> hashMap3 = bl ? new HashMap<String, NavLink>() : null;
        for (NavLink navLink : arrayList) {
            this.addToMap(hashMap, navLink.getFrom().getId(), navLink);
            this.addToMap(hashMap2, navLink.getTo().getId(), navLink);
            if (!bl) continue;
            hashMap3.put(navLink.getLink().getId(), navLink);
        }
        LinkNavigation[] linkNavigationArray = bl ? new LinkNavigation[2] : new LinkNavigation[1];
        linkNavigationArray[0] = new LinkNavigation(featureNavigation.getFeaturePartMap(), featureNavigation.getInfo(), featureNavigation.facetNavigation.getFacets(), featureNavigation.facetNavigation.getPointOfRegardString());
        linkNavigationArray[0].setToNodes(hashMap, hashMap2, bl);
        if (bl) {
            linkNavigationArray[1] = new LinkNavigation(featureNavigation2.getFeaturePartMap(), featureNavigation2.getInfo(), featureNavigation2.facetNavigation.getFacets(), featureNavigation2.facetNavigation.getPointOfRegardString());
            linkNavigationArray[1].setToLinks(hashMap3);
        }
        return linkNavigationArray;
    }

    private boolean isLinkSelectable(NavigationInfo navigationInfo) {
        ElementsSpec elementsSpec = this.helper.getElementsSpec(navigationInfo.getBaseId());
        return elementsSpec.label != null || elementsSpec.color != null || elementsSpec.size != null || elementsSpec.dashing != null || elementsSpec.styleBy != null;
    }

    private void addToMap(HashMap<String, ArrayList<NavLink>> hashMap, String string, NavLink navLink) {
        ArrayList<NavLink> arrayList = hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(string, arrayList);
        }
        arrayList.add(navLink);
    }

    private ArrayList<NavLink> makeLinks(FeatureNavigation featureNavigation, FeatureNavigation featureNavigation2) {
        String string = featureNavigation.getInfo().getBaseId();
        SceneNode sceneNode = this.getGroup(string);
        HashMap<Double, String> hashMap = this.helper.makeDataIdMap(sceneNode, string);
        HashMap<String, FeaturePart> hashMap2 = featureNavigation.getFeaturePartMap();
        HashMap<Double, FeaturePart> hashMap3 = new HashMap<Double, FeaturePart>();
        for (Double d : hashMap.keySet()) {
            String string2 = hashMap.get(d);
            hashMap3.put(d, hashMap2.get(string2));
        }
        return this.makeLinksFromMaps(hashMap3, featureNavigation2.getFeaturePartMap(), featureNavigation2.getInfo().getBaseId());
    }

    private ArrayList<NavLink> makeLinksFromMaps(HashMap<Double, FeaturePart> hashMap, HashMap<String, FeaturePart> hashMap2, String string) {
        Field field = this.helper.getFromField(string);
        Field field2 = this.helper.getToField(string);
        ArrayList<NavLink> arrayList = new ArrayList<NavLink>();
        SceneNode sceneNode = this.getGroup(string);
        this.populateLinks(sceneNode, arrayList, hashMap, hashMap2, field, field2);
        return arrayList;
    }

    private void populateLinks(SceneNode sceneNode, ArrayList<NavLink> arrayList, HashMap<Double, FeaturePart> hashMap, HashMap<String, FeaturePart> hashMap2, Field field, Field field2) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
                this.populateLinks(sceneNode2, arrayList, hashMap, hashMap2, field, field2);
                continue;
            }
            if (!SceneHelper.isElementSymbol(sceneNode2.getId())) continue;
            Shape shape = (Shape)sceneNode2.getShape();
            int n = shape.getRows()[0];
            FeaturePart featurePart = this.getPart(field2, n, hashMap);
            FeaturePart featurePart2 = this.getPart(field, n, hashMap);
            FeaturePart featurePart3 = hashMap2.get(sceneNode2.getId());
            if (featurePart == null || featurePart2 == null || featurePart3 == null) continue;
            arrayList.add(new NavLink(featurePart2, featurePart, featurePart3));
        }
    }

    private FeaturePart getPart(Field field, int n, HashMap<Double, FeaturePart> hashMap) {
        return hashMap.get(field.getRowValue(n));
    }

    private SceneNode getGroup(String string) {
        CompositeSceneNode compositeSceneNode = this.interactivity.getSceneState().getSceneTree().getRoot();
        for (SceneNode sceneNode : compositeSceneNode.getChildren()) {
            if (!string.equals(SceneIdUtil.getBaseIdForSceneNode(sceneNode))) continue;
            return sceneNode;
        }
        return null;
    }
}

