/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.NavLink;
import java.util.Comparator;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NavLinkComparator
implements Comparator<NavLink> {
    private FeaturePart node;

    NavLinkComparator(FeaturePart featurePart) {
        this.node = featurePart;
    }

    @Override
    public int compare(NavLink navLink, NavLink navLink2) {
        Point point;
        Point point2;
        boolean bl = navLink.isFrom(this.node);
        boolean bl2 = navLink2.isFrom(this.node);
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        if (bl) {
            point2 = navLink.getTo().getAnchor();
            point = navLink2.getTo().getAnchor();
        } else {
            point2 = navLink.getFrom().getAnchor();
            point = navLink2.getFrom().getAnchor();
        }
        double d = point2.getX() - point.getX();
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        double d2 = point2.getY() - point.getY();
        if (d2 < 0.0) {
            return -1;
        }
        if (d2 > 0.0) {
            return 1;
        }
        return 0;
    }
}

