/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.SceneState;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigation;
import com.ibm.vis.interaction.internal.navigation.FeatureNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.FeatureOrganizer;
import com.ibm.vis.interaction.internal.navigation.GraphNavigation;
import com.ibm.vis.interaction.internal.navigation.LinkNavigation;
import com.ibm.vis.interaction.internal.navigation.LinkNavigationBuilder;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.internal.navigation.SceneMap;
import com.ibm.vis.interaction.navigation.FeatureShift;
import com.ibm.vis.interaction.navigation.MoveWeight;
import com.ibm.vis.interaction.navigation.Navigation;
import com.ibm.vis.interaction.navigation.NavigationDirection;
import com.ibm.vis.interaction.navigation.NavigationLevel;
import com.ibm.vis.scenetree.provisional.SceneTree;
import java.util.ArrayList;
import java.util.HashMap;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NavigationImpl
extends Navigation {
    private static final int HIGHLIGHT = 0;
    private final InteractivityImpl interactivity;
    private FeatureOrganizer organizer;
    private FeatureNavigationBuilder builder;
    private ArrayList<String> selectedStack;
    private SceneMap sceneMap;
    private HashMap<String, FeatureNavigation> navigationMap;
    private NavigationLevel level;
    private boolean isMirror;
    private boolean hasLinkNavigation;

    public NavigationImpl(InteractivityImpl interactivityImpl) {
        this.interactivity = interactivityImpl;
        this.selectedStack = new ArrayList();
        this.navigationMap = new HashMap();
        this.organizer = new FeatureOrganizer();
        this.builder = new FeatureNavigationBuilder(interactivityImpl);
        this.sceneMap = null;
        this.level = NavigationLevel.INTERIOR;
    }

    public void sceneChanged() {
        this.selectedStack = new ArrayList();
        this.navigationMap = new HashMap();
        this.isMirror = false;
        this.sceneMap = null;
    }

    @Override
    public SceneItem moveFeaturePart(FeatureShift featureShift) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        if (featureShift == null) {
            return this.interactivity.getSelected(0)[0];
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
        String string2 = featureNavigation.partMove(string, featureShift);
        return this.setSelectedAndGetSceneItem(string2);
    }

    private FeatureNavigation getFeatureNavigation(String string) {
        String string2 = SceneIdUtil.baseId(string);
        string2 = SceneIdUtil.stripFacetIndexFromId(string2);
        return this.getNavigation(string2);
    }

    @Override
    public SceneItem firstItem() {
        return this.firstOrLastItem(true);
    }

    @Override
    public SceneItem lastItem() {
        return this.firstOrLastItem(false);
    }

    private SceneItem firstOrLastItem(boolean bl) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        if (this.level == NavigationLevel.INTERIOR) {
            FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
            String string2 = bl ? featureNavigation.firstItem(string) : featureNavigation.lastItem(string);
            return this.setSelectedAndGetSceneItem(string2);
        }
        return this.interactivity.getSelected(0)[0];
    }

    @Override
    public SceneItem move(NavigationDirection navigationDirection, MoveWeight moveWeight) {
        if (this.level == NavigationLevel.INTERIOR) {
            navigationDirection = this.swapXDirectionIfMirrored(navigationDirection);
            return this.moveInterior(navigationDirection, moveWeight);
        }
        if (this.level == NavigationLevel.FACET) {
            navigationDirection = this.swapXDirectionIfMirrored(navigationDirection);
            return this.moveFacet(navigationDirection, moveWeight);
        }
        if (this.level == NavigationLevel.GRAPH) {
            return this.moveGraph(navigationDirection, moveWeight);
        }
        return this.moveInterior(navigationDirection, moveWeight);
    }

    private NavigationDirection swapXDirectionIfMirrored(NavigationDirection navigationDirection) {
        if (this.isMirror) {
            if (navigationDirection == NavigationDirection.GREATER_X) {
                navigationDirection = NavigationDirection.LESSER_X;
            } else if (navigationDirection == NavigationDirection.LESSER_X) {
                navigationDirection = NavigationDirection.GREATER_X;
            }
        }
        return navigationDirection;
    }

    public SceneItem moveInterior(NavigationDirection navigationDirection, MoveWeight moveWeight) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        if (navigationDirection == null) {
            return this.interactivity.getSelected(0)[0];
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
        if (navigationDirection == NavigationDirection.GREATER_X) {
            string = featureNavigation.nextGreaterX(string, moveWeight);
        } else if (navigationDirection == NavigationDirection.GREATER_Y) {
            string = featureNavigation.nextGreaterY(string, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_X) {
            string = featureNavigation.nextLesserX(string, moveWeight);
        } else if (navigationDirection == NavigationDirection.LESSER_Y) {
            string = featureNavigation.nextLesserY(string, moveWeight);
        }
        return this.setSelectedAndGetSceneItem(string);
    }

    @Override
    public void setMoveLevel(NavigationLevel navigationLevel) {
        if (navigationLevel != null) {
            boolean bl = this.level == NavigationLevel.LINK && navigationLevel != NavigationLevel.LINK;
            this.level = navigationLevel;
            this.setLink(bl);
        }
    }

    private void setLink(boolean bl) {
        LinkNavigation linkNavigation = this.getLinkNavigation();
        if (linkNavigation != null) {
            if (this.level == NavigationLevel.LINK) {
                linkNavigation.linkSetSelected(this.getSelectedId(), this.interactivity, true);
            } else if (bl) {
                this.highightSelected(this.interactivity.getSelected(0)[0]);
            }
        }
    }

    @Override
    public SceneItem nextFeature(FeatureShift featureShift) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        String string2 = SceneIdUtil.getFacetIndex(string);
        String string3 = SceneIdUtil.baseId(string);
        String string4 = this.nextIdForFacet(featureShift, string2, string3);
        return this.setSelectedAndGetSceneItem(string4);
    }

    private String nextIdForFacet(FeatureShift featureShift, String string, String string2) {
        String string3 = this.getSceneMap().nextFeature(SceneIdUtil.stripFacetIndexFromId(string2), featureShift);
        FeatureNavigation featureNavigation = this.getNavigation(string3);
        if (string == null || !SceneIdUtil.isFaceted(string3)) {
            return featureNavigation.pointOfRegard();
        }
        String string4 = SceneIdUtil.setFacetIndexInId(string3, string);
        String string5 = null;
        try {
            string5 = featureNavigation.getPointOfRegardForFacet(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string5 == null ? this.nextIdForFacet(featureShift, string, string4) : string5;
    }

    private SceneItem moveGraph(NavigationDirection navigationDirection, MoveWeight moveWeight) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        SceneMap sceneMap = this.getSceneMap();
        GraphNavigation graphNavigation = sceneMap.getGraphNavigation();
        NavigationInfo navigationInfo = sceneMap.getInfo(SceneIdUtil.baseId(string));
        this.setPointOfRegard(string);
        String string2 = graphNavigation.moveGraph(navigationInfo, string, navigationDirection, moveWeight);
        if (string.equals(string2)) {
            return this.interactivity.getSelected(0)[0];
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string2);
        if (featureNavigation == null) {
            return this.interactivity.getSelected(0)[0];
        }
        String string3 = featureNavigation.pointOfRegard();
        return this.setSelectedAndGetSceneItem(string3);
    }

    private void setPointOfRegard(String string) {
        if (string == null) {
            return;
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
        if (featureNavigation != null) {
            featureNavigation.setPointOfRegard(string);
        }
    }

    private SceneItem moveFacet(NavigationDirection navigationDirection, MoveWeight moveWeight) {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
        String string2 = featureNavigation.moveFacet(string, navigationDirection, moveWeight);
        if (string.equals(string2)) {
            return this.interactivity.getSelected(0)[0];
        }
        return this.setSelectedAndGetSceneItem(string2);
    }

    private SceneMap getSceneMap() {
        if (this.sceneMap == null) {
            SceneTree sceneTree = this.interactivity.getSceneState().getSceneTree();
            if (sceneTree != null) {
                this.sceneMap = this.organizer.createSceneMap(sceneTree);
            }
            this.isMirror = this.interactivity.getVisInstance().getMirror();
        }
        return this.sceneMap;
    }

    @Override
    public SceneItem first() {
        SceneMap sceneMap = this.getSceneMap();
        String string = sceneMap.getFirstFeature();
        if (string == null) {
            return null;
        }
        FeatureNavigation featureNavigation = this.getNavigation(string);
        if (featureNavigation == null) {
            return this.first();
        }
        String string2 = featureNavigation.pointOfRegard();
        return this.setSelectedAndGetSceneItem(string2);
    }

    @Override
    public boolean setSelected(SceneItem sceneItem) {
        SceneItem sceneItem2 = this.getNavigableSceneItem(sceneItem);
        if (sceneItem2 == null) {
            return false;
        }
        String string = ((SceneItemImpl)sceneItem2).id;
        String string2 = this.getSelectedId();
        if (this.addToSelectedStack(string)) {
            this.setPointOfRegard(string2);
            this.setPointOfRegard(string);
            SceneState sceneState = this.interactivity.getSceneState();
            SceneItem[] sceneItemArray = new SceneItem[]{sceneItem2};
            sceneState.setSelected(sceneItemArray, 0);
            if (!this.highlightLink(string)) {
                this.highightSelected(sceneItem2);
            }
        }
        return true;
    }

    private SceneItem getNavigableSceneItem(SceneItem sceneItem) {
        String string = ((SceneItemImpl)sceneItem).id;
        if (!SceneIdUtil.isNavigable(string)) {
            return null;
        }
        String string2 = SceneIdUtil.clipLegendIdToNavigableId(string);
        if (string == string2) {
            return sceneItem;
        }
        return this.interactivity.getSceneState().getById(string2);
    }

    private boolean highlightLink(String string) {
        if (this.level != NavigationLevel.LINK) {
            return false;
        }
        FeatureNavigation featureNavigation = this.getNavigation(SceneIdUtil.baseId(string));
        if (featureNavigation.doesLinkMove()) {
            ((LinkNavigation)featureNavigation).linkSetSelected(string, this.interactivity, true);
            return true;
        }
        return false;
    }

    @Override
    public SceneItem back() {
        if (this.selectedStack.size() < 2) {
            this.selectedStack.clear();
            return this.first();
        }
        this.popStack();
        String string = this.selectedStack.get(this.selectedStack.size() - 1);
        SceneItem sceneItem = this.setSceneStateSelected(string);
        if (!this.highlightLink(string)) {
            this.highightSelected(sceneItem);
        }
        return sceneItem;
    }

    private void popStack() {
        this.selectedStack.remove(this.selectedStack.size() - 1);
    }

    private SceneItem setSelectedAndGetSceneItem(String string) {
        SceneItem sceneItem = this.setSceneStateSelected(string);
        this.setSelected(sceneItem);
        return sceneItem;
    }

    private SceneItem setSceneStateSelected(String string) {
        SceneState sceneState = this.interactivity.getSceneState();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        sceneState.setSelectedItemsIDs(arrayList, 0);
        return this.interactivity.getSelected(0)[0];
    }

    private String getSelectedId() {
        ArrayList<String> arrayList = this.interactivity.getSceneState().getSelectedIds(0);
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        String string = arrayList.get(0);
        if (SceneIdUtil.isNavigable(string)) {
            return string;
        }
        return null;
    }

    private boolean addToSelectedStack(String string) {
        int n = this.selectedStack.size();
        if (n != 0 && this.selectedStack.get(n - 1).equals(string)) {
            return false;
        }
        this.selectedStack.add(string);
        return true;
    }

    private FeatureNavigation getNavigation(String string) {
        FeatureNavigation featureNavigation = this.getFeatureNavigationFromMap(string);
        if (this.level == NavigationLevel.LINK && featureNavigation != null) {
            FeatureNavigation featureNavigation2;
            if (featureNavigation.doesLinkMove()) {
                return featureNavigation;
            }
            NavigationInfo navigationInfo = featureNavigation.getInfo();
            if (navigationInfo.getLinks() != null) {
                FeatureNavigation featureNavigation3 = this.getFeatureNavigationFromMap(navigationInfo.getLinks().getBaseId());
                if (featureNavigation3 == null) {
                    return featureNavigation;
                }
                LinkNavigation[] linkNavigationArray = LinkNavigationBuilder.buildLinkNavigations(featureNavigation, featureNavigation3, this.interactivity);
                if (!this.hasLinkNavigation) {
                    this.interactivity.addLinkHighlights();
                    this.hasLinkNavigation = true;
                }
                this.navigationMap.put(string, linkNavigationArray[0]);
                featureNavigation = linkNavigationArray[0];
                if (linkNavigationArray.length > 1) {
                    String string2 = linkNavigationArray[1].getInfo().getBaseId();
                    this.navigationMap.put(string2, linkNavigationArray[1]);
                }
            } else if (navigationInfo.getNodes() != null && !(featureNavigation2 = this.getFeatureNavigationFromMap(navigationInfo.getNodes().getBaseId())).doesLinkMove()) {
                LinkNavigation[] linkNavigationArray = LinkNavigationBuilder.buildLinkNavigations(featureNavigation2, featureNavigation, this.interactivity);
                this.navigationMap.put(string, linkNavigationArray[0]);
                if (linkNavigationArray.length > 1) {
                    String string3 = linkNavigationArray[1].getInfo().getBaseId();
                    this.navigationMap.put(string3, linkNavigationArray[1]);
                    featureNavigation = linkNavigationArray[1];
                }
            }
        }
        return featureNavigation;
    }

    private FeatureNavigation getFeatureNavigationFromMap(String string) {
        FeatureNavigation featureNavigation = this.navigationMap.get(string);
        if (featureNavigation == null) {
            featureNavigation = this.buildNavigation(string);
            if (featureNavigation == null) {
                SceneMap sceneMap = this.getSceneMap();
                sceneMap.setNotNavigable(string);
                return null;
            }
            this.navigationMap.put(string, featureNavigation);
        }
        return featureNavigation;
    }

    private FeatureNavigation buildNavigation(String string) {
        NavigationInfo navigationInfo = this.getSceneMap().getInfo(string);
        return this.builder.getFeatureNavigation(navigationInfo, this.interactivity.getSceneState().getSceneTree());
    }

    private void highightSelected(SceneItem sceneItem) {
        HighlightState highlightState = this.interactivity.makeHighlightState();
        highlightState.setSingle(sceneItem, 0);
        highlightState.apply();
    }

    private LinkNavigation getLinkNavigation() {
        FeatureNavigation featureNavigation;
        if (this.level != NavigationLevel.LINK) {
            return null;
        }
        String string = this.getSelectedId();
        if (string == null) {
            this.first();
            string = this.getSelectedId();
        }
        return (featureNavigation = this.getFeatureNavigation(string)).doesLinkMove() ? (LinkNavigation)featureNavigation : null;
    }

    @Override
    public void linkToggleTarget() {
        LinkNavigation linkNavigation = this.getLinkNavigation();
        if (linkNavigation != null) {
            linkNavigation.linkToggleTarget(this.getSelectedId(), this.interactivity);
        }
    }

    @Override
    public void linkShift(FeatureShift featureShift) {
        LinkNavigation linkNavigation = this.getLinkNavigation();
        if (linkNavigation != null) {
            linkNavigation.linkShift(this.getSelectedId(), featureShift, this.interactivity);
        }
    }

    @Override
    public SceneItem linkSelectTarget() {
        LinkNavigation linkNavigation = this.getLinkNavigation();
        return linkNavigation == null ? this.toggleChordLink() : this.setSelectedAndGetSceneItem(linkNavigation.linkSelectTarget(this.interactivity));
    }

    private SceneItem toggleChordLink() {
        String string = this.getSelectedId();
        if (string == null) {
            return this.first();
        }
        FeatureNavigation featureNavigation = this.getFeatureNavigation(string);
        String string2 = featureNavigation.toggleLink(string);
        return this.setSelectedAndGetSceneItem(string2);
    }
}

