/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.navigation.FeatureType;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NavigationInfo {
    private final String baseId;
    private final FeatureType type;
    private final boolean faceted;
    private final double heavyWeight;
    private final double normalWeight;
    private final boolean wrapX;
    private final boolean wrapY;
    private final NavigationInfo facetMoveInfo;
    private NavigationInfo previous;
    private NavigationInfo next;
    private NavigationInfo linkNavigationInfo;
    private NavigationInfo nodeNavigationInfo;
    private boolean chordLayout;

    protected NavigationInfo(String string, FeatureType featureType, double d, double d2, boolean bl, boolean bl2, boolean bl3, NavigationInfo navigationInfo) {
        this.baseId = string;
        this.type = featureType;
        this.normalWeight = d;
        this.heavyWeight = d2;
        this.wrapX = bl;
        this.wrapY = bl2;
        this.faceted = bl3;
        this.facetMoveInfo = navigationInfo;
    }

    public NavigationInfo createCopy(String string, boolean bl) {
        NavigationInfo navigationInfo = bl ? this.facetMoveInfo : null;
        boolean bl2 = bl ? false : this.wrapX;
        boolean bl3 = bl ? false : this.wrapY;
        return new NavigationInfo(string, this.type, this.normalWeight, this.heavyWeight, bl2, bl3, bl, navigationInfo);
    }

    protected final void setPrevious(NavigationInfo navigationInfo) {
        this.previous = navigationInfo;
    }

    protected final void setNext(NavigationInfo navigationInfo) {
        this.next = navigationInfo;
    }

    public final String getBaseId() {
        return this.baseId;
    }

    public final FeatureType getType() {
        return this.type;
    }

    public final boolean isFaceted() {
        return this.faceted;
    }

    public final NavigationInfo getFacetMoveInfo() {
        return this.facetMoveInfo;
    }

    public final boolean getWrapX() {
        return this.wrapX;
    }

    public final boolean getWrapY() {
        return this.wrapY;
    }

    public final double getNormalWeight() {
        return this.normalWeight;
    }

    public final double getHeavyWeight() {
        return this.heavyWeight;
    }

    public final NavigationInfo getNext() {
        return this.next;
    }

    public final NavigationInfo getPrevious() {
        return this.previous;
    }

    protected void setLinks(NavigationInfo navigationInfo) {
        this.linkNavigationInfo = navigationInfo;
    }

    protected void setNodes(NavigationInfo navigationInfo) {
        this.nodeNavigationInfo = navigationInfo;
    }

    public final NavigationInfo getNodes() {
        return this.nodeNavigationInfo;
    }

    public final NavigationInfo getLinks() {
        return this.linkNavigationInfo;
    }

    public final void setChordLayout(boolean bl) {
        this.chordLayout = bl;
    }

    public final boolean isChordLayout() {
        return this.chordLayout;
    }
}

