/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.HighlightState;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.LinkNavState;
import com.ibm.vis.interaction.internal.navigation.NavLink;
import com.ibm.vis.interaction.internal.navigation.NavLinkComparator;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class NodeNav
extends LinkNavState {
    private ArrayList<NavLink> fromAnchor;
    private ArrayList<NavLink> toAnchor;
    private NavLink targetLink;
    private FeaturePart anchor;
    private boolean isLinkSelectable;
    private boolean linkIsTarget;

    protected NodeNav(ArrayList<NavLink> arrayList, ArrayList<NavLink> arrayList2, boolean bl, FeaturePart featurePart) {
        this.fromAnchor = arrayList;
        this.toAnchor = arrayList2;
        if (this.toAnchor != null) {
            BasicFactory.sortList(this.toAnchor, new NavLinkComparator(featurePart));
            this.targetLink = this.toAnchor.get(0);
        }
        if (this.fromAnchor != null) {
            BasicFactory.sortList(this.fromAnchor, new NavLinkComparator(featurePart));
            this.targetLink = this.fromAnchor.get(0);
        }
        this.isLinkSelectable = bl;
        this.anchor = featurePart;
    }

    @Override
    protected void shift(FeatureShift featureShift, InteractivityImpl interactivityImpl) {
        this.nextTarget(FeatureShift.NEXT == featureShift);
        this.highlightState(interactivityImpl);
    }

    @Override
    protected void toggleTarget(InteractivityImpl interactivityImpl) {
        this.linkIsTarget = !this.linkIsTarget;
        this.highlightState(interactivityImpl);
    }

    private void nextTarget(boolean bl) {
        int n;
        int n2 = n = this.toAnchor == null ? -1 : this.toAnchor.indexOf(this.targetLink);
        if (n > -1) {
            this.targetLink = bl ? this.getNext(this.toAnchor, n, this.fromAnchor) : this.getPrevious(this.toAnchor, n, this.fromAnchor);
            return;
        }
        int n3 = n = this.fromAnchor == null ? -1 : this.fromAnchor.indexOf(this.targetLink);
        if (n > -1) {
            this.targetLink = bl ? this.getNext(this.fromAnchor, n, this.toAnchor) : this.getPrevious(this.fromAnchor, n, this.toAnchor);
        }
    }

    private NavLink getNext(ArrayList<NavLink> arrayList, int n, ArrayList<NavLink> arrayList2) {
        int n2 = arrayList.size();
        if (n + 1 < n2) {
            return arrayList.get(n + 1);
        }
        if (arrayList2 == null) {
            return arrayList.get(0);
        }
        return arrayList2.get(0);
    }

    private NavLink getPrevious(ArrayList<NavLink> arrayList, int n, ArrayList<NavLink> arrayList2) {
        if (n > 0) {
            return arrayList.get(n - 1);
        }
        if (arrayList2 == null) {
            return arrayList.get(arrayList.size() - 1);
        }
        return arrayList2.get(arrayList2.size() - 1);
    }

    @Override
    protected String select() {
        return this.getTargetId(true);
    }

    private String getTargetId(boolean bl) {
        if (this.linkIsTarget == bl) {
            return this.targetLink.getLink().getId();
        }
        return this.targetLink.getTo() == this.anchor ? this.targetLink.getFrom().getId() : this.targetLink.getTo().getId();
    }

    private void addIdsToLists(ArrayList<NavLink> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, boolean bl) {
        if (arrayList == null) {
            return;
        }
        for (NavLink navLink : arrayList) {
            if (navLink == this.targetLink) continue;
            arrayList2.add(navLink.getLink().getId());
            String string = bl ? navLink.getTo().getId() : navLink.getFrom().getId();
            arrayList3.add(string);
        }
    }

    @Override
    protected void highlightState(InteractivityImpl interactivityImpl) {
        HighlightState highlightState = interactivityImpl.makeHighlightState();
        this.addHighlight(interactivityImpl, highlightState, this.anchor.getId(), 0, true);
        this.addHighlight(interactivityImpl, highlightState, this.getTargetId(true), 87008, false);
        this.addHighlight(interactivityImpl, highlightState, this.getTargetId(false), 87009, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.addIdsToLists(this.toAnchor, arrayList, arrayList3, false);
        this.addIdsToLists(this.fromAnchor, arrayList, arrayList2, true);
        this.addToHighlightState(interactivityImpl, highlightState, arrayList, 87005, false);
        this.addToHighlightState(interactivityImpl, highlightState, arrayList3, 87007, false);
        this.addToHighlightState(interactivityImpl, highlightState, arrayList2, 87006, false);
        highlightState.apply();
    }

    @Override
    protected String getId() {
        return this.anchor.getId();
    }
}

