/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class OrganizerMap {
    private HashMap<FeatureType, ArrayList<NavigationInfo>> featureMap = new HashMap();
    private OrganizerMap facets;
    private OrganizerMap parent;
    private HashMap<String, CoordinatesSceneNode> coordMap;

    void addFeature(NavigationInfo navigationInfo) {
        if (navigationInfo == null) {
            return;
        }
        FeatureType featureType = navigationInfo.getType();
        ArrayList<NavigationInfo> arrayList = this.featureMap.get((Object)featureType);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.featureMap.put(featureType, arrayList);
        }
        arrayList.add(navigationInfo);
    }

    ArrayList<NavigationInfo> getFeatureList(FeatureType featureType) {
        return this.featureMap.get((Object)featureType);
    }

    boolean isFacet() {
        return this.parent != null;
    }

    OrganizerMap getFacets() {
        if (this.facets == null) {
            this.facets = new OrganizerMap();
            this.facets.parent = this;
        }
        return this.facets;
    }

    CoordinatesSceneNode getCoords(String string) {
        if (this.coordMap == null) {
            return this.parent != null && SceneIdUtil.isFaceted(string) ? this.parent.getFacetedCoord(string) : null;
        }
        return this.coordMap.get(SceneIdUtil.getGraphIndex(string));
    }

    private CoordinatesSceneNode getFacetedCoord(String string) {
        String string2 = SceneIdUtil.getGraphIndex(string);
        Set<String> set = this.coordMap.keySet();
        for (String string3 : set) {
            if (string3.indexOf(string2) <= -1) continue;
            return this.coordMap.get(string3);
        }
        return null;
    }

    HashMap<String, CoordinatesSceneNode> getCoordMap() {
        if (this.coordMap == null) {
            this.coordMap = new HashMap();
        }
        return this.coordMap;
    }

    boolean hasFacets() {
        return this.facets != null && !this.facets.featureMap.isEmpty();
    }

    HashMap<String, OrganizerMap> splitByGraph() {
        Object object;
        if (this.featureMap.isEmpty() && !this.hasFacets()) {
            return null;
        }
        HashMap<String, OrganizerMap> hashMap = new HashMap<String, OrganizerMap>();
        for (FeatureType object2 : this.featureMap.keySet()) {
            Object object3 = this.featureMap.get((Object)object2);
            object = ((ArrayList)object3).iterator();
            while (object.hasNext()) {
                NavigationInfo navigationInfo = object.next();
                String string = SceneIdUtil.getGraphIndex(navigationInfo.getBaseId());
                string = string == null ? "G0" : string;
                OrganizerMap organizerMap = hashMap.get(string);
                if (organizerMap == null) {
                    organizerMap = new OrganizerMap();
                    hashMap.put(string, organizerMap);
                }
                organizerMap.addFeature(navigationInfo);
            }
        }
        if (this.hasFacets()) {
            HashMap<String, OrganizerMap> hashMap2 = this.facets.splitByGraph();
            for (Object object3 : hashMap2.keySet()) {
                object = hashMap.get(object3);
                if (object == null) {
                    object = new OrganizerMap();
                    hashMap.put((String)object3, (OrganizerMap)object);
                }
                ((OrganizerMap)object).facets = (OrganizerMap)hashMap2.get(object3);
            }
        }
        return hashMap;
    }
}

