/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.label.TooltipProducer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.navigation.FeaturePart;
import com.ibm.vis.interaction.internal.navigation.FeaturePartComparator;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.GraphNavigation;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneHelper {
    public static final String ELEMENT_TYPE = "elementType";
    public static final String TITLE = "Title";
    public static final String T = "T";
    public static final String S = "S";
    private Vis vis;

    public static FeatureType getFeatureType(SceneNode sceneNode) {
        if (sceneNode == null) {
            return null;
        }
        return SceneHelper.getFeatureTypeFromTypeString(sceneNode.getType());
    }

    public static FeatureType getFeatureTypeFromTypeString(SceneNodeType sceneNodeType) {
        if (sceneNodeType == null) {
            return null;
        }
        switch (sceneNodeType) {
            case ELEMENT: {
                return FeatureType.ELEMENT;
            }
            case AXIS_BACK: {
                return FeatureType.GRIDLINE;
            }
            case FACET: {
                return FeatureType.FACET;
            }
            case LEGEND: {
                return FeatureType.LEGEND;
            }
            case TITLE: {
                return FeatureType.TITLE;
            }
        }
        if (SceneNodeTypeUtil.isAxis(sceneNodeType)) {
            return FeatureType.AXIS;
        }
        return null;
    }

    protected static GraphNavigation makeGraphNavigationAndCoordinateMap(CompositeSceneNode compositeSceneNode, HashMap<String, CoordinatesSceneNode> hashMap, boolean bl, NavigationInfo navigationInfo) {
        HashMap<String, FeaturePart> hashMap2 = new HashMap<String, FeaturePart>();
        String string = null;
        ArrayList<FeaturePart> arrayList = new ArrayList<FeaturePart>();
        ArrayList<FeaturePart> arrayList2 = new ArrayList<FeaturePart>();
        List<SceneNode> list = compositeSceneNode.getChildren();
        for (SceneNode sceneNode : list) {
            String string2;
            SceneNodeClassId sceneNodeClassId = ((SceneNodeImpl)sceneNode).getClassId();
            String string3 = sceneNode.getId();
            if (sceneNodeClassId == SceneNodeClassId.COORDINATES) {
                SceneHelper.addCoordsToMap(hashMap, (CoordinatesSceneNode)sceneNode);
                continue;
            }
            if (SceneNodeType.FACET == sceneNode.getType()) {
                SceneHelper.addFacetCoords((SceneNodeImpl)sceneNode, hashMap);
                continue;
            }
            if (!bl || !SceneIdUtil.isOutId(string3) || (string2 = SceneIdUtil.getGraphIndex(string3)) == null) continue;
            Point point = SceneHelper.getCenter(sceneNode);
            FeaturePart featurePart = new FeaturePart(string2, point);
            featurePart.setListX(arrayList);
            featurePart.setListY(arrayList2);
            hashMap2.put(string2, featurePart);
            if (string != null) continue;
            string = string2;
        }
        Object object = null;
        if (bl) {
            BasicFactory.sortList(arrayList, FeaturePartComparator.X);
            BasicFactory.sortList(arrayList2, FeaturePartComparator.Y);
            object = new GraphNavigation(hashMap2, navigationInfo.createCopy("G", false), string);
        }
        return object;
    }

    protected static Point getCenter(SceneNode sceneNode) {
        Rect rect = SceneHelper.getBounds(sceneNode);
        return rect == null ? null : rect.getCenter();
    }

    public static Rect getBounds(SceneNode sceneNode) {
        ShapeInfo shapeInfo = sceneNode.getShape();
        if (shapeInfo == null) {
            return null;
        }
        Rect rect = shapeInfo.getNodeBounds();
        TransformInfo transformInfo = sceneNode.getTransform();
        if (rect != null && transformInfo != null && transformInfo.getAffine() != null) {
            Affine affine = transformInfo.getAffine();
            rect = affine.transformBoundingBox(rect);
        }
        return rect;
    }

    protected static Point getCenterFromNodeOrChildren(SceneNode sceneNode) {
        Point point = SceneHelper.getCenter(sceneNode);
        return point == null ? SceneHelper.getCenterFromChildren(sceneNode) : point;
    }

    static Point getCenterFromChildren(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        Rect rect = null;
        for (SceneNode sceneNode2 : list) {
            Rect rect2 = SceneHelper.getBounds(sceneNode2);
            if (rect == null) {
                rect = rect2;
                continue;
            }
            if (rect2 == null) continue;
            rect = rect.copy();
            rect.extendToRect(rect2);
        }
        return rect == null ? null : rect.getCenter();
    }

    private static void addCoordsToMap(HashMap<String, CoordinatesSceneNode> hashMap, CoordinatesSceneNode coordinatesSceneNode) {
        String string = SceneIdUtil.getCoordinateKey(coordinatesSceneNode.getId());
        hashMap.put(string, coordinatesSceneNode);
    }

    private static void addFacetCoords(SceneNodeImpl sceneNodeImpl, HashMap<String, CoordinatesSceneNode> hashMap) {
        List<SceneNode> list = sceneNodeImpl.getChildren();
        if (list == null) {
            return;
        }
        for (SceneNode sceneNode : list) {
            if (SceneNodeClassId.COORDINATES == ((SceneNodeImpl)sceneNode).getClassId()) {
                SceneHelper.addCoordsToMap(hashMap, (CoordinatesSceneNode)sceneNode);
                continue;
            }
            if (SceneNodeType.FACET != sceneNode.getType()) continue;
            SceneHelper.addFacetCoords((SceneNodeImpl)sceneNode, hashMap);
        }
    }

    public static boolean isElementSymbol(String string) {
        return string != null && string.indexOf(S) > -1 && !SceneIdUtil.isHighlightShape(string);
    }

    public static boolean isElementLabel(String string) {
        return string != null && string.indexOf("L") > -1 && !SceneIdUtil.isLabelPlaque(string) && !SceneIdUtil.isLeaderLine(string);
    }

    public SceneHelper(Vis vis) {
        this.vis = vis;
    }

    public ElementsSpec getElementsSpec(String string) {
        String string2 = SceneIdUtil.getGraphIndex(string);
        int n = Integer.parseInt(string2.substring(1));
        Grammar[] grammarArray = this.vis.getGrammar();
        Grammar grammar = grammarArray[n];
        Integer n2 = SceneIdUtil.getIndexFromID(string, 'E');
        return grammar.elements[n2.intValue()].spec;
    }

    public Field getField(String string) {
        IdentifiableItem identifiableItem = this.vis.getByID(string);
        return identifiableItem instanceof Field ? (Field)identifiableItem : null;
    }

    private void populateRowMap(SceneNode sceneNode, HashMap<Double, String> hashMap, Field field) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
                this.populateRowMap(sceneNode2, hashMap, field);
                continue;
            }
            String string = sceneNode2.getId();
            if (!SceneHelper.isElementSymbol(string)) continue;
            Shape shape = (Shape)sceneNode2.getShape();
            int[] nArray = shape.getRows();
            hashMap.put(field.getRowValue(nArray[0]), string);
        }
    }

    public HashMap<Double, String> makeDataIdMap(SceneNode sceneNode, String string) {
        Field field = this.getIdField(string);
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        this.populateRowMap(sceneNode, hashMap, field);
        return hashMap;
    }

    private Field getIdField(String string) {
        ElementsSpec elementsSpec = this.getElementsSpec(string);
        LayoutSpec layoutSpec = elementsSpec.positioning;
        if (layoutSpec != null) {
            return this.getField(layoutSpec.id.$ref);
        }
        if (elementsSpec.position == null) {
            return null;
        }
        for (PositionSpec positionSpec : elementsSpec.position) {
            if (positionSpec.field == null) continue;
            return this.getField(positionSpec.field.$ref);
        }
        return null;
    }

    public Field getToField(String string) {
        ElementsSpec elementsSpec = this.getElementsSpec(string);
        if (elementsSpec != null && elementsSpec.positioning != null && elementsSpec.positioning.to != null) {
            return this.getField(elementsSpec.positioning.to.$ref);
        }
        return null;
    }

    public Field getFromField(String string) {
        ElementsSpec elementsSpec = this.getElementsSpec(string);
        if (elementsSpec != null && elementsSpec.positioning != null && elementsSpec.positioning.from != null) {
            return this.getField(elementsSpec.positioning.from.$ref);
        }
        return null;
    }

    public Field getSizeField(String string) {
        ElementsSpec elementsSpec = this.getElementsSpec(string);
        Object object = elementsSpec.positioning.size;
        return object != null && object instanceof FieldRefSpec ? this.getField(((FieldRefSpec)object).$ref) : null;
    }

    public TooltipProducer getTooltipProducer(String string, Field field) {
        ElementsSpec elementsSpec = this.getElementsSpec(string);
        if (elementsSpec.tooltip == null) {
            return null;
        }
        return new TooltipProducer(field.data, this.vis, null, elementsSpec.tooltip[0]);
    }
}

