/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.navigation;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.internal.navigation.GraphNavigation;
import com.ibm.vis.interaction.internal.navigation.NavigationInfo;
import com.ibm.vis.interaction.navigation.FeatureShift;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SceneMap {
    private final HashMap<String, NavigationInfo> featureMap;
    private NavigationInfo first;
    private GraphNavigation graphNavigation;

    SceneMap(HashMap<String, NavigationInfo> hashMap, NavigationInfo navigationInfo, GraphNavigation graphNavigation) {
        this.featureMap = hashMap;
        this.first = navigationInfo;
        this.graphNavigation = graphNavigation;
    }

    public GraphNavigation getGraphNavigation() {
        return this.graphNavigation;
    }

    public String nextFeature(String string, FeatureShift featureShift) {
        NavigationInfo navigationInfo;
        if (featureShift == null) {
            return string;
        }
        NavigationInfo navigationInfo2 = this.featureMap.get(string);
        if (navigationInfo2 == null) {
            return this.getFirstFeature();
        }
        NavigationInfo navigationInfo3 = navigationInfo = FeatureShift.NEXT == featureShift ? navigationInfo2.getNext() : navigationInfo2.getPrevious();
        if (navigationInfo == null) {
            navigationInfo = navigationInfo2;
        }
        return navigationInfo.getBaseId();
    }

    public String getFirstFeature() {
        if (this.first == null) {
            return null;
        }
        return this.first.getBaseId();
    }

    protected NavigationInfo getInfo(String string) {
        return this.featureMap.get(string);
    }

    protected void setNotNavigable(String string) {
        NavigationInfo navigationInfo = this.featureMap.get(string);
        if (navigationInfo == null) {
            return;
        }
        NavigationInfo navigationInfo2 = navigationInfo.getNext();
        NavigationInfo navigationInfo3 = navigationInfo.getPrevious();
        if (navigationInfo == this.first) {
            this.first = navigationInfo2;
        }
        if (navigationInfo2 != null && navigationInfo3 != null) {
            navigationInfo3.setNext(navigationInfo2);
            navigationInfo2.setPrevious(navigationInfo3);
        }
    }
}

