/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.internal.util;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import java.util.ArrayList;
import java.util.Arrays;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PipelineUtil {
    public static Object[] getSpecPathForSceneItem(Interactivity interactivity, SceneItem sceneItem, MatchingMethod matchingMethod) {
        if (matchingMethod.equals((Object)MatchingMethod.DATA)) {
            return PipelineUtil.getDataSpecPath(sceneItem);
        }
        String string = sceneItem.getType();
        if (string.equals("element")) {
            return PipelineUtil.getSpecPathForElement(interactivity, sceneItem);
        }
        if (string.equals("axis")) {
            return PipelineUtil.getSpecPathForAxis(interactivity, sceneItem);
        }
        if (string.equals("legend")) {
            return PipelineUtil.getSpecPathForLegend(sceneItem);
        }
        if (string.equals("coordinates")) {
            return PipelineUtil.getSpecPathForCoordinates(sceneItem);
        }
        return null;
    }

    private static Object[] getDataSpecPath(SceneItem sceneItem) {
        Object[] objectArray = new Object[]{"data", sceneItem.getDataIndex(), "rows", sceneItem.getRows()[0]};
        return objectArray;
    }

    private static boolean isFacetedItem(Interactivity interactivity, SceneItem sceneItem) {
        return PipelineUtil.isFacetedGrammar(interactivity, sceneItem.grammarIndex()) && sceneItem.facetIndex() == null;
    }

    private static boolean isFacetedGrammar(Interactivity interactivity, Integer n) {
        return interactivity != null && n != null && ((InteractivityImpl)interactivity).getVisInstance().getGrammar()[n].isFacetChart();
    }

    private static Object[] createFacetSpecPath(Integer n) {
        Object[] objectArray = new Object[]{"grammar", n, "facet"};
        return objectArray;
    }

    private static Object[] createElementSpecPath(SceneItem sceneItem) {
        Object[] objectArray = new Object[]{"grammar", sceneItem.grammarIndex(), "elements", sceneItem.elementIndex()};
        if (sceneItem.subType().equals("label")) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length + 1);
            objectArray[objectArray.length - 1] = "label";
        }
        return objectArray;
    }

    private static Object[] createAxisSpecPath(SceneItem sceneItem) {
        Object[] objectArray = new Object[]{"grammar", sceneItem.grammarIndex(), "coordinates", "dimensions", sceneItem.dimensionIndex(), "axis"};
        return objectArray;
    }

    private static Object[] getSpecPathForElement(Interactivity interactivity, SceneItem sceneItem) {
        if (PipelineUtil.isFacetedItem(interactivity, sceneItem)) {
            return PipelineUtil.createFacetSpecPath(sceneItem.grammarIndex());
        }
        return PipelineUtil.createElementSpecPath(sceneItem);
    }

    private static Object[] getSpecPathForAxis(Interactivity interactivity, SceneItem sceneItem) {
        if (PipelineUtil.isFacetedItem(interactivity, sceneItem)) {
            return PipelineUtil.createFacetSpecPath(sceneItem.grammarIndex());
        }
        return PipelineUtil.createAxisSpecPath(sceneItem);
    }

    private static Object[] getSpecPathForLegend(SceneItem sceneItem) {
        Object[] objectArray = new Object[]{"legends", sceneItem.legendIndex()};
        return objectArray;
    }

    private static Object[] getSpecPathForCoordinates(SceneItem sceneItem) {
        Object[] objectArray = new Object[]{"grammar", sceneItem.grammarIndex(), "coordinates"};
        return objectArray;
    }

    public static SceneItem[] getSceneItemsForSpecPath(Interactivity interactivity, Object[] objectArray, MatchingMethod matchingMethod) {
        if (matchingMethod.equals((Object)MatchingMethod.DATA)) {
            return interactivity.getItemsForRows(PipelineUtil.rowIndexOfSpecPath(objectArray));
        }
        SceneItem[] sceneItemArray = interactivity.getAllItems(true);
        ArrayList<SceneItem> arrayList = new ArrayList<SceneItem>();
        boolean bl = false;
        int n = PipelineUtil.grammarIndexOfSpecPath(objectArray);
        if (n != -1) {
            bl = PipelineUtil.isFacetedGrammar(interactivity, n);
        }
        Object[] objectArray2 = PipelineUtil.simplifySpecPath(objectArray);
        for (int i = 0; i < sceneItemArray.length; ++i) {
            SceneItem sceneItem = sceneItemArray[i];
            if (!PipelineUtil.itemInSpecPath(interactivity, sceneItem, objectArray2, bl, matchingMethod)) continue;
            arrayList.add(sceneItem);
        }
        return arrayList.toArray(new SceneItem[0]);
    }

    private static int[] rowIndexOfSpecPath(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals("rows") || objectArray.length <= i + 1) continue;
            int[] nArray = new int[]{(Integer)objectArray[i + 1]};
            return nArray;
        }
        int[] nArray = new int[]{-1};
        return nArray;
    }

    private static int grammarIndexOfSpecPath(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals("grammar") || objectArray.length <= i + 1) continue;
            return (Integer)objectArray[i + 1];
        }
        return -1;
    }

    private static Object[] trimPath(Object[] objectArray, int n) {
        if (objectArray.length > n + 2) {
            return Arrays.copyOfRange(objectArray, 0, n + 2);
        }
        return Arrays.copyOfRange(objectArray, 0, n + 1);
    }

    private static Object[] simplifySpecPath(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals("legends") || objectArray[i].equals("dimensions")) {
                return PipelineUtil.trimPath(objectArray, i);
            }
            if (!objectArray[i].equals("elements")) continue;
            if (objectArray.length > i + 2 && objectArray[i + 2].equals("label")) {
                return Arrays.copyOfRange(objectArray, 0, i + 3);
            }
            return PipelineUtil.trimPath(objectArray, i);
        }
        return objectArray;
    }

    private static boolean itemInSpecPath(Interactivity interactivity, SceneItem sceneItem, Object[] objectArray, boolean bl, MatchingMethod matchingMethod) {
        Object[] objectArray2 = PipelineUtil.getSpecPathForSceneItem(interactivity, sceneItem, matchingMethod);
        if (objectArray2 == null || objectArray2.length < objectArray.length) {
            return false;
        }
        if (bl && sceneItem.facetIndex() == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static enum MatchingMethod {
        DECLARATION,
        DATA;

    }
}

