/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.SpecClass;
import com.ibm.vis.internal.SpecClassInfo;
import com.ibm.vis.internal.SpecVar;
import java.util.List;
import java.util.Map;

public abstract class AbstractMappedJSONObject {
    private Object cached = null;

    public String getClassName() {
        return "";
    }

    public void setCachedObject(Object object) {
        this.cached = object;
    }

    public Object getCachedObject() {
        return this.cached;
    }

    protected void setJSON(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.readJSON(jSONObject);
        }
    }

    protected Map<String, String[]> getSpecClassDynamicTypes() {
        return null;
    }

    public static AbstractMappedJSONObject createSpecObjectFromType(JSONObject jSONObject, String string) {
        MappedJSONObject mappedJSONObject = null;
        try {
            MappedJSONObject mappedJSONObject2 = MappedJSONObject.createSpecInstanceFromType(string);
            mappedJSONObject2.setJSON(jSONObject);
            mappedJSONObject = mappedJSONObject2;
        }
        catch (Exception exception) {
            throw new SpecException("Cannot create specification class of type " + string, ErrorCode.SPEC_INVALID_VALUE, null);
        }
        return mappedJSONObject;
    }

    protected void readJSON(JSONObject jSONObject) {
        if (BasicFactory.isEmpty(jSONObject)) {
            return;
        }
        SpecClass specClass = SpecClassInfo.getInstance().getSpecClass(this.getClassName());
        List<SpecVar> list = specClass.getVars();
        for (SpecVar specVar : list) {
            int n = specVar.getArrayDepth();
            boolean bl = n > 0;
            boolean bl2 = n == 2;
            String string = specVar.getName();
            String string2 = specVar.getJavaType();
            Object object = BasicFactory.getItem(jSONObject, string);
            if (object == null) continue;
            try {
                MappedJSONObject mappedJSONObject;
                if (string2.equals("String") || object instanceof String) {
                    if (!bl) {
                        this.set(string, object);
                        continue;
                    }
                    this.set(string, this.toStringArray((JSONArray)object));
                    continue;
                }
                if (string2.equals("Boolean") || object instanceof Boolean) {
                    if (!bl) {
                        this.set(string, object);
                        continue;
                    }
                    this.set(string, this.toBooleanArray((JSONArray)object));
                    continue;
                }
                if (string2.equals("Number") || object instanceof Number) {
                    if (!bl) {
                        this.set(string, object);
                        continue;
                    }
                    this.set(string, this.toNumberArray((JSONArray)object, bl2));
                    continue;
                }
                if (string2.equals("Integer") || BasicFactory.isInteger(object)) {
                    if (!bl) {
                        this.set(string, object);
                        continue;
                    }
                    this.set(string, this.toIntegerArray((JSONArray)object));
                    continue;
                }
                if (string2.equals("double")) {
                    if (!bl) {
                        this.set(string, object);
                        continue;
                    }
                    if (!bl2) continue;
                    this.set(string, MappedJSONObject.toDoubleArray((JSONArray)object));
                    continue;
                }
                String string3 = this.getDynamicType(string, (JSONArtifact)object);
                String string4 = string3 = string3 != null ? string3 : string2;
                if (!bl) {
                    if (string3.equals("Object")) {
                        this.set(string, object);
                        continue;
                    }
                    mappedJSONObject = this.createSpecInstance(string3);
                    mappedJSONObject.setJSON((JSONObject)object);
                    this.set(string, mappedJSONObject);
                    continue;
                }
                mappedJSONObject = null;
                if (BasicFactory.isArray(object)) {
                    mappedJSONObject = (JSONArray)object;
                } else if (BasicFactory.isObject(object)) {
                    mappedJSONObject = BasicFactory.createJSONArray();
                    BasicFactory.add((JSONArray)mappedJSONObject, object);
                }
                this.set(string, this.toObjectArray((JSONArray)mappedJSONObject, string3, string));
            }
            catch (Exception exception) {
                throw new SpecException("Error reading VisJSON specification property.", ErrorCode.SPEC_PARSE_FAIL, this.getClass().getName() + "." + string);
            }
        }
    }

    protected String getDynamicType(String string, JSONArtifact jSONArtifact) {
        Map<String, String[]> map = this.getSpecClassDynamicTypes();
        if (map == null) {
            return null;
        }
        String[] stringArray = map.get(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (BasicFactory.isObject(jSONArtifact)) {
            for (String string2 : stringArray) {
                if (!AbstractMappedJSONObject.matchesClass(string2, (JSONObject)jSONArtifact)) continue;
                return string2;
            }
        }
        return null;
    }

    private static boolean matchesClass(String string, JSONObject jSONObject) {
        SpecClass specClass = SpecClassInfo.getInstance().getSpecClass(string);
        if (specClass != null) {
            List<String> list = specClass.getFieldNames();
            String[] stringArray = BasicFactory.keySet(jSONObject);
            int n = stringArray.length;
            if (n > list.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (list.contains(stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public MappedJSONObject copy() {
        MappedJSONObject mappedJSONObject = this.createInstance();
        SpecClass specClass = SpecClassInfo.getInstance().getSpecClass(this.getClassName());
        List<SpecVar> list = specClass.getVars();
        for (SpecVar specVar : list) {
            Object object = this.getFieldValue(specVar);
            if (object == null) continue;
            Object object2 = this.cloneField(object, specVar.getArrayDepth() > 0);
            this.setFieldValue(specVar, mappedJSONObject, object2);
        }
        return mappedJSONObject;
    }

    protected abstract Object cloneField(Object var1, boolean var2);

    protected abstract MappedJSONObject createInstance();

    protected abstract MappedJSONObject createSpecInstance(String var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException;

    protected abstract Object getFieldValue(SpecVar var1);

    protected abstract void setFieldValue(SpecVar var1, Object var2, Object var3);

    protected abstract void set(String var1, Object var2);

    protected abstract Object toObjectArray(JSONArray var1, String var2, String var3) throws IllegalAccessException, InstantiationException;

    protected abstract Object toNumberArray(JSONArray var1, boolean var2);

    protected abstract Boolean[] toBooleanArray(JSONArray var1);

    protected abstract String[] toStringArray(JSONArray var1);

    protected abstract Integer[] toIntegerArray(JSONArray var1);
}

