/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.label.Tooltip;
import com.ibm.vis.engine.internal.grammar.label.TooltipProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibilityBuilder {
    public static final String Y = "y";
    public static final String X = "x";
    private static final String GRIDLINE = "gridLine";
    private static final String AXISLABEL = "axisLabel";
    private static final String SIZE = "size";
    private static final String TO = "to";

    public static String ParseLocalizationString(String string, String string2, int n) {
        return string.replace("{" + n + "}", string2);
    }

    public String getTitleLabel(String string) {
        return string == null ? null : string + Internationalization.getString("comma") + Internationalization.getString(SceneNodeTypeUtil.toString(SceneNodeType.TITLE));
    }

    public String getAxisTitleLabel(String string, String string2) {
        String string3 = this.getAxisDimensionKey(string);
        return string2 + Internationalization.getString("comma") + Internationalization.getString(string3);
    }

    protected AccessibleInfo getAccessibleInfo(SceneNode sceneNode) {
        AccessibleInfo accessibleInfo = ((SceneNodeImpl)sceneNode).getA11y();
        if (accessibleInfo == null) {
            accessibleInfo = new AccessibleInfo();
            ((SceneNodeImpl)sceneNode).setA11y(accessibleInfo);
        }
        return accessibleInfo;
    }

    public String makeLabel(String string, String string2) {
        return string + Internationalization.getString("comma") + string2;
    }

    public String getGridlineBase() {
        return Internationalization.getString(GRIDLINE);
    }

    public String getAxisLabel() {
        return Internationalization.getString(AXISLABEL);
    }

    public String getAxisBase(SceneNode sceneNode) {
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        String string2 = this.getAxisDimensionKey(string);
        return Internationalization.getString(string2);
    }

    public String getAxisDimensionKey(String string) {
        Integer n = SceneIdUtil.getIndexFromID(string, 'A');
        String string2 = n == null || n != 0 ? X : Y;
        return string2;
    }

    protected String getLabelFromValue(String string, Field field, Number number) {
        String string2 = number == null ? Internationalization.getString("noValue") : field.getFormattedStringValue(number.doubleValue(), 0, null);
        return string == null ? string2 : string2 + Internationalization.getString("comma") + string;
    }

    public String getElementGroupLabel() {
        return Internationalization.getString(SceneNodeTypeUtil.toString(SceneNodeType.ELEMENT));
    }

    public String getTextFromChild(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                if (sceneNode2.getShape().getTextInfo() == null) continue;
                return sceneNode2.getShape().getTextInfo().getText();
            }
        }
        return sceneNode.getShape().getTextInfo().getText();
    }

    public String makeChordLabel(Field field, Field field2, Field field3, Shape shape, TooltipProducer tooltipProducer) {
        String string;
        Tooltip tooltip;
        StringBuilder stringBuilder = new StringBuilder();
        if (tooltipProducer != null && (tooltip = tooltipProducer.makeTooltip(shape)) != null) {
            string = tooltip.getRegularTooltip();
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(Internationalization.getString("comma"));
        }
        int n = shape.getRows()[0];
        string = Internationalization.getString(TO);
        string = AccessibilityBuilder.ParseLocalizationString(string, field.getFormattedValue(n), 1);
        string = AccessibilityBuilder.ParseLocalizationString(string, field2.getFormattedValue(n), 2);
        stringBuilder.append(string);
        if (field3 != null) {
            string = Internationalization.getString(SIZE);
            string = AccessibilityBuilder.ParseLocalizationString(string, field3.getFormattedValue(n), 1);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

