/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.internal.accessibility.ControlAction;
import com.ibm.vis.internal.accessibility.Target;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AccessibilityInfo {
    private static final String BUTTON = "button";
    private static final String TOOLTIP = "tooltip";
    private static final String TREE_ITEM = "treeitem";
    private static final String TARGET_TITLE = "title";
    private static final String OPEN_POPUP_HINT_KEY = "openPopupHint";
    private static final String CLOSE_POPUP_HINT_KEY = "closePopupHint";
    private static final String TREE_COLLAPSE_HINT_KEY = "treeCollapseHint";
    private static final String TREE_EXPAND_HINT_KEY = "treeExpandHint";
    private static final String TOOLTIP_HINT_KEY = "tooltipHint";
    private static final String DRAG_HINT_KEY = "dragHint";
    private static final String Y_KEY = "y";
    private static final String X_KEY = "x";
    private static final String LEGEND_KEY = "legend";
    private static final String LEGEND_ENTRY_KEY = "legendEntry";
    private static final String GRIDLINE_KEY = "gridLine";
    private static final String TITLE_KEY = "title";
    private static final String ELEMENT_KEY = "element";
    private static final String COMMA = "comma";
    private String comma;

    public String getRole(ControlAction controlAction) {
        String string = BUTTON;
        switch (controlAction) {
            case CLOSE_POPUP: 
            case OPEN_POPUP: {
                string = BUTTON;
                break;
            }
            case TREE_CONTROL_COLLAPSE: 
            case TREE_CONTROL_EXPAND: {
                string = TREE_ITEM;
                break;
            }
            case TOOLTIP: {
                string = TOOLTIP;
                break;
            }
            case TARGET_ROLE_TITLE: {
                string = "title";
                break;
            }
        }
        return string;
    }

    public String getHint(ControlAction controlAction) {
        String string = null;
        switch (controlAction) {
            case CLOSE_POPUP: {
                string = CLOSE_POPUP_HINT_KEY;
                break;
            }
            case OPEN_POPUP: {
                string = OPEN_POPUP_HINT_KEY;
                break;
            }
            case TREE_CONTROL_COLLAPSE: {
                string = TREE_COLLAPSE_HINT_KEY;
                break;
            }
            case TREE_CONTROL_EXPAND: {
                string = TREE_EXPAND_HINT_KEY;
                break;
            }
            case TOOLTIP: {
                string = TOOLTIP_HINT_KEY;
                break;
            }
            case NODE_DRAG: {
                string = DRAG_HINT_KEY;
                break;
            }
        }
        String string2 = string == null ? null : Internationalization.getString(string);
        return string2;
    }

    public String getLabelBase(Target target, Integer n) {
        String string = null;
        switch (target) {
            case AXIS_LABEL: {
                string = n == null || n != 0 ? X_KEY : Y_KEY;
                break;
            }
            case AXIS_TITLE: {
                string = n == null || n != 0 ? X_KEY : Y_KEY;
                this.setComma();
                return Internationalization.getString(string) + this.comma + Internationalization.getString("title");
            }
            case ELEMENT: 
            case ELEMENT_LABEL: {
                string = ELEMENT_KEY;
                break;
            }
            case GRID_LINE: {
                string = GRIDLINE_KEY;
                break;
            }
            case LEGEND_ENTRY: {
                string = LEGEND_ENTRY_KEY;
                break;
            }
            case LEGEND_TITLE: {
                string = LEGEND_KEY;
                break;
            }
            case TITLE: {
                string = "title";
                break;
            }
        }
        String string2 = string == null ? null : Internationalization.getString(string);
        return string2;
    }

    private void setComma() {
        if (this.comma == null) {
            this.comma = Internationalization.getString(COMMA);
        }
    }
}

