/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.facet.AbstractFaceting;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import com.ibm.vis.engine.internal.nativeImpl.Internationalization;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.scenemodifier.SceneModifier;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.navigation.FeatureType;
import com.ibm.vis.interaction.internal.navigation.SceneHelper;
import com.ibm.vis.internal.accessibility.AccessibilityBuilder;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.internal.accessibility.ChordChartModifier;
import com.ibm.vis.internal.accessibility.CoordinateSummarizer;
import com.ibm.vis.internal.accessibility.FieldSummarizer;
import com.ibm.vis.internal.accessibility.Summarizer;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.AugmentSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibilitySceneModifier
extends SceneModifier {
    private static final String T = "T";
    private static final String FACET = "facet";
    private static final String STACK_GROUP = "stackGroup";
    private static final String CLUSTER_GROUP = "clusterGroup";
    private static final String GROUP = "group";
    private final Vis vis;
    private final AccessibilityBuilder builder;
    private final SceneHelper helper;

    public AccessibilitySceneModifier(Vis vis) {
        this.vis = vis;
        this.builder = new AccessibilityBuilder();
        this.helper = new SceneHelper(vis);
    }

    @Override
    public void modifyScene(SceneTree sceneTree) {
        if (sceneTree == null) {
            return;
        }
        sceneTree.finalizeTree();
        int n = sceneTree.getRoot().getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = sceneTree.getRoot().getChild(i);
            this.addAccessibility(sceneNode, sceneTree);
        }
    }

    private void addAccessibility(SceneNode sceneNode, SceneTree sceneTree) {
        FeatureType featureType = SceneHelper.getFeatureType(sceneNode);
        if (featureType == null) {
            return;
        }
        switch (featureType) {
            case AXIS: {
                this.addDefaultsToAxis(sceneNode);
                break;
            }
            case ELEMENT: {
                this.addAccessibilityToElement(sceneNode);
                break;
            }
            case FACET: {
                this.addDefaultsToFacet(sceneNode, sceneTree);
                break;
            }
            case GRIDLINE: {
                this.addDefaultsToGridLines(sceneNode, sceneTree);
                break;
            }
            case LEGEND: {
                this.addDefaultsToLegends(sceneNode);
                break;
            }
            case TITLE: {
                this.addDefaultToTitle(sceneNode);
                break;
            }
        }
    }

    private void addDefaultsToFacet(SceneNode sceneNode, SceneTree sceneTree) {
        this.addFacetLabel(sceneNode);
        SceneTree sceneTree2 = new SceneTree();
        sceneTree2.copyInfoFrom(sceneTree);
        for (SceneNode sceneNode2 : ((CompositeSceneNode)sceneNode).getChildren()) {
            sceneTree2.getRoot().addChild(sceneNode2);
        }
        List<SceneNode> list = this.getLegends(sceneTree);
        int n = list.size();
        if (n > 0) {
            for (SceneNode sceneNode3 : list) {
                sceneTree2.getRoot().addChild(sceneNode3);
            }
        }
        this.modifyScene(sceneTree2);
    }

    private void addFacetLabel(SceneNode sceneNode) {
        String string;
        AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
        String string2 = (String)accessibleInfo.getProperty(FACET);
        String string3 = this.getFacetLabel(string2, string = SceneIdUtil.getBaseIdForSceneNode(sceneNode));
        string3 = string3 == null ? Internationalization.getString(FACET) : string3;
        this.addIfMissing("label", string3, sceneNode);
    }

    private String getFacetLabel(String string, String string2) {
        Grammar grammar = this.getGrammarForId(string2);
        if (grammar == null) {
            return null;
        }
        AbstractFaceting abstractFaceting = (AbstractFaceting)grammar.faceting;
        FacetField[] facetFieldArray = abstractFaceting.getFacetFields();
        String[] stringArray = string.split(BasicFactory.getRegExBarString());
        if (stringArray.length != facetFieldArray.length) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            Number number = IntegerUtil.parseInt(stringArray[i], 10);
            Field field = facetFieldArray[i].getField();
            if (i > 0) {
                stringBuilder.append(Internationalization.getString("comma"));
            }
            String string3 = field.label == null ? field.id : field.label;
            stringBuilder.append(string3).append(" ");
            stringBuilder.append(this.builder.getLabelFromValue(null, field, number));
        }
        return stringBuilder.toString();
    }

    private Grammar getGrammarForId(String string) {
        String string2 = SceneIdUtil.getGraphIndex(string);
        if (string2 == null) {
            return null;
        }
        string2 = string2.substring(1);
        int n = IntegerUtil.parseInt(string2, 10).intValue();
        return this.vis.getGrammar()[n];
    }

    private List<SceneNode> getLegends(SceneTree sceneTree) {
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        int n = sceneTree.getRoot().getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = sceneTree.getRoot().getChild(i);
            if (SceneHelper.getFeatureType(sceneNode) != FeatureType.LEGEND) continue;
            arrayList.add(sceneNode);
        }
        return arrayList;
    }

    private void addAccessibilityToElement(SceneNode sceneNode) {
        this.addElementAccessibilityForFields(sceneNode);
        this.addIfMissing("label", this.builder.getElementGroupLabel(), sceneNode);
        this.addLinkInfoIfNeeded((ElementGroupSceneNode)sceneNode);
    }

    private void addLinkInfoIfNeeded(ElementGroupSceneNode elementGroupSceneNode) {
        String string = elementGroupSceneNode.getLink();
        if (string == null) {
            return;
        }
        if (string.equals("*")) {
            ChordChartModifier chordChartModifier = new ChordChartModifier(this.builder, this.helper);
            chordChartModifier.addChordAccessibility(elementGroupSceneNode);
            return;
        }
        List<SceneNode> list = elementGroupSceneNode.getParent().getChildren();
        for (SceneNode sceneNode : list) {
            String string2 = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
            if (!string2.equals(string)) continue;
            String string3 = SceneIdUtil.getBaseIdForSceneNode(elementGroupSceneNode);
            if (string3 == null) break;
            Field field = this.helper.getFromField(string3);
            Field field2 = this.helper.getToField(string3);
            if (field == null || field2 == null) break;
            HashMap<Double, String> hashMap = this.helper.makeDataIdMap(sceneNode, string);
            this.addLinkInfo(elementGroupSceneNode, hashMap, field, field2);
            AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(elementGroupSceneNode);
            accessibleInfo.setStringProperty("linkFrom", string2);
            break;
        }
    }

    private void addLinkInfo(SceneNode sceneNode, HashMap<Double, String> hashMap, Field field, Field field2) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getType() == SceneNodeType.ELEMENT) {
                this.addLinkInfo(sceneNode2, hashMap, field, field2);
                continue;
            }
            if (!SceneHelper.isElementSymbol(sceneNode2.getId())) continue;
            Shape shape = (Shape)sceneNode2.getShape();
            int n = shape.getRows()[0];
            String string = hashMap.get(field2.getRowValue(n));
            String string2 = hashMap.get(field.getRowValue(n));
            if (string == null || string2 == null) continue;
            AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode2);
            accessibleInfo.setStringProperty("linkFrom", string2);
            accessibleInfo.setStringProperty("linkTo", string);
        }
    }

    protected int getIntRowValue(Field field, SceneNode sceneNode) {
        int[] nArray;
        ShapeInfo shapeInfo = sceneNode.getShape();
        int[] nArray2 = nArray = shapeInfo == null || shapeInfo.getElementInfo() == null ? null : shapeInfo.getElementInfo().getRows();
        if (nArray == null) {
            return 0;
        }
        int n = (int)Math.round(field.getRowValue(nArray[0]));
        return n;
    }

    private void addElementAccessibilityForFields(SceneNode sceneNode) {
        HashMap<String, Summarizer> hashMap = new HashMap<String, Summarizer>();
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        if (string != null) {
            this.addFieldsFromElementSpec(hashMap, string);
        }
        this.addFieldSummaries(sceneNode, string, hashMap, "fieldSummary", true);
        this.cleanupGroupSceneItem(sceneNode, "field", false, null);
        if (!sceneNode.getChildren().isEmpty() && "interval".equals(((ElementGroupSceneNode)sceneNode).getElementType())) {
            Grammar grammar = this.getGrammarForId(string);
            if (grammar.coordinates.containsStacking() && !grammar.coordinates.containsPolar()) {
                this.addGroupSums(sceneNode, string, grammar, false);
            }
            if (grammar.coordinates.containsCluster()) {
                this.addGroupSums(sceneNode, string, grammar, true);
            }
        }
    }

    public void addGroupSums(SceneNode sceneNode, String string, Grammar grammar, boolean bl) {
        Field field = this.getSumField(grammar, string, bl);
        if (!(field == null || field.isCategorical() || field.unit != null && Unit.isTime(field.unit))) {
            this.addSumInfo(sceneNode, field, bl, true);
        }
    }

    private Field getSumField(Grammar grammar, String string, boolean bl) {
        Integer n = SceneIdUtil.getIndexFromID(string, 'E');
        ElementsSpec elementsSpec = grammar.elements[n.intValue()].spec;
        int n2 = grammar.coordinates.spec.dimensions.length;
        PositionSpec[] positionSpecArray = elementsSpec.position;
        if (positionSpecArray == null) {
            return null;
        }
        int n3 = bl ? 0 : (n2 < 2 ? positionSpecArray.length - 1 : positionSpecArray.length - 2);
        FieldValueRefSpec fieldValueRefSpec = positionSpecArray[n3].field;
        return fieldValueRefSpec == null ? null : (Field)this.vis.getByID(fieldValueRefSpec.$ref);
    }

    private double addSumInfo(SceneNode sceneNode, Field field, boolean bl, boolean bl2) {
        Object object;
        boolean bl3 = true;
        double d = 0.0;
        for (SceneNode object2 : sceneNode.getChildren()) {
            Double d2;
            if (object2.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
                d += this.addSumInfo(object2, field, bl, false);
                bl3 = false;
                continue;
            }
            object = object2.getShape();
            int[] nArray = object == null || object.getElementInfo() == null ? null : object.getElementInfo().getRows();
            if (nArray == null || (d2 = Double.valueOf(field.getRowValue(nArray[0]))) == null || Double.isNaN(d2)) continue;
            d += ((Number)d2).doubleValue();
        }
        if (bl3 || bl && !bl2) {
            String string = field.getFormattedStringValue(d, 0, null);
            AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
            object = bl ? "clusterSum" : "stackSum";
            accessibleInfo.setStringProperty((String)object, string);
        }
        return d;
    }

    private void addFieldsFromElementSpec(Map<String, Summarizer> map, String string) {
        Object object;
        ElementsSpec elementsSpec = this.helper.getElementsSpec(string);
        this.addAesthetics(elementsSpec, map);
        this.addLabelFields(elementsSpec.label, map);
        PositionSpec[] positionSpecArray = elementsSpec.position;
        if (positionSpecArray != null) {
            Object object2;
            if ("area".equals(elementsSpec.type) || "line".equals(elementsSpec.type)) {
                object = Internationalization.getString(elementsSpec.type);
                object2 = new CoordinateSummarizer(positionSpecArray, this.helper, (String)object);
                map.put(((Summarizer)object2).getName(), (Summarizer)object2);
            } else {
                for (int i = 0; i < positionSpecArray.length; ++i) {
                    object2 = positionSpecArray[i].field;
                    if (object2 == null) continue;
                    this.addFieldToMap(map, ((FieldValueRefSpec)object2).$ref);
                }
            }
        }
        if ((object = this.getAugmentKeys(elementsSpec)) != null) {
            for (FieldRefSpec fieldRefSpec : object) {
                this.addFieldToMap(map, fieldRefSpec.$ref);
            }
        }
    }

    public void addFieldToMap(Map<String, Summarizer> map, String string) {
        Field field = this.helper.getField(string);
        if (field != null) {
            FieldSummarizer fieldSummarizer = new FieldSummarizer(field);
            map.put(string, fieldSummarizer);
        }
    }

    private FieldRefSpec[] getAugmentKeys(ElementsSpec elementsSpec) {
        if (elementsSpec.position == null && elementsSpec.positioning == null) {
            AugmentSpec[] augmentSpecArray;
            VisJSONSpec visJSONSpec = this.vis.getCurrentSpec();
            if (visJSONSpec.augment == null) {
                return null;
            }
            for (AugmentSpec augmentSpec : augmentSpecArray = visJSONSpec.augment) {
                if (augmentSpec.dataKeys == null) continue;
                return augmentSpec.dataKeys;
            }
        }
        return null;
    }

    private void addLabelFields(ElementLabelSpec[] elementLabelSpecArray, Map<String, Summarizer> map) {
        if (elementLabelSpecArray == null) {
            return;
        }
        for (ElementLabelSpec elementLabelSpec : elementLabelSpecArray) {
            for (Object object : elementLabelSpec.content) {
                Field field;
                String string;
                Summarizer summarizer;
                if (!(object instanceof FieldValueRefSpec) || (summarizer = map.get(string = ((FieldValueRefSpec)object).$ref)) != null || (field = this.helper.getField(string)) == null) continue;
                summarizer = new FieldSummarizer(field);
            }
        }
    }

    private void addAesthetics(ElementsSpec elementsSpec, Map<String, Summarizer> map) {
        this.addToFieldMap(elementsSpec.color, map);
        this.addToFieldMap(elementsSpec.dashing, map);
        this.addToFieldMap(elementsSpec.size, map);
        this.addToFieldMap(elementsSpec.split, map);
        this.addToFieldMap(elementsSpec.styleBy, map);
        this.addToFieldMap(elementsSpec.symbol, map);
    }

    private void addToFieldMap(AestheticSpec[] aestheticSpecArray, Map<String, Summarizer> map) {
        String string;
        Field field;
        if (aestheticSpecArray != null && aestheticSpecArray.length > 0 && aestheticSpecArray[0].field != null && aestheticSpecArray[0].field.$ref != null && (field = this.helper.getField(string = aestheticSpecArray[0].field.$ref)) != null) {
            map.put(string, new FieldSummarizer(field));
        }
    }

    private void cleanupGroupSceneItem(SceneNode sceneNode, String string, boolean bl, Map<String, FieldSummarizer> map) {
        AccessibleInfo accessibleInfo = ((SceneNodeImpl)sceneNode).getA11y();
        if (accessibleInfo == null) {
            accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
            String string2 = this.builder.getElementGroupLabel();
            accessibleInfo.setStringProperty("label", string2);
            return;
        }
        String[] stringArray = bl ? (String[])accessibleInfo.getProperty(string) : null;
        accessibleInfo.setProperty(string, null);
        if (stringArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : stringArray) {
                FieldSummarizer fieldSummarizer = map.get(string3);
                if (fieldSummarizer == null) continue;
                arrayList.add(fieldSummarizer.getName());
            }
            accessibleInfo.setProperty(string, arrayList);
        }
    }

    private void addFieldSummaries(SceneNode sceneNode, String string, Map<String, Summarizer> map, String string2, boolean bl) {
        List<SceneNode> list;
        if (map.size() == 0) {
            return;
        }
        if (!bl) {
            this.makeLabelFromChildrenRows(sceneNode, string, map);
        }
        int n = (list = sceneNode.getChildren()) == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
            if (SceneNodeClassId.ELEMENT_GROUP == sceneNode2.getClassId()) {
                this.addFieldSummaries(sceneNode2, string, map, string2, false);
                continue;
            }
            if (SceneIdUtil.isLeaderLine(sceneNode2.getId())) continue;
            this.addDescriptionsFromFields(sceneNode2, map, string2);
        }
    }

    private void makeLabelFromChildrenRows(SceneNode sceneNode, String string, Map<String, Summarizer> map) {
        AccessibleInfo accessibleInfo;
        Map map2;
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        this.addRows(sceneNode, intPrimitiveArrayList);
        Set<String> set = map.keySet();
        Object[] objectArray = set.toArray(new String[set.size()]);
        BasicFactory.sortArray(objectArray);
        int[] nArray = intPrimitiveArrayList.toArray();
        StringBuilder stringBuilder = new StringBuilder();
        AccessibleInfo accessibleInfo2 = this.builder.getAccessibleInfo(sceneNode);
        HashMap<String, String> hashMap = (HashMap<String, String>)accessibleInfo2.getProperty("fieldSummary");
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            accessibleInfo2.setProperty("fieldSummary", hashMap);
        }
        if ((map2 = (Map)(accessibleInfo = this.builder.getAccessibleInfo(((SceneNodeImpl)sceneNode).getParent())).getProperty("fieldSummary")) != null) {
            hashMap.putAll(map2);
        }
        boolean bl = true;
        for (Object object : objectArray) {
            String string2;
            Summarizer summarizer = map.get(object);
            String string3 = summarizer.getName();
            if (map2 != null && map2.get(string3) != null || (string2 = summarizer.getCategoryForRows(nArray)) == null) continue;
            if (!bl) {
                stringBuilder.append(Internationalization.getString("comma"));
            }
            hashMap.put(string3, string2);
            stringBuilder.append(string3).append(": ").append(string2);
            bl = false;
        }
        if (bl) {
            if (hashMap.isEmpty()) {
                accessibleInfo2.getProperties().remove("fieldSummary");
                Grammar grammar = this.getGrammarForId(string);
                if (grammar.coordinates.containsStacking()) {
                    accessibleInfo2.setStringProperty("label", Internationalization.getString(STACK_GROUP));
                } else if (grammar.coordinates.containsCluster()) {
                    accessibleInfo2.setStringProperty("label", Internationalization.getString(CLUSTER_GROUP));
                } else {
                    accessibleInfo2.setStringProperty("label", Internationalization.getString(GROUP));
                }
            }
        } else {
            accessibleInfo2.setStringProperty("label", stringBuilder.toString());
        }
    }

    private void addRows(SceneNode sceneNode, IntPrimitiveArrayList intPrimitiveArrayList) {
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
                this.addRows(sceneNode2, intPrimitiveArrayList);
                continue;
            }
            ShapeInfo shapeInfo = sceneNode2.getShape();
            int[] nArray = shapeInfo == null || shapeInfo.getElementInfo() == null ? null : shapeInfo.getElementInfo().getRows();
            if (nArray == null) continue;
            for (int n : nArray) {
                intPrimitiveArrayList.add(n);
            }
        }
    }

    private void addDescriptionsFromFields(SceneNode sceneNode, Map<String, Summarizer> map, String string) {
        ShapeInfo shapeInfo;
        int[] nArray;
        AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
        HashMap<String, Object> hashMap = (HashMap<String, Object>)accessibleInfo.getProperty(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            accessibleInfo.setProperty(string, hashMap);
        }
        int[] nArray2 = nArray = (shapeInfo = sceneNode.getShape()) == null || shapeInfo.getElementInfo() == null ? null : shapeInfo.getElementInfo().getRows();
        if (nArray != null) {
            Set<String> set = map.keySet();
            Object[] objectArray = set.toArray(new String[set.size()]);
            BasicFactory.sortArray(objectArray);
            for (Object object : objectArray) {
                Summarizer summarizer = map.get(object);
                String string2 = this.getUnique(summarizer.getName(), hashMap);
                Object object2 = summarizer.getForRows(nArray);
                if (object2 == null) {
                    object2 = Internationalization.getString("noValue");
                }
                hashMap.put(string2, object2);
            }
        }
    }

    private String getUnique(String string, Map map) {
        if (map.containsKey(string)) {
            for (int i = 2; i < 9999; ++i) {
                if (map.containsKey(i)) continue;
                return string + "_" + i;
            }
        }
        return string;
    }

    private void addDefaultsToLegends(SceneNode sceneNode) {
        List<SceneNode> list;
        Field field = this.getField(sceneNode.getField());
        String string = null;
        if (field != null) {
            string = field.label == null ? field.id : field.label;
            this.addBaseValue("field", string, sceneNode);
        }
        if ((list = sceneNode.getChildren()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string2;
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                SceneNodeType sceneNodeType = sceneNode2.getType();
                if (SceneNodeType.TITLE != sceneNodeType || (string2 = this.builder.getTextFromChild(sceneNode2)) == null) continue;
                string2 = string2.length() == 0 ? Internationalization.getString("legend") : string2;
                this.addIfMissing("label", string2, sceneNode);
                return;
            }
        }
    }

    private void addDefaultsToAxis(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                String string = sceneNode2.getId();
                if (string != null && string.indexOf(T) > 0) {
                    object = this.builder.getAxisTitleLabel(sceneNode2.getId(), sceneNode2.getShape().getTextInfo().getText());
                    this.addIfMissing("label", (String)object, sceneNode);
                    this.addIfMissing("label", (String)object, sceneNode2);
                    continue;
                }
                if (SceneNodeType.AXIS_LABEL != sceneNode2.getType() || ((SceneNodeImpl)sceneNode2).getA11y() != null) continue;
                object = new AccessibleInfo();
                ((AccessibleInfo)object).setStringProperty("label", this.builder.getAxisLabel());
                ((SceneNodeImpl)sceneNode2).setA11y((AccessibleInfo)object);
            }
        }
        String string = this.builder.getAxisBase(sceneNode);
        this.addIfMissing("label", string, sceneNode);
    }

    private void addDefaultToTitle(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                String string = sceneNode2.getId();
                if (string.indexOf("LB") >= 0) continue;
                String string2 = this.builder.getTitleLabel(sceneNode2.getShape().getTextInfo().getText());
                this.addIfMissing("label", string2, sceneNode);
            }
        } else {
            String string = this.builder.getTitleLabel(sceneNode.getShape().getTextInfo().getText());
            this.addIfMissing("label", string, sceneNode);
        }
    }

    private Map<String, SceneNode> makeAxesLabelMap(String string, SceneTree sceneTree) {
        Object object;
        SceneNode sceneNode = null;
        SceneNode sceneNode2 = this.getFeature(FeatureType.AXIS, string, sceneTree);
        if (sceneNode2 != null) {
            object = sceneNode2.getChildren();
            Iterator<SceneNode> iterator = object.iterator();
            while (iterator.hasNext()) {
                SceneNode sceneNode3 = iterator.next();
                if (sceneNode3.getType() != SceneNodeType.AXIS_LABEL) continue;
                sceneNode = sceneNode3;
                break;
            }
        }
        if (sceneNode == null || sceneNode.getChildren().isEmpty()) {
            return null;
        }
        object = new HashMap();
        for (SceneNode sceneNode3 : sceneNode.getChildren()) {
            String string2 = sceneNode3.getId();
            int n = string2.indexOf(84);
            ((HashMap)object).put(string2.substring(n + 1), sceneNode3);
        }
        return object;
    }

    private SceneNode getFeature(FeatureType featureType, String string, SceneTree sceneTree) {
        int n = sceneTree.getRoot().getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = sceneTree.getRoot().getChild(i);
            if (SceneHelper.getFeatureType(sceneNode) != featureType || !string.equals(SceneIdUtil.getBaseIdForSceneNode(sceneNode))) continue;
            return sceneNode;
        }
        return null;
    }

    private void addDefaultsToGridLines(SceneNode sceneNode, SceneTree sceneTree) {
        String string = SceneIdUtil.getBaseIdForSceneNode(sceneNode);
        String string2 = string.substring(0, string.length() - 1);
        Map<String, SceneNode> map = this.makeAxesLabelMap(string2, sceneTree);
        if (map == null) {
            return;
        }
        String string3 = this.builder.getGridlineBase();
        this.addIfMissing("label", string3, sceneNode);
        int n = string2.length() + 1;
        List<SceneNode> list = sceneNode.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                String string4 = sceneNode2.getId();
                String string5 = string4.substring(n);
                SceneNode sceneNode3 = map.get(string5);
                if (sceneNode3 == null || sceneNode3.getShape() == null || sceneNode3.getShape().getTextInfo() == null) continue;
                String string6 = sceneNode3.getShape().getTextInfo().getText();
                this.addIfMissing("label", string6, sceneNode2);
            }
        }
    }

    private void addIfMissing(String string, String string2, SceneNode sceneNode) {
        AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
        if (accessibleInfo.getProperty(string) == null) {
            accessibleInfo.setStringProperty(string, string2);
        }
    }

    private void addBaseValue(String string, String string2, SceneNode sceneNode) {
        AccessibleInfo accessibleInfo = this.builder.getAccessibleInfo(sceneNode);
        AccessibleInfo accessibleInfo2 = (AccessibleInfo)accessibleInfo.getProperty("base");
        if (accessibleInfo2 == null) {
            accessibleInfo2 = new AccessibleInfo();
            accessibleInfo.setProperty("base", accessibleInfo2);
        }
        accessibleInfo2.setProperty(string, string2);
    }

    private Field getField(String string) {
        IdentifiableItem identifiableItem = this.vis.getByID(string);
        return identifiableItem instanceof Field ? (Field)identifiableItem : null;
    }
}

