/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.AccessibilityStateSpec;
import com.ibm.vis.spec.internal.AccessibilityStyleSpec;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import java.util.HashSet;

@OnDemandLoad(value="com/ibm/vis/layers/advancedAccessibility")
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibilityValidation {
    public static void addAccessibility(SceneNode sceneNode, AccessibilityStyleSpec accessibilityStyleSpec, boolean bl) {
        if (accessibilityStyleSpec == null) {
            return;
        }
        AccessibilityValidation.validateAccessibilityStyleSpec(accessibilityStyleSpec);
        AccessibleInfo accessibleInfo = new AccessibleInfo();
        accessibleInfo.fromStyle(accessibilityStyleSpec);
        if (bl) {
            AccessibleInfo accessibleInfo2 = new AccessibleInfo();
            accessibleInfo2.setProperty("base", accessibleInfo);
            accessibleInfo = accessibleInfo2;
        }
        ((SceneNodeImpl)sceneNode).setA11y(accessibleInfo);
    }

    public static void validateAccessibilityStyleSpec(AccessibilityStyleSpec accessibilityStyleSpec) {
        if (accessibilityStyleSpec == null) {
            return;
        }
        if (accessibilityStyleSpec.state != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (AccessibilityStateSpec accessibilityStateSpec : accessibilityStyleSpec.state) {
                if (accessibilityStateSpec.key == null || accessibilityStateSpec.value == null) {
                    throw new SpecException("In accessibility styles, all state properties must have both key and value", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                if (!AccessibleInfo.isBooleanProperty(accessibilityStateSpec.key)) {
                    throw new SpecException("In accessibility styles, '" + accessibilityStateSpec.key + "' may not be used as a state property", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                if (hashSet.contains(accessibilityStateSpec.key)) {
                    throw new SpecException("In accessibility styles, keys must all be distinct; key '" + accessibilityStateSpec.key + "' is duplicated", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                hashSet.add(accessibilityStateSpec.key);
            }
        }
    }

    public static void validateAccessibilityAestheticSpec(VisInterface visInterface, AestheticSpec aestheticSpec) {
        boolean bl;
        if (aestheticSpec.key == null) {
            throw new SpecException("Accessibility aesthetic must have a 'key'", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        boolean bl2 = aestheticSpec.value != null;
        boolean bl3 = bl = aestheticSpec.field != null && aestheticSpec.field.$ref != null;
        if (!bl2 && !bl || bl2 && bl) {
            throw new SpecException("Accessibility aesthetic must have a 'field' or 'value' but not both", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (bl) {
            IdentifiableItem identifiableItem = visInterface.getByID(aestheticSpec.field.$ref);
            if (!(identifiableItem instanceof Field)) {
                throw new SpecException("Accessibility aesthetic 'field' with ID '" + aestheticSpec.field.$ref + "' does not exist", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            if (aestheticSpec.palette != null && !((Field)identifiableItem).isCategorical()) {
                throw new SpecException("Accessibility aesthetics with a palette may not be based on a continuous field", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
        boolean bl4 = AccessibleInfo.isStringProperty(aestheticSpec.key);
        boolean bl5 = AccessibleInfo.isBooleanProperty(aestheticSpec.key);
        if (!bl4 && !bl5) {
            throw new SpecException("Accessibility aesthetic 'key' '" + aestheticSpec.key + "' is not a legal key", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (aestheticSpec.modifies != null && !BasicFactory.isString(aestheticSpec.modifies)) {
            ModifiesSpec modifiesSpec = (ModifiesSpec)aestheticSpec.modifies;
            if (modifiesSpec.part != null) {
                throw new SpecException("Accessibility aesthetics may not use modifies.part", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
        AccessibilityValidation.validateMapping(aestheticSpec, bl4);
        AccessibilityValidation.validatePalette(aestheticSpec, bl4);
        if (aestheticSpec.nullValue != null) {
            if (bl4) {
                if (!BasicFactory.isString(aestheticSpec.nullValue) && !BasicFactory.isNumber(aestheticSpec.nullValue)) {
                    throw new SpecException("The accessibility aesthetic nullValue for key '" + aestheticSpec.key + "' must be a string or number", ErrorCode.SPEC_INVALID_VALUE, null);
                }
            } else if (!BasicFactory.isBoolean(aestheticSpec.nullValue)) {
                throw new SpecException("The accessibility aesthetic nullValue for key '" + aestheticSpec.key + "' must be a boolean", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
    }

    private static void validateMapping(AestheticSpec aestheticSpec, boolean bl) {
        if (aestheticSpec.mapping == null) {
            return;
        }
        if (bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (MappingSpec mappingSpec : aestheticSpec.mapping) {
                if (mappingSpec == null) continue;
                if (mappingSpec.text != null && mappingSpec.value != null || mappingSpec.state != null) {
                    throw new SpecException("The accessibility aesthetic mapping for key '" + aestheticSpec.key + "' may use 'text' or 'value' but not both, and may not use 'state'", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                if (mappingSpec.text != null) {
                    bl2 = true;
                }
                if (mappingSpec.value == null) continue;
                bl3 = true;
            }
            if (bl2 && bl3) {
                throw new SpecException("The accessibility aesthetic mapping for key '" + aestheticSpec.key + "' has a mix of 'text' and 'value', all stops must use the same property", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        } else {
            for (MappingSpec mappingSpec : aestheticSpec.mapping) {
                if (mappingSpec == null || mappingSpec.text == null && mappingSpec.value == null) continue;
                throw new SpecException("The accessibility aesthetic palette values for key '" + aestheticSpec.key + "' may use 'state', but not 'text' or 'value'", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
    }

    private static void validatePalette(AestheticSpec aestheticSpec, boolean bl) {
        if (aestheticSpec.palette == null) {
            return;
        }
        if (bl) {
            for (Object object : aestheticSpec.palette) {
                if (object == null || BasicFactory.isString(object) || BasicFactory.isNumber(object)) continue;
                throw new SpecException("The accessibility aesthetic palette values for key '" + aestheticSpec.key + "' must be strings or numbers", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        } else {
            for (Object object : aestheticSpec.palette) {
                if (object == null || BasicFactory.isBoolean(object)) continue;
                throw new SpecException("The accessibility aesthetic palette values for key '" + aestheticSpec.key + "' must be booleans", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
    }
}

