/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.AccessibilityStateSpec;
import com.ibm.vis.spec.internal.AccessibilityStyleSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibleInfo {
    public static final String ACCESSIBILITY = "accessibility";
    public static final String BASE = "base";
    public static final String GROUP = "group";
    public static final String FIELD = "field";
    public static final String LABEL = "label";
    public static final String ROLE = "role";
    public static final String HINT = "hint";
    public static final String IGNORE = "ignore";
    public static final String STATE = "state";
    public static final String SUMMARY = "fieldSummary";
    public static final String FACET = "facet";
    public static final String STACK_SUM = "stackSum";
    public static final String CLUSTER_SUM = "clusterSum";
    public static final String LINK_FROM = "linkFrom";
    public static final String LINK_TO = "linkTo";
    public static final String CHORD_FROM_VALUE = "chordFrom";
    public static final String CHORD_TO_VALUE = "chordTo";
    public static final String SIMPLE_LABEL = "simpleLabel";
    public static final String TYPE = "type";
    private static final Set<String> stringPropertyNames = new HashSet<String>();
    private static final Set<String> reservedPropertyNames;
    private final HashMap<String, Object> propertyMap = new HashMap();

    public static boolean isStringProperty(String string) {
        return stringPropertyNames.contains(string);
    }

    public static boolean isBooleanProperty(String string) {
        return !reservedPropertyNames.contains(string) && AccessibleInfo.isLegalKey(string);
    }

    public static boolean isLegalKey(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public void setLabelToBaseIfMissing() {
        if (this.propertyMap.containsKey(LABEL) || !this.propertyMap.containsKey(BASE)) {
            return;
        }
        AccessibleInfo accessibleInfo = (AccessibleInfo)this.propertyMap.get(BASE);
        this.propertyMap.put(LABEL, accessibleInfo.getStringProperty(LABEL));
    }

    public static AccessibleInfo makeCopy(AccessibleInfo accessibleInfo) {
        if (accessibleInfo == null) {
            return null;
        }
        return accessibleInfo.copy();
    }

    public AccessibleInfo copy() {
        AccessibleInfo accessibleInfo = new AccessibleInfo();
        accessibleInfo.propertyMap.putAll(this.propertyMap);
        return accessibleInfo;
    }

    public AccessibleInfo combine(AccessibleInfo accessibleInfo) {
        AccessibleInfo accessibleInfo2 = this.copy();
        if (accessibleInfo != null) {
            accessibleInfo2.propertyMap.putAll(accessibleInfo.propertyMap);
        }
        return accessibleInfo2;
    }

    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    private void clear() {
        this.propertyMap.clear();
    }

    public void fromStyle(AccessibilityStyleSpec accessibilityStyleSpec) {
        this.clear();
        if (accessibilityStyleSpec != null) {
            if (accessibilityStyleSpec.label != null) {
                this.propertyMap.put(LABEL, accessibilityStyleSpec.label);
            }
            if (accessibilityStyleSpec.role != null) {
                this.propertyMap.put(ROLE, accessibilityStyleSpec.role);
            }
            if (accessibilityStyleSpec.hint != null) {
                this.propertyMap.put(HINT, accessibilityStyleSpec.hint);
            }
            if (accessibilityStyleSpec.ignore != null) {
                this.propertyMap.put(IGNORE, accessibilityStyleSpec.ignore);
            }
            if (accessibilityStyleSpec.state != null) {
                for (AccessibilityStateSpec accessibilityStateSpec : accessibilityStyleSpec.state) {
                    this.propertyMap.put(accessibilityStateSpec.key, accessibilityStateSpec.value);
                }
            }
        }
    }

    public void setBooleanProperty(String string, Boolean bl) {
        if (!AccessibleInfo.isBooleanProperty(string)) {
            return;
        }
        if (bl == null) {
            this.propertyMap.remove(string);
        } else {
            this.propertyMap.put(string, bl);
        }
    }

    public final Boolean getBooleanProperty(String string) {
        if (!AccessibleInfo.isBooleanProperty(string)) {
            return null;
        }
        return (Boolean)this.propertyMap.get(string);
    }

    public void setStringProperty(String string, String string2) {
        if (stringPropertyNames.contains(string)) {
            if (string2 == null) {
                this.propertyMap.remove(string);
            } else {
                this.propertyMap.put(string, string2);
            }
        }
    }

    public final String getStringProperty(String string) {
        return stringPropertyNames.contains(string) ? (String)this.propertyMap.get(string) : null;
    }

    public final void setProperty(String string, Object object) {
        if (reservedPropertyNames.contains(string)) {
            if (object == null) {
                this.propertyMap.remove(string);
            } else {
                this.propertyMap.put(string, object);
            }
        }
    }

    public final Object getProperty(String string) {
        return this.propertyMap.get(string);
    }

    public final Map<String, Object> getProperties() {
        return this.propertyMap;
    }

    public void addJSON(JSONObject jSONObject) {
        String[] stringArray;
        if (jSONObject == null) {
            return;
        }
        for (String string : stringArray = BasicFactory.keySet(jSONObject)) {
            AccessibleInfo accessibleInfo;
            Object object = BasicFactory.getItem(jSONObject, string);
            if (STATE.equals(string)) {
                this.addJSON((JSONObject)object);
                continue;
            }
            if (BASE.equals(string)) {
                accessibleInfo = new AccessibleInfo();
                if (BasicFactory.isString(object)) {
                    accessibleInfo.setStringProperty(LABEL, (String)object);
                } else {
                    accessibleInfo.addJSON((JSONObject)object);
                }
                this.propertyMap.put(string, accessibleInfo);
                continue;
            }
            if (SUMMARY.equals(string)) {
                accessibleInfo = new AccessibleInfo();
                if (BasicFactory.isString(object)) {
                    accessibleInfo.setStringProperty(LABEL, (String)object);
                    this.propertyMap.put(string, accessibleInfo);
                    continue;
                }
                if (object == null) continue;
                String string2 = AccessibleInfo.makeLabelFromSummary(object);
                this.propertyMap.put(string, string2);
                continue;
            }
            this.propertyMap.put(string, object);
        }
    }

    protected String getLabelFromSummary(String string) {
        Object object = this.getProperty(SUMMARY);
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = this.labelFromSummaryMap(string, object);
        return stringBuilder.toString();
    }

    protected StringBuilder labelFromSummaryMap(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        Map map = (Map)object;
        Object[] objectArray = map.keySet().toArray();
        BasicFactory.sortArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            StringBuilder stringBuilder2;
            if (i != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i]).append(": ");
            Object v = map.get(objectArray[i]);
            StringBuilder stringBuilder3 = AccessibleInfo.makeLabelFromSimple(v);
            if (stringBuilder3 != null) {
                stringBuilder.append(stringBuilder3.toString());
                continue;
            }
            if (v == null || (stringBuilder2 = this.labelFromSummaryMap(string, v)) == null) continue;
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder;
    }

    private static String makeLabelFromSummary(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = BasicFactory.keySet(object);
        BasicFactory.sortArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append((String)objectArray[i] + " ");
            Object object2 = BasicFactory.getItem(object, (String)objectArray[i]);
            StringBuilder stringBuilder2 = AccessibleInfo.makeLabelFromSimple(object2);
            if (stringBuilder2 != null) {
                stringBuilder.append(stringBuilder2.toString());
                continue;
            }
            if (object2 == null) continue;
            String string = AccessibleInfo.makeLabelFromSummary(object2);
            stringBuilder = new StringBuilder(string);
        }
        return stringBuilder.toString();
    }

    private static StringBuilder makeLabelFromSimple(Object object) {
        StringBuilder stringBuilder = null;
        if (BasicFactory.isString(object)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
        } else if (BasicFactory.isNumber(object)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(object.toString());
        } else if (BasicFactory.isArray(object)) {
            stringBuilder = new StringBuilder();
            for (int i = 0; i < BasicFactory.getJSONArraySize((JSONArray)object); ++i) {
                if (i > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append((String)BasicFactory.getArrayItem((JSONArray)object, i));
            }
        }
        return stringBuilder;
    }

    static {
        stringPropertyNames.add(LABEL);
        stringPropertyNames.add(ROLE);
        stringPropertyNames.add(HINT);
        stringPropertyNames.add(STACK_SUM);
        stringPropertyNames.add(CLUSTER_SUM);
        stringPropertyNames.add(LINK_FROM);
        stringPropertyNames.add(LINK_TO);
        stringPropertyNames.add(SIMPLE_LABEL);
        stringPropertyNames.add(TYPE);
        reservedPropertyNames = new HashSet<String>();
        reservedPropertyNames.addAll(stringPropertyNames);
        reservedPropertyNames.add(ACCESSIBILITY);
        reservedPropertyNames.add(STATE);
        reservedPropertyNames.add(GROUP);
        reservedPropertyNames.add(FIELD);
        reservedPropertyNames.add(BASE);
        reservedPropertyNames.add(SUMMARY);
        reservedPropertyNames.add(FACET);
        reservedPropertyNames.add(STACK_SUM);
        reservedPropertyNames.add(CLUSTER_SUM);
        reservedPropertyNames.add(LINK_FROM);
        reservedPropertyNames.add(LINK_TO);
        reservedPropertyNames.add(CHORD_FROM_VALUE);
        reservedPropertyNames.add(CHORD_TO_VALUE);
        reservedPropertyNames.add(SIMPLE_LABEL);
        reservedPropertyNames.add(TYPE);
    }
}

