/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.internal.accessibility;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.internal.accessibility.AtLink;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibleNode {
    private static int uidCounter = 0;
    private static final String ID_BASE = "raveA11y_";
    private final ArrayList<AccessibleNode> children;
    private AccessibleInfo info;
    private String sceneId;
    private ArrayList<String> labelIds;
    private String treeId;
    private ArrayList<AtLink> links;

    public AccessibleNode(AccessibleInfo accessibleInfo, String string) {
        this.info = accessibleInfo == null ? new AccessibleInfo() : accessibleInfo;
        this.children = new ArrayList();
        this.sceneId = string;
    }

    public final String getAtTreeId() {
        if (this.treeId == null) {
            this.treeId = ID_BASE + uidCounter++;
        }
        return this.treeId;
    }

    public final AccessibleInfo getAccessible() {
        return this.info;
    }

    public final void setAccessible(AccessibleInfo accessibleInfo) {
        this.info = accessibleInfo;
    }

    public final ArrayList<AccessibleNode> getChildren() {
        return this.children;
    }

    public final void addChild(AccessibleNode accessibleNode) {
        this.children.add(accessibleNode);
    }

    public final void setSceneId(String string) {
        this.sceneId = string;
    }

    final void addLink(AtLink atLink) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        this.links.add(atLink);
    }

    public final ArrayList<AtLink> getAtLinks() {
        return this.links;
    }

    public ArrayList<String> getSceneIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.sceneId != null) {
            arrayList.add(this.sceneId);
        }
        for (AccessibleNode accessibleNode : this.children) {
            arrayList.addAll(accessibleNode.getSceneIds());
        }
        if (this.labelIds != null) {
            arrayList.addAll(this.labelIds);
        }
        return arrayList;
    }

    public String getSceneId() {
        return this.sceneId;
    }

    protected void mergeLabel(AccessibleNode accessibleNode, String string) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList();
        }
        this.labelIds.add(accessibleNode.getSceneId());
        String string2 = accessibleNode.info.getStringProperty("label");
        if (string2 == null) {
            return;
        }
        this.info.setStringProperty("simpleLabel", string2);
        String string3 = this.info.getStringProperty("label");
        if (string3 == null) {
            string3 = this.info.getLabelFromSummary(string);
        }
        string2 = string3 == null ? string2 : string2 + string + string3;
        this.info.setStringProperty("label", string2);
    }

    public String getLinkLabel() {
        String string = this.info.getStringProperty("simpleLabel");
        return string == null ? this.info.getStringProperty("label") : string;
    }
}

